/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.data.handler.base;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.ChangesetCollectionLocalServiceUtil;
import com.liferay.changeset.service.ChangesetEntryLocalServiceUtil;
import com.liferay.changeset.util.ChangesetThreadLocal;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.ExportImportContentProcessorRegistryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Collections;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class BaseStagedModelDataHandler<T extends StagedModel>
extends com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler<T> {
    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return;
        }
        stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public void deleteStagedModel(T stagedModel) throws PortalException {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return;
        }
        stagedModelRepository.deleteStagedModel(stagedModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        ChangesetEntry changesetEntry;
        super.exportStagedModel(portletDataContext, stagedModel);
        if (!ExportImportThreadLocal.isStagingInProcess()) {
            return;
        }
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element importDataElement = null;
        try {
            portletDataContext.setImportDataRootElement(portletDataContext.getExportDataRootElement());
            importDataElement = portletDataContext.getImportDataElement(stagedModel);
        }
        finally {
            portletDataContext.setImportDataRootElement(importDataRootElement);
        }
        if (importDataElement == null) {
            return;
        }
        ChangesetCollection changesetCollection = ChangesetCollectionLocalServiceUtil.fetchChangesetCollection((long)portletDataContext.getScopeGroupId(), (String)"RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        if (changesetCollection != null && (changesetEntry = ChangesetEntryLocalServiceUtil.fetchChangesetEntry((long)changesetCollection.getChangesetCollectionId(), (long)ClassNameLocalServiceUtil.getClassNameId((String)ExportImportClassedModelUtil.getClassName(stagedModel)), (long)((Long)stagedModel.getPrimaryKeyObj()))) != null) {
            ChangesetThreadLocal.addExportedChangesetEntryId((long)changesetEntry.getChangesetEntryId());
        }
    }

    public T fetchMissingReference(String uuid, long groupId) {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return (T)super.fetchMissingReference(uuid, groupId);
        }
        return stagedModelRepository.fetchMissingReference(uuid, groupId);
    }

    public T fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return (T)super.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        }
        return stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public List<T> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            return Collections.emptyList();
        }
        return stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelRepository<T> stagedModelRepository = this.getStagedModelRepository();
        if (stagedModelRepository == null) {
            super.restoreStagedModel(portletDataContext, stagedModel);
            return;
        }
        stagedModelRepository.restoreStagedModel(portletDataContext, stagedModel);
    }

    protected ExportImportContentProcessor<String> getExportImportContentProcessor(Class<T> clazz) {
        return ExportImportContentProcessorRegistryUtil.getExportImportContentProcessor(clazz.getName());
    }

    protected StagedModelRepository<T> getStagedModelRepository() {
        return null;
    }
}

