/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.staged.model.repository;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@ProviderType
public class StagedModelRepositoryRegistryUtil {
    private static final StagedModelRepositoryRegistryUtil _instance = new StagedModelRepositoryRegistryUtil();
    private final BundleContext _bundleContext;
    private final ServiceTracker<StagedModelRepository<?>, StagedModelRepository<?>> _serviceTracker;
    private final Map<String, StagedModelRepository<?>> _stagedModelRepositories = new ConcurrentHashMap();

    public static List<StagedModelRepository<?>> getStagedModelRepositories() {
        return _instance._getStagedModelRepositories();
    }

    public static StagedModelRepository<?> getStagedModelRepository(String className) {
        return _instance._getStagedModelRepository(className);
    }

    private StagedModelRepositoryRegistryUtil() {
        Bundle bundle = FrameworkUtil.getBundle(StagedModelRepositoryRegistryUtil.class);
        this._bundleContext = bundle.getBundleContext();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, StagedModelRepository.class, (ServiceTrackerCustomizer)new StagedModelRepositoryServiceTrackerCustomizer());
    }

    private List<StagedModelRepository<?>> _getStagedModelRepositories() {
        return ListUtil.fromCollection(this._stagedModelRepositories.values());
    }

    private StagedModelRepository<?> _getStagedModelRepository(String className) {
        return this._stagedModelRepositories.get(className);
    }

    private class StagedModelRepositoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<StagedModelRepository<?>, StagedModelRepository<?>> {
        private StagedModelRepositoryServiceTrackerCustomizer() {
        }

        public StagedModelRepository<?> addingService(ServiceReference<StagedModelRepository<?>> serviceReference) {
            StagedModelRepository stagedModelRepository = (StagedModelRepository)StagedModelRepositoryRegistryUtil.this._bundleContext.getService(serviceReference);
            String modelClassName = GetterUtil.getString((Object)serviceReference.getProperty("model.class.name"));
            StagedModelRepositoryRegistryUtil.this._stagedModelRepositories.put(modelClassName, stagedModelRepository);
            return stagedModelRepository;
        }

        public void modifiedService(ServiceReference<StagedModelRepository<?>> serviceReference, StagedModelRepository<?> xStreamConfigurator) {
            this.removedService(serviceReference, xStreamConfigurator);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<StagedModelRepository<?>> serviceReference, StagedModelRepository<?> xStreamConfigurator) {
            StagedModelRepositoryRegistryUtil.this._bundleContext.ungetService(serviceReference);
            String modelClassName = GetterUtil.getString((Object)serviceReference.getProperty("model.class.name"));
            StagedModelRepositoryRegistryUtil.this._stagedModelRepositories.remove(modelClassName);
        }
    }
}

