/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.web.internal.portlet;

import com.liferay.expando.kernel.exception.ColumnNameException;
import com.liferay.expando.kernel.exception.ColumnTypeException;
import com.liferay.expando.kernel.exception.DuplicateColumnNameException;
import com.liferay.expando.kernel.exception.NoSuchColumnException;
import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoColumnService;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-expando", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/expando.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.system=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Custom Fields", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_expando_web_portlet_ExpandoPortlet", "javax.portlet.portlet-mode=text/html", "javax.portlet.resource-bundle=content.Language"}, service={Portlet.class})
public class ExpandoPortlet
extends MVCPortlet {
    private ExpandoColumnService _expandoColumnService;
    @Reference
    private Portal _portal;

    public void addExpando(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        String dataType = ParamUtil.getString((PortletRequest)actionRequest, (String)"dataType");
        String precisionType = ParamUtil.getString((PortletRequest)actionRequest, (String)"precisionType");
        if (Validator.isNotNull((String)dataType) && Validator.isNotNull((String)precisionType)) {
            type = this._getNumberType(dataType, precisionType, type);
        }
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)themeDisplay.getCompanyId(), (String)modelResource, (long)resourcePrimKey);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        if (!Field.validateFieldName((String)name)) {
            throw new ColumnNameException.MustValidate();
        }
        expandoBridge.addAttribute(name, type);
        Serializable defaultValue = this.getDefaultValue(actionRequest, type);
        expandoBridge.setAttributeDefault(name, defaultValue);
        this.updateProperties(actionRequest, expandoBridge, name);
    }

    public void deleteExpando(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long columnId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"columnId");
        this._expandoColumnService.deleteColumn(columnId);
    }

    public void deleteExpandos(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] columnIds;
        for (long columnId : columnIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"columnIds"), (long)0L)) {
            this._expandoColumnService.deleteColumn(columnId);
        }
    }

    public void updateExpando(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePrimKey");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        Serializable defaultValue = this.getDefaultValue(actionRequest, type);
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)themeDisplay.getCompanyId(), (String)modelResource, (long)resourcePrimKey);
        expandoBridge.setAttributeDefault(name, defaultValue);
        this.updateProperties(actionRequest, expandoBridge, name);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)ColumnNameException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)ColumnTypeException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)DuplicateColumnNameException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)ValueDataException.class.getName())) {
            this.include("/edit/expando.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchColumnException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected Serializable getDefaultValue(ActionRequest actionRequest, int type) throws Exception {
        if (type == 21) {
            return JSONFactoryUtil.createJSONObject((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"defaultValue"));
        }
        if (type == 20) {
            return (Serializable)((Object)LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"defaultValueLocalized"));
        }
        return this.getValue((PortletRequest)actionRequest, "defaultValue", type);
    }

    protected Serializable getValue(PortletRequest portletRequest, String name, int type) throws PortalException {
        String delimiter = ",";
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)name);
        } else if (type != 2) {
            if (type == 3) {
                User user = this._portal.getUser(portletRequest);
                int valueDateMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(name + "Month"));
                int valueDateDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(name + "Day"));
                int valueDateYear = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(name + "Year"));
                int valueDateHour = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(name + "Hour"));
                int valueDateMinute = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(name + "Minute"));
                int valueDateAmPm = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(name + "AmPm"));
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                value = this._portal.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, user.getTimeZone(), ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble((PortletRequest)portletRequest, (String)name);
                } else if (type == 6) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat((PortletRequest)portletRequest, (String)name));
                } else if (type == 8) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger((PortletRequest)portletRequest, (String)name);
                } else if (type == 10) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong((PortletRequest)portletRequest, (String)name);
                } else if (type == 12) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber((PortletRequest)portletRequest, (String)name);
                } else if (type == 18) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort((PortletRequest)portletRequest, (String)name);
                } else if (type == 14) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    String[] values = StringUtil.split((String)paramValue, (String)delimiter);
                    value = GetterUtil.getShortValues((String[])values);
                } else if (type == 16) {
                    String paramValue = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                    if (paramValue.contains("\n")) {
                        delimiter = "\n";
                    }
                    value = StringUtil.split((String)paramValue, (String)delimiter);
                } else {
                    value = ParamUtil.getString((PortletRequest)portletRequest, (String)name);
                }
            }
        }
        return value;
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof ColumnNameException || cause instanceof ColumnTypeException || cause instanceof DuplicateColumnNameException || cause instanceof NoSuchColumnException || cause instanceof PrincipalException || cause instanceof ValueDataException;
    }

    @Reference(unbind="-")
    protected void setExpandoColumnService(ExpandoColumnService expandoColumnService) {
        this._expandoColumnService = expandoColumnService;
    }

    protected void updateProperties(ActionRequest actionRequest, ExpandoBridge expandoBridge, String name) throws Exception {
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"Property--");
        boolean searchable = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"searchable");
        if (!searchable) {
            properties.setProperty("index-type", String.valueOf(0));
        }
        expandoBridge.setAttributeProperties(name, properties);
    }

    private int _getNumberType(String dataType, String precisionType, int type) {
        if (dataType.equals("Decimal") && precisionType.equals("64-bit")) {
            if (type == 16) {
                return 6;
            }
            return 5;
        }
        if (dataType.equals("Decimal") && precisionType.equals("32-bit")) {
            if (type == 16) {
                return 8;
            }
            return 7;
        }
        if (dataType.equals("Integer") && precisionType.equals("64-bit")) {
            if (type == 16) {
                return 12;
            }
            return 11;
        }
        if (dataType.equals("Integer") && precisionType.equals("32-bit")) {
            if (type == 16) {
                return 10;
            }
            return 9;
        }
        if (dataType.equals("Integer") && precisionType.equals("16-bit")) {
            if (type == 16) {
                return 14;
            }
            return 13;
        }
        return 0;
    }
}

