/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.exportimport.internal.data.handler;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.adapter.StagedExpandoColumn;
import com.liferay.expando.kernel.model.adapter.StagedExpandoTable;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class StagedExpandoColumnStagedModelDataHandler
extends BaseStagedModelDataHandler<StagedExpandoColumn> {
    public static final String[] CLASS_NAMES = new String[]{StagedExpandoColumn.class.getName()};
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference(target="(model.class.name=com.liferay.expando.kernel.model.adapter.StagedExpandoColumn)")
    private StagedModelRepository<StagedExpandoColumn> _stagedModelRepository;

    public void deleteStagedModel(StagedExpandoColumn stagedExpandoColumn) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)stagedExpandoColumn);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public List<StagedExpandoColumn> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        List<StagedExpandoColumn> stagedExpandoColumns = this.fetchStagedModelsByUuidAndCompanyId(uuid, portletDataContext.getCompanyId());
        return !ListUtil.isEmpty(stagedExpandoColumns);
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, StagedExpandoColumn stagedExpandoColumn) throws Exception {
        ExpandoTable expandoTable = this._expandoTableLocalService.getTable(stagedExpandoColumn.getTableId());
        StagedExpandoTable stagedExpandoTable = (StagedExpandoTable)ModelAdapterUtil.adapt((Object)expandoTable, ExpandoTable.class, StagedExpandoTable.class);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedExpandoColumn, (StagedModel)stagedExpandoTable, (String)"parent");
        Element stagedExpandoColumnElement = portletDataContext.getExportDataElement((ClassedModel)stagedExpandoColumn);
        portletDataContext.addClassedModel(stagedExpandoColumnElement, ExportImportPathUtil.getModelPath((StagedModel)stagedExpandoColumn), (ClassedModel)stagedExpandoColumn);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        List<StagedExpandoColumn> stagedExpandoColumns = this.fetchStagedModelsByUuidAndCompanyId(uuid, portletDataContext.getCompanyId());
        if (ListUtil.isEmpty(stagedExpandoColumns)) {
            return;
        }
        StagedExpandoColumn existingStagedExpandoColumn = stagedExpandoColumns.get(0);
        Map columnIds = portletDataContext.getNewPrimaryKeysMap(ExpandoColumn.class);
        long columnId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        columnIds.put(columnId, existingStagedExpandoColumn.getColumnId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, StagedExpandoColumn stagedExpandoColumn) throws Exception {
        Map tableIds = portletDataContext.getNewPrimaryKeysMap(ExpandoTable.class);
        long tableId = MapUtil.getLong((Map)tableIds, (long)stagedExpandoColumn.getTableId(), (long)stagedExpandoColumn.getTableId());
        StagedExpandoColumn importedExpandoColumn = (StagedExpandoColumn)stagedExpandoColumn.clone();
        importedExpandoColumn.setTableId(tableId);
        List stagedExpandoColumns = this._stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(stagedExpandoColumn.getUuid(), portletDataContext.getCompanyId());
        if (ListUtil.isEmpty((List)stagedExpandoColumns)) {
            importedExpandoColumn = (StagedExpandoColumn)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedExpandoColumn);
        } else {
            StagedExpandoColumn existingExpandoColumn = (StagedExpandoColumn)stagedExpandoColumns.get(0);
            importedExpandoColumn.setColumnId(existingExpandoColumn.getColumnId());
            importedExpandoColumn = (StagedExpandoColumn)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedExpandoColumn);
        }
        portletDataContext.importClassedModel((ClassedModel)stagedExpandoColumn, (ClassedModel)importedExpandoColumn);
    }
}

