/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletPreferencesException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public abstract class DDMBaseMVCActionCommand
extends BaseMVCActionCommand {
    protected String getRedirect(ActionRequest actionRequest) {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
        if (Validator.isNull((String)closeRedirect)) {
            return redirect;
        }
        redirect = HttpUtil.setParameter((String)redirect, (String)"closeRedirect", (String)closeRedirect);
        SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".closeRedirect"), (Object)closeRedirect);
        return redirect;
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, DDMStructure structure, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String availableFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"availableFields");
        String eventName = ParamUtil.getString((PortletRequest)actionRequest, (String)"eventName");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)themeDisplay.getPpid(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_structure.jsp");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("groupId", String.valueOf(structure.getGroupId()), false);
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        portletURL.setParameter("classNameId", String.valueOf(classNameId), false);
        portletURL.setParameter("classPK", String.valueOf(structure.getStructureId()), false);
        portletURL.setParameter("availableFields", availableFields, false);
        portletURL.setParameter("eventName", eventName, false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, DDMTemplate template, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletResourceNamespace = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResourceNamespace");
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        String structureAvailableFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"structureAvailableFields");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)themeDisplay.getPpid(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_template.jsp");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("portletResourceNamespace", portletResourceNamespace, false);
        portletURL.setParameter("templateId", String.valueOf(template.getTemplateId()), false);
        portletURL.setParameter("groupId", String.valueOf(template.getGroupId()), false);
        portletURL.setParameter("classNameId", String.valueOf(classNameId), false);
        portletURL.setParameter("classPK", String.valueOf(classPK), false);
        portletURL.setParameter("type", template.getType(), false);
        portletURL.setParameter("structureAvailableFields", structureAvailableFields, false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected PortletPreferences getStrictPortletSetup(ActionRequest actionRequest) throws PortalException {
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getStrictPortletSetup(themeDisplay.getLayout(), portletResource);
    }

    protected PortletPreferences getStrictPortletSetup(Layout layout, String portletId) throws PortalException {
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            throw new PortletPreferencesException.MustBeStrict(portletId);
        }
        return portletPreferences;
    }

    protected void setRedirectAttribute(ActionRequest actionRequest) {
        String redirect = this.getRedirect(actionRequest);
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    protected void setRedirectAttribute(ActionRequest actionRequest, DDMStructure structure) throws Exception {
        String redirect = this.getRedirect(actionRequest);
        boolean saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue");
        if (saveAndContinue) {
            redirect = this.getSaveAndContinueRedirect(actionRequest, structure, redirect);
        }
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    protected void setRedirectAttribute(ActionRequest actionRequest, DDMTemplate template) throws Exception {
        String redirect = this.getRedirect(actionRequest);
        boolean saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue");
        if (saveAndContinue) {
            redirect = this.getSaveAndContinueRedirect(actionRequest, template, redirect);
        }
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    protected void updatePortletPreferences(ActionRequest actionRequest, DDMTemplate template) throws Exception {
        PortletPreferences portletPreferences = this.getStrictPortletSetup(actionRequest);
        if (portletPreferences == null) {
            return;
        }
        if (Objects.equals(template.getType(), "display")) {
            portletPreferences.setValue("displayDDMTemplateId", String.valueOf(template.getTemplateId()));
        } else if (Objects.equals(template.getMode(), "create")) {
            portletPreferences.setValue("formDDMTemplateId", String.valueOf(template.getTemplateId()));
        }
        portletPreferences.store();
    }
}

