/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.uad.display;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.uad.constants.DDMUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the DDMFormInstance UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in
 * {@link DDMFormInstanceUADDisplay}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseDDMFormInstanceUADDisplay
	extends BaseModelUADDisplay<DDMFormInstance> {

	@Override
	public DDMFormInstance get(Serializable primaryKey) throws PortalException {
		return ddmFormInstanceLocalService.getDDMFormInstance(
			Long.valueOf(primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] {"name", "description"};
	}

	@Override
	public Class<DDMFormInstance> getTypeClass() {
		return DDMFormInstance.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return ddmFormInstanceLocalService.dynamicQueryCount(dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return ddmFormInstanceLocalService.dynamicQuery();
	}

	@Override
	protected List<DDMFormInstance> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return ddmFormInstanceLocalService.dynamicQuery(
			dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return DDMUADConstants.USER_ID_FIELD_NAMES_DDM_FORM_INSTANCE;
	}

	@Reference
	protected DDMFormInstanceLocalService ddmFormInstanceLocalService;

}