/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.uad.constants.DDMUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDDMFormInstanceUADAnonymizer
extends DynamicQueryUADAnonymizer<DDMFormInstance> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected DDMFormInstanceLocalService ddmFormInstanceLocalService;

    public void autoAnonymize(DDMFormInstance ddmFormInstance, long userId, User anonymousUser) throws PortalException {
        if (ddmFormInstance.getUserId() == userId) {
            ddmFormInstance.setUserId(anonymousUser.getUserId());
            ddmFormInstance.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(ddmFormInstance, anonymousUser);
        }
        if (ddmFormInstance.getVersionUserId() == userId) {
            ddmFormInstance.setVersionUserId(anonymousUser.getUserId());
            ddmFormInstance.setVersionUserName(anonymousUser.getFullName());
        }
        this.ddmFormInstanceLocalService.updateDDMFormInstance(ddmFormInstance);
    }

    public void delete(DDMFormInstance ddmFormInstance) throws PortalException {
        this.ddmFormInstanceLocalService.deleteFormInstance(ddmFormInstance);
    }

    public Class<DDMFormInstance> getTypeClass() {
        return DDMFormInstance.class;
    }

    protected void autoAnonymizeAssetEntry(DDMFormInstance ddmFormInstance, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(ddmFormInstance);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.ddmFormInstanceLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return DDMUADConstants.USER_ID_FIELD_NAMES_DDM_FORM_INSTANCE;
    }

    protected AssetEntry fetchAssetEntry(DDMFormInstance ddmFormInstance) {
        return this.assetEntryLocalService.fetchEntry(DDMFormInstance.class.getName(), ddmFormInstance.getFormInstanceId());
    }
}

