/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.uad.display;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.uad.constants.DDMUADConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.user.associated.data.display.BaseModelUADDisplay;

import java.io.Serializable;

import java.util.List;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the DDMFormInstanceRecord UAD display.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom methods should be put in
 * {@link DDMFormInstanceRecordUADDisplay}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseDDMFormInstanceRecordUADDisplay
	extends BaseModelUADDisplay<DDMFormInstanceRecord> {

	@Override
	public DDMFormInstanceRecord get(Serializable primaryKey)
		throws PortalException {

		return ddmFormInstanceRecordLocalService.getDDMFormInstanceRecord(
			Long.valueOf(primaryKey.toString()));
	}

	@Override
	public String[] getDisplayFieldNames() {
		return new String[] {"version"};
	}

	@Override
	public Class<DDMFormInstanceRecord> getTypeClass() {
		return DDMFormInstanceRecord.class;
	}

	@Override
	protected long doCount(DynamicQuery dynamicQuery) {
		return ddmFormInstanceRecordLocalService.dynamicQueryCount(
			dynamicQuery);
	}

	@Override
	protected DynamicQuery doGetDynamicQuery() {
		return ddmFormInstanceRecordLocalService.dynamicQuery();
	}

	@Override
	protected List<DDMFormInstanceRecord> doGetRange(
		DynamicQuery dynamicQuery, int start, int end) {

		return ddmFormInstanceRecordLocalService.dynamicQuery(
			dynamicQuery, start, end);
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return DDMUADConstants.USER_ID_FIELD_NAMES_DDM_FORM_INSTANCE_RECORD;
	}

	@Reference
	protected DDMFormInstanceRecordLocalService
		ddmFormInstanceRecordLocalService;

}