/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.uad.display;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordModel;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.uad.display.BaseDDMFormInstanceRecordUADDisplay;
import com.liferay.dynamic.data.mapping.uad.display.DDMFormInstanceUADDisplay;
import com.liferay.dynamic.data.mapping.uad.util.DDMUADUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.display.UADDisplay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormInstanceRecordUADDisplay.class, UADDisplay.class})
public class DDMFormInstanceRecordUADDisplay
extends BaseDDMFormInstanceRecordUADDisplay {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordUADDisplay.class);
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    private final Map<Long, DDMFormInstanceRecordUADUserCache> _ddmFormInstanceRecordUADUserCacheMap = new HashMap<Long, DDMFormInstanceRecordUADUserCache>();
    @Reference
    private DDMFormInstanceUADDisplay _ddmFormInstanceUADDisplay;
    @Reference
    private Portal _portal;

    public String getEditURL(DDMFormInstanceRecord ddmFormInstanceRecord, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        HttpServletRequest httpServletRequest = liferayPortletRequest.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletNamespace = this._portal.getPortletNamespace("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet");
        return this._portal.getSiteAdminURL(themeDisplay, "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet", (Map)HashMapBuilder.put((Object)portletNamespace.concat("formInstanceId"), (Object)new String[]{String.valueOf(ddmFormInstanceRecord.getFormInstanceId())}).put((Object)portletNamespace.concat("formInstanceRecordId"), (Object)new String[]{String.valueOf(ddmFormInstanceRecord.getFormInstanceRecordId())}).put((Object)portletNamespace.concat("mvcPath"), (Object)new String[]{"/display/edit_form_instance_record.jsp"}).put((Object)portletNamespace.concat("redirect"), (Object)new String[]{this._portal.getCurrentURL(httpServletRequest)}).put((Object)portletNamespace.concat("title"), (Object)new String[]{StringBundler.concat((String[])new String[]{ddmFormInstanceRecord.getUserName(), " - ", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"personal-data-erasure")})}).build());
    }

    public Map<String, Object> getFieldValues(DDMFormInstanceRecord ddmFormInstanceRecord, String[] fieldNames, Locale locale) {
        Map fieldValues = super.getFieldValues((BaseModel)ddmFormInstanceRecord, fieldNames, locale);
        DDMUADUtil.formatCreateDate(fieldValues);
        return fieldValues;
    }

    public String getName(DDMFormInstanceRecord ddmFormInstanceRecord, Locale locale) {
        try {
            StringBundler sb = new StringBundler(6);
            DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
            sb.append(DDMUADUtil.getFormattedName(ddmFormInstance));
            sb.append(" ");
            sb.append(LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, DDMFormInstanceRecordUADDisplay.class), (String)"record"));
            sb.append(" ");
            sb.append("#");
            sb.append(this._getIndex(ddmFormInstanceRecord) + 1);
            return sb.toString();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return "";
        }
    }

    public Class<?> getParentContainerClass() {
        return DDMFormInstance.class;
    }

    public Serializable getParentContainerId(DDMFormInstanceRecord ddmFormInstanceRecord) {
        return Long.valueOf(ddmFormInstanceRecord.getFormInstanceId());
    }

    public boolean isUserOwned(DDMFormInstanceRecord ddmFormInstanceRecord, long userId) {
        return ddmFormInstanceRecord.getUserId() == userId;
    }

    public List<DDMFormInstanceRecord> search(long userId, long[] groupIds, String keywords, String orderByField, String orderByType, int start, int end) {
        ArrayList<DDMFormInstanceRecord> ddmFormInstanceRecords = new ArrayList<DDMFormInstanceRecord>();
        ddmFormInstanceRecords.addAll(super.search(userId, groupIds, "", orderByField, orderByType, start, end));
        if (Validator.isNull((String)keywords)) {
            return ddmFormInstanceRecords;
        }
        Stream ddmFormInstanceRecordsStream = ddmFormInstanceRecords.stream();
        return ddmFormInstanceRecordsStream.filter(ddmFormInstanceRecord -> {
            String formattedName = this.getName((DDMFormInstanceRecord)ddmFormInstanceRecord, LocaleThreadLocal.getThemeDisplayLocale());
            String lowerCaseFormattedName = StringUtil.toLowerCase((String)formattedName);
            return lowerCaseFormattedName.contains(StringUtil.toLowerCase((String)keywords));
        }).collect(Collectors.toList());
    }

    private List<DDMFormInstanceRecord> _getDDMFormInstanceRecords(long formInstanceId, long userId) {
        DDMFormInstanceRecordUADUserCache ddmFormInstanceRecordUADUserCache = this._ddmFormInstanceRecordUADUserCacheMap.get(formInstanceId);
        if (ddmFormInstanceRecordUADUserCache == null) {
            ddmFormInstanceRecordUADUserCache = new DDMFormInstanceRecordUADUserCache(formInstanceId);
            ddmFormInstanceRecordUADUserCache.putDDMFormInstanceRecords(userId);
            this._ddmFormInstanceRecordUADUserCacheMap.put(formInstanceId, ddmFormInstanceRecordUADUserCache);
        }
        return ddmFormInstanceRecordUADUserCache.getDDMFormInstanceRecords(userId);
    }

    private int _getIndex(DDMFormInstanceRecord ddmFormInstanceRecord) {
        int index = 0;
        List<DDMFormInstanceRecord> ddmFormInstanceRecords = this._getDDMFormInstanceRecords(ddmFormInstanceRecord.getFormInstanceId(), ddmFormInstanceRecord.getUserId());
        for (DDMFormInstanceRecord currentDDMFormInstanceRecord : ddmFormInstanceRecords) {
            if (currentDDMFormInstanceRecord.getFormInstanceRecordId() == ddmFormInstanceRecord.getFormInstanceRecordId()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private class DDMFormInstanceRecordUADUserCache {
        private final Map<Long, List<DDMFormInstanceRecord>> _ddmFormInstanceRecordUADUserMap = new HashMap<Long, List<DDMFormInstanceRecord>>();
        private final long _formInstanceId;

        public DDMFormInstanceRecordUADUserCache(long formInstanceId) {
            this._formInstanceId = formInstanceId;
        }

        public List<DDMFormInstanceRecord> getDDMFormInstanceRecords(long userId) {
            if (this._ddmFormInstanceRecordUADUserMap.get(userId) == null) {
                this.putDDMFormInstanceRecords(userId);
            }
            return this._ddmFormInstanceRecordUADUserMap.get(userId);
        }

        public void putDDMFormInstanceRecords(long userId) {
            ArrayList<DDMFormInstanceRecord> ddmFormInstanceRecords = new ArrayList<DDMFormInstanceRecord>();
            ddmFormInstanceRecords.addAll(DDMFormInstanceRecordUADDisplay.this.ddmFormInstanceRecordLocalService.getFormInstanceRecords(this._formInstanceId, userId, -1, -1, null));
            ddmFormInstanceRecords.sort(Comparator.comparing(DDMFormInstanceRecordModel::getCreateDate));
            this._ddmFormInstanceRecordUADUserMap.put(userId, ddmFormInstanceRecords);
        }
    }
}

