/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.uad.constants.DDMUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDDMFormInstanceRecordUADAnonymizer
extends DynamicQueryUADAnonymizer<DDMFormInstanceRecord> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService;

    public void autoAnonymize(DDMFormInstanceRecord ddmFormInstanceRecord, long userId, User anonymousUser) throws PortalException {
        if (ddmFormInstanceRecord.getUserId() == userId) {
            ddmFormInstanceRecord.setUserId(anonymousUser.getUserId());
            ddmFormInstanceRecord.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(ddmFormInstanceRecord, anonymousUser);
        }
        if (ddmFormInstanceRecord.getVersionUserId() == userId) {
            ddmFormInstanceRecord.setVersionUserId(anonymousUser.getUserId());
            ddmFormInstanceRecord.setVersionUserName(anonymousUser.getFullName());
        }
        this.ddmFormInstanceRecordLocalService.updateDDMFormInstanceRecord(ddmFormInstanceRecord);
    }

    public void delete(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        this.ddmFormInstanceRecordLocalService.deleteFormInstanceRecord(ddmFormInstanceRecord);
    }

    public Class<DDMFormInstanceRecord> getTypeClass() {
        return DDMFormInstanceRecord.class;
    }

    protected void autoAnonymizeAssetEntry(DDMFormInstanceRecord ddmFormInstanceRecord, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(ddmFormInstanceRecord);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.ddmFormInstanceRecordLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return DDMUADConstants.USER_ID_FIELD_NAMES_DDM_FORM_INSTANCE_RECORD;
    }

    protected AssetEntry fetchAssetEntry(DDMFormInstanceRecord ddmFormInstanceRecord) {
        return this.assetEntryLocalService.fetchEntry(DDMFormInstanceRecord.class.getName(), ddmFormInstanceRecord.getFormInstanceRecordId());
    }
}

