/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.test.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.test.util.DDMFormValuesTestUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DDMFormTestUtil {
    public static void addDDMFormFields(DDMForm ddmForm, DDMFormField ... ddmFormFieldsArray) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFieldsArray) {
            ddmFormFields.add(ddmFormField);
        }
    }

    public static DDMFormField addDocumentLibraryDDMFormField(DDMForm ddmForm, String fieldName) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        DDMFormField ddmFormField = DDMFormTestUtil.createDDMFormField(fieldName, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "ddm-documentlibrary", "document-library", true, false, true);
        ddmFormField.setDDMForm(ddmForm);
        ddmFormField.setLocalizable(true);
        ddmFormField.setFieldNamespace("ddm");
        ddmFormFields.add(ddmFormField);
        return ddmFormField;
    }

    public static void addNestedTextDDMFormFields(DDMFormField ddmFormField, String ... fieldNames) {
        List nestedDDMFormFields = ddmFormField.getNestedDDMFormFields();
        for (String fieldName : fieldNames) {
            nestedDDMFormFields.add(DDMFormTestUtil.createLocalizableTextDDMFormField(fieldName));
        }
    }

    public static void addTextDDMFormFields(DDMForm ddmForm, String ... fieldNames) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (String fieldName : fieldNames) {
            DDMFormField ddmFormField = DDMFormTestUtil.createLocalizableTextDDMFormField(fieldName);
            ddmFormField.setDDMForm(ddmForm);
            ddmFormFields.add(ddmFormField);
        }
    }

    public static Set<Locale> createAvailableLocales(Locale ... locales) {
        LinkedHashSet<Locale> availableLocales = new LinkedHashSet<Locale>();
        for (Locale locale : locales) {
            availableLocales.add(locale);
        }
        return availableLocales;
    }

    public static DDMForm createDDMForm(Set<Locale> availableLocales, Locale defaultLocale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(availableLocales);
        ddmForm.setDefaultLocale(defaultLocale);
        return ddmForm;
    }

    public static DDMForm createDDMForm(String ... fieldNames) {
        DDMForm ddmForm = DDMFormTestUtil.createDDMForm(DDMFormTestUtil.createAvailableLocales(LocaleUtil.US), LocaleUtil.US);
        DDMFormTestUtil.addTextDDMFormFields(ddmForm, fieldNames);
        return ddmForm;
    }

    public static DDMFormField createDDMFormField(String name, String label, String type, String dataType, boolean localizable, boolean repeatable, boolean required) {
        DDMFormField ddmFormField = new DDMFormField(name, type);
        ddmFormField.setDataType(dataType);
        ddmFormField.setLocalizable(localizable);
        ddmFormField.setRepeatable(repeatable);
        ddmFormField.setRequired(required);
        LocalizedValue localizedValue = ddmFormField.getLabel();
        localizedValue.addString(LocaleUtil.US, label);
        return ddmFormField;
    }

    public static DDMFormField createDDMFormField(String name, String label, String type, String dataType, boolean localizable, boolean repeatable, boolean required, String tip) {
        return DDMFormTestUtil.createDDMFormField(name, label, type, dataType, localizable, repeatable, required, tip, null);
    }

    public static DDMFormField createDDMFormField(String name, String label, String type, String dataType, boolean localizable, boolean repeatable, boolean required, String tip, String option) {
        return DDMFormTestUtil.createDDMFormField(name, label, type, dataType, localizable, repeatable, required, tip, null, option);
    }

    public static DDMFormField createDDMFormField(String name, String label, String type, String dataType, boolean localizable, boolean repeatable, boolean required, String tip, String predefinedValue, String option) {
        return DDMFormTestUtil.createDDMFormField(name, label, type, dataType, localizable, repeatable, required, tip, predefinedValue, null, null, option);
    }

    public static DDMFormField createDDMFormField(String name, String label, String type, String dataType, boolean localizable, boolean repeatable, boolean required, String tip, String predefinedValue, String placeHolder, String toolTip, String option) {
        DDMFormField ddmFormField = DDMFormTestUtil.createDDMFormField(name, label, type, dataType, localizable, repeatable, required);
        LocalizedValue tipLocalizedValue = DDMFormValuesTestUtil.createLocalizedValue(tip, LocaleUtil.US);
        ddmFormField.setTip(tipLocalizedValue);
        LocalizedValue predefinedValueLocalizedValue = DDMFormValuesTestUtil.createLocalizedValue(predefinedValue, LocaleUtil.US);
        ddmFormField.setPredefinedValue(predefinedValueLocalizedValue);
        LocalizedValue placeHolderLocalizedValue = DDMFormValuesTestUtil.createLocalizedValue(placeHolder, LocaleUtil.US);
        ddmFormField.setProperty("placeholder", (Object)placeHolderLocalizedValue);
        LocalizedValue toolTipLocalizedValue = DDMFormValuesTestUtil.createLocalizedValue(toolTip, LocaleUtil.US);
        ddmFormField.setProperty("tooltip", (Object)toolTipLocalizedValue);
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        ddmFormFieldOptions.addOptionLabel(option, LocaleUtil.US, option);
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
        LocalizedValue localizedValue = ddmFormField.getLabel();
        localizedValue.addString(LocaleUtil.US, label);
        return ddmFormField;
    }

    public static DDMFormField createGridDDMFormField(String name, String label, String type, String dataType, boolean localizable, boolean repeatable, boolean required, String tip, String option) {
        DDMFormField ddmFormField = DDMFormTestUtil.createDDMFormField(name, label, type, dataType, localizable, repeatable, required, tip, null, null, null, option);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        ddmFormField.setProperty("columns", (Object)ddmFormFieldOptions);
        ddmFormField.setProperty("rows", (Object)ddmFormFieldOptions);
        return ddmFormField;
    }

    public static DDMFormField createLocalizableTextDDMFormField(String name) {
        return DDMFormTestUtil.createTextDDMFormField(name, true, false, false);
    }

    public static DDMFormField createNumericDDMFormField(String name, String label, String dataType, boolean localizable, boolean repeatable, boolean required, String tip, String placeHolder, String toolTip) {
        return DDMFormTestUtil.createDDMFormField(name, label, "numeric", dataType, localizable, repeatable, required, tip, null, placeHolder, toolTip, null);
    }

    public static DDMFormField createSeparatorDDMFormField(String name, boolean repeatable) {
        DDMFormField ddmFormField = new DDMFormField(name, "separator");
        ddmFormField.setRepeatable(repeatable);
        LocalizedValue localizedValue = ddmFormField.getLabel();
        localizedValue.addString(LocaleUtil.US, name);
        return ddmFormField;
    }

    public static DDMFormField createTextDDMFormField(String name, boolean localizable, boolean repeatable, boolean required) {
        return DDMFormTestUtil.createDDMFormField(name, name, "text", "string", localizable, repeatable, required);
    }

    public static DDMFormField createTextDDMFormField(String name, String label, boolean localizable, boolean repeatable, boolean required) {
        return DDMFormTestUtil.createDDMFormField(name, label, "text", "string", localizable, repeatable, required);
    }

    public static void setIndexTypeProperty(DDMForm ddmForm, String indexTypeValue) {
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFields) {
            ddmFormField.setIndexType(indexTypeValue);
        }
    }
}

