/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRegistry;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={DDMFormInstanceRecordWriterRegistry.class})
public class DDMFormInstanceRecordWriterRegistryImpl
implements DDMFormInstanceRecordWriterRegistry {
    private final Map<String, String> _ddmFormInstanceRecordWriterExtensions = new TreeMap<String, String>();
    private final Map<String, DDMFormInstanceRecordWriter> _ddmFormInstanceRecordWriters = new TreeMap<String, DDMFormInstanceRecordWriter>();

    public DDMFormInstanceRecordWriter getDDMFormInstanceRecordWriter(String type) {
        return this._ddmFormInstanceRecordWriters.get(type);
    }

    public Map<String, String> getDDMFormInstanceRecordWriterExtensions() {
        return Collections.unmodifiableMap(this._ddmFormInstanceRecordWriterExtensions);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMFormInstanceRecordWriter(DDMFormInstanceRecordWriter ddmFormInstanceRecordWriter, Map<String, Object> properties) {
        String type = MapUtil.getString(properties, (String)"ddm.form.instance.record.writer.type");
        String extension = MapUtil.getString(properties, (String)"ddm.form.instance.record.writer.extension");
        if (Validator.isNull((String)extension)) {
            extension = StringUtil.toUpperCase((String)type);
        }
        this._ddmFormInstanceRecordWriterExtensions.put(type, extension);
        this._ddmFormInstanceRecordWriters.put(type, ddmFormInstanceRecordWriter);
    }

    @Deactivate
    protected void deactivate() {
        this._ddmFormInstanceRecordWriterExtensions.clear();
        this._ddmFormInstanceRecordWriters.clear();
    }

    protected void removeDDMFormInstanceRecordWriter(DDMFormInstanceRecordWriter ddmFormInstanceRecordWriter, Map<String, Object> properties) {
        String type = MapUtil.getString(properties, (String)"ddm.form.instance.record.writer.type");
        this._ddmFormInstanceRecordWriterExtensions.remove(type);
        this._ddmFormInstanceRecordWriters.remove(type);
    }
}

