/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord"}, service={DDMFormInstanceRecordStagedModelRepository.class, StagedModelRepository.class})
public class DDMFormInstanceRecordStagedModelRepository
implements StagedModelRepository<DDMFormInstanceRecord> {
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;

    public DDMFormInstanceRecord addStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public DDMFormInstanceRecord addStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddmFormInstanceRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstanceRecord);
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddmFormInstanceRecord.getUuid());
        }
        DDMFormInstanceRecord importedDDMFormInstanceRecord = this._ddmFormInstanceRecordLocalService.addFormInstanceRecord(userId, ddmFormInstanceRecord.getGroupId(), ddmFormInstanceRecord.getFormInstanceId(), ddmFormValues, serviceContext);
        this._updateVersions(importedDDMFormInstanceRecord, ddmFormInstanceRecord.getVersion());
        return importedDDMFormInstanceRecord;
    }

    public void deleteStagedModel(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        this._ddmFormInstanceRecordLocalService.deleteFormInstanceRecord(ddmFormInstanceRecord);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMFormInstanceRecord ddlRrecord = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddlRrecord != null) {
            this.deleteStagedModel(ddlRrecord);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public DDMFormInstanceRecord fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddmFormInstanceRecordLocalService.fetchDDMFormInstanceRecordByUuidAndGroupId(uuid, groupId);
    }

    public List<DDMFormInstanceRecord> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddmFormInstanceRecordLocalService.getDDMFormInstanceRecordsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmFormInstanceRecordLocalService.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = exportActionableDynamicQuery.getAddCriteriaMethod();
        exportActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property formInstanceRecordIdProperty = PropertyFactoryUtil.forName((String)"formInstanceRecordId");
            DynamicQuery formInstanceRecordVersionDynamicQuery = this._getRecordVersionDynamicQuery();
            dynamicQuery.add(formInstanceRecordIdProperty.in(formInstanceRecordVersionDynamicQuery));
            Property formInstanceIdProperty = PropertyFactoryUtil.forName((String)"formInstanceId");
            dynamicQuery.add(formInstanceIdProperty.in(this._getFormInstanceDynamicQuery()));
        });
        return exportActionableDynamicQuery;
    }

    public DDMFormInstanceRecord getStagedModel(long formInstanceRecordId) throws PortalException {
        return this._ddmFormInstanceRecordLocalService.getDDMFormInstanceRecord(formInstanceRecordId);
    }

    public DDMFormInstanceRecord saveStagedModel(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        return this._ddmFormInstanceRecordLocalService.updateDDMFormInstanceRecord(ddmFormInstanceRecord);
    }

    public DDMFormInstanceRecord updateStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public DDMFormInstanceRecord updateStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddmFormInstanceRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstanceRecord);
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        DDMFormInstanceRecord importedDDMFormInstanceRecord = this._ddmFormInstanceRecordLocalService.updateFormInstanceRecord(userId, ddmFormInstanceRecord.getFormInstanceRecordId(), false, ddmFormValues, serviceContext);
        this._updateVersions(importedDDMFormInstanceRecord, ddmFormInstanceRecord.getVersion());
        return importedDDMFormInstanceRecord;
    }

    private DynamicQuery _getFormInstanceDynamicQuery() {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDMFormInstanceRecord.class.getName());
        Class<?> clazz = stagedModelDataHandler.getClass();
        DynamicQuery formInstanceDynamicQuery = DynamicQueryFactoryUtil.forClass(DDMFormInstance.class, (String)"formInstance", (ClassLoader)clazz.getClassLoader());
        formInstanceDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"formInstanceId"));
        formInstanceDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"formInstance.formInstanceId", (String)"formInstanceId"));
        return formInstanceDynamicQuery;
    }

    private DynamicQuery _getRecordVersionDynamicQuery() {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DDMFormInstanceRecord.class.getName());
        Class<?> clazz = stagedModelDataHandler.getClass();
        DynamicQuery formInstanceRecordVersionDynamicQuery = DynamicQueryFactoryUtil.forClass(DDMFormInstanceRecordVersion.class, (String)"formInstanceRecordVersion", (ClassLoader)clazz.getClassLoader());
        formInstanceRecordVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"formInstanceRecordId"));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        formInstanceRecordVersionDynamicQuery.add(statusProperty.in(stagedModelDataHandler.getExportableStatuses()));
        formInstanceRecordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"formInstanceRecordVersion.version", (String)"version"));
        formInstanceRecordVersionDynamicQuery.add(RestrictionsFactoryUtil.eqProperty((String)"formInstanceRecordVersion.formInstanceRecordId", (String)"formInstanceRecordId"));
        return formInstanceRecordVersionDynamicQuery;
    }

    private void _updateVersions(DDMFormInstanceRecord importedDDMFormInstanceRecord, String version) throws PortalException {
        if (Objects.equals(importedDDMFormInstanceRecord.getVersion(), version)) {
            return;
        }
        DDMFormInstanceRecordVersion importedDDMFormInstanceRecordVersion = importedDDMFormInstanceRecord.getFormInstanceRecordVersion();
        importedDDMFormInstanceRecordVersion.setVersion(version);
        this._ddmFormInstanceRecordVersionLocalService.updateDDMFormInstanceRecordVersion(importedDDMFormInstanceRecordVersion);
        importedDDMFormInstanceRecord.setVersion(version);
        this._ddmFormInstanceRecordLocalService.updateDDMFormInstanceRecord(importedDDMFormInstanceRecord);
    }
}

