/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues"}, service={DDMFormValuesExportImportContentProcessor.class, ExportImportContentProcessor.class})
public class DDMFormValuesExportImportContentProcessor
implements ExportImportContentProcessor<DDMFormValues> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesExportImportContentProcessor.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;

    public DDMFormValues replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, DDMFormValues ddmFormValues, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new FileEntryExportDDMFormFieldValueTransformer(portletDataContext, stagedModel, exportReferencedContent));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new JournalArticleExportDDMFormFieldValueTransformer(portletDataContext, stagedModel, exportReferencedContent));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new LayoutExportDDMFormFieldValueTransformer(portletDataContext, stagedModel));
        ddmFormValuesTransformer.transform();
        return ddmFormValues;
    }

    public DDMFormValues replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new FileEntryImportDDMFormFieldValueTransformer(portletDataContext, stagedModel));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new JournalArticleImportDDMFormFieldValueTransformer(portletDataContext, stagedModel));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new LayoutImportDDMFormFieldValueTransformer(portletDataContext));
        ddmFormValuesTransformer.transform();
        return ddmFormValues;
    }

    public void validateContentReferences(long groupId, DDMFormValues ddmFormValues) {
    }

    private boolean _hasNotExportableStatus(StagedModel stagedModel, int status) {
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)stagedModel.getModelClassName());
        return !ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)status);
    }

    private class LayoutImportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;

        public LayoutImportDDMFormFieldValueTransformer(PortletDataContext portletDataContext) {
            this._portletDataContext = portletDataContext;
        }

        public String getFieldType() {
            return "link_to_layout";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = null;
                try {
                    jsonObject = DDMFormValuesExportImportContentProcessor.this._jsonFactory.createJSONObject(valueString);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                Layout importedLayout = this.fetchImportedLayout(this._portletDataContext, jsonObject);
                if (importedLayout != null) {
                    value.addString(locale, this.toJSON(importedLayout, locale));
                    continue;
                }
                Element missingReferencesElement = this._portletDataContext.getMissingReferencesElement();
                List elements = missingReferencesElement.elements();
                for (Element element : elements) {
                    String className = element.attributeValue("class-name");
                    if (!className.equals(Layout.class.getName())) continue;
                    String uuid = element.attributeValue("uuid");
                    if (jsonObject.has("id") && !Objects.equals(uuid, jsonObject.getString("id"))) continue;
                    String privateLayout = element.attributeValue("private-layout");
                    importedLayout = DDMFormValuesExportImportContentProcessor.this._layoutLocalService.fetchLayoutByUuidAndGroupId(uuid, this._portletDataContext.getScopeGroupId(), Boolean.valueOf(privateLayout).booleanValue());
                }
                if (importedLayout == null) continue;
                value.addString(locale, this.toJSON(importedLayout, locale));
            }
        }

        protected Layout fetchImportedLayout(PortletDataContext portletDataContext, JSONObject jsonObject) {
            long layoutId;
            Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
            Layout layout = (Layout)layouts.get(layoutId = jsonObject.getLong("layoutId"));
            if (layout == null && _log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find layout with ID " + layoutId));
            }
            return layout;
        }

        protected String toJSON(Layout layout, Locale locale) throws PortalException {
            return JSONUtil.put((String)"groupId", (Object)layout.getGroupId()).put("id", layout.getUuid()).put("layoutId", layout.getLayoutId()).put("name", layout.getBreadcrumb(locale)).put("privateLayout", layout.isPrivateLayout()).put("value", layout.getFriendlyURL(locale)).toString();
        }
    }

    private class LayoutExportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public LayoutExportDDMFormFieldValueTransformer(PortletDataContext portletDataContext, StagedModel stagedModel) {
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
        }

        public String getFieldType() {
            return "link_to_layout";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                if (Validator.isNull((String)valueString)) continue;
                JSONObject jsonObject = null;
                try {
                    jsonObject = DDMFormValuesExportImportContentProcessor.this._jsonFactory.createJSONObject(valueString);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                long groupId = GetterUtil.getLong((Object)jsonObject.get("groupId"));
                long layoutId = GetterUtil.getLong((Object)jsonObject.getLong("layoutId"));
                boolean privateLayout = jsonObject.getBoolean("privateLayout");
                Layout layout = DDMFormValuesExportImportContentProcessor.this._layoutLocalService.fetchLayout(groupId, privateLayout, layoutId);
                if (layout == null) continue;
                Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
                this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)layout, "dependency", true);
            }
        }
    }

    private class JournalArticleImportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public JournalArticleImportDDMFormFieldValueTransformer(PortletDataContext portletDataContext, StagedModel stagedModel) {
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
        }

        public String getFieldType() {
            return "journal_article";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = null;
                try {
                    jsonObject = DDMFormValuesExportImportContentProcessor.this._jsonFactory.createJSONObject(valueString);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                JournalArticle journalArticle = this.fetchJournalArticle(jsonObject);
                if (journalArticle == null) continue;
                jsonObject.put("classPK", journalArticle.getResourcePrimKey());
                value.addString(locale, jsonObject.toString());
            }
        }

        protected JournalArticle fetchJournalArticle(JSONObject jsonObject) throws PortalException {
            block3: {
                long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                Map classPKs = this._portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
                long newClassPK = MapUtil.getLong((Map)classPKs, (long)classPK, (long)classPK);
                if (newClassPK > 0L) {
                    try {
                        return DDMFormValuesExportImportContentProcessor.this._journalArticleLocalService.getLatestArticle(newClassPK);
                    }
                    catch (NoSuchArticleException noSuchArticleException) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to find journal article with primary key " + newClassPK), (Throwable)noSuchArticleException);
                    }
                }
            }
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            Map groupIds = this._portletDataContext.getNewPrimaryKeysMap(Group.class);
            groupId = MapUtil.getLong((Map)groupIds, (long)groupId, (long)groupId);
            return DDMFormValuesExportImportContentProcessor.this._journalArticleLocalService.fetchJournalArticleByUuidAndGroupId(uuid, groupId);
        }
    }

    private class JournalArticleExportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final boolean _exportReferencedContent;
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public JournalArticleExportDDMFormFieldValueTransformer(PortletDataContext portletDataContext, StagedModel stagedModel, boolean exportReferencedContent) {
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
            this._exportReferencedContent = exportReferencedContent;
        }

        public String getFieldType() {
            return "journal_article";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                JournalArticle journalArticle;
                String valueString = value.getString(locale);
                JSONObject jsonObject = null;
                try {
                    jsonObject = DDMFormValuesExportImportContentProcessor.this._jsonFactory.createJSONObject(valueString);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                String className = GetterUtil.getString((Object)jsonObject.get("className"));
                if (classPK == 0L || !className.equals(JournalArticle.class.getName()) || (journalArticle = DDMFormValuesExportImportContentProcessor.this._journalArticleLocalService.fetchLatestArticle(classPK)) == null) continue;
                jsonObject.put("groupId", journalArticle.getGroupId()).put("uuid", journalArticle.getUuid());
                value.addString(locale, jsonObject.toString());
                boolean disposableDependency = DDMFormValuesExportImportContentProcessor.this._hasNotExportableStatus((StagedModel)journalArticle, journalArticle.getStatus());
                if (this._exportReferencedContent && !disposableDependency) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)this._portletDataContext, (StagedModel)this._stagedModel, (StagedModel)journalArticle, (String)"dependency");
                    continue;
                }
                String referenceType = "dependency";
                if (disposableDependency) {
                    referenceType = "disposable_dependency";
                }
                Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
                this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)journalArticle, referenceType, true);
            }
        }
    }

    private class FileEntryImportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public FileEntryImportDDMFormFieldValueTransformer(PortletDataContext portletDataContext, StagedModel stagedModel) {
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
        }

        public String getFieldType() {
            return "document_library";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = null;
                try {
                    jsonObject = DDMFormValuesExportImportContentProcessor.this._jsonFactory.createJSONObject(valueString);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                String type = jsonObject.getString("type");
                FileEntry importedFileEntry = this.fetchImportedFileEntry(this._portletDataContext, jsonObject);
                if (importedFileEntry == null) continue;
                value.addString(locale, this.toJSON(importedFileEntry, type));
            }
        }

        protected FileEntry fetchImportedFileEntry(PortletDataContext portletDataContext, JSONObject jsonObject) throws PortalException {
            block7: {
                block6: {
                    long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                    Map classPKs = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
                    long newClassPK = MapUtil.getLong((Map)classPKs, (long)classPK, (long)classPK);
                    if (newClassPK > 0L) {
                        try {
                            return DDMFormValuesExportImportContentProcessor.this._dlAppLocalService.getFileEntry(newClassPK);
                        }
                        catch (PortalException portalException) {
                            if (!_log.isWarnEnabled()) break block6;
                            _log.warn((Object)("Unable to find file entry with file entry ID " + newClassPK), (Throwable)portalException);
                        }
                    }
                }
                Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
                long groupId = jsonObject.getLong("groupId");
                String uuid = jsonObject.getString("uuid");
                if ((groupId = MapUtil.getLong((Map)groupIds, (long)groupId, (long)groupId)) > 0L && Validator.isNotNull((String)uuid)) {
                    try {
                        return DDMFormValuesExportImportContentProcessor.this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)"Unable to find file entry", (Throwable)portalException);
                    }
                }
            }
            return null;
        }

        protected String toJSON(FileEntry fileEntry, String type) {
            return JSONUtil.put((String)"classPK", (Object)fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("title", fileEntry.getTitle()).put("type", type).put("uuid", fileEntry.getUuid()).toString();
        }
    }

    private class FileEntryExportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final boolean _exportReferencedContent;
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public FileEntryExportDDMFormFieldValueTransformer(PortletDataContext portletDataContext, StagedModel stagedModel, boolean exportReferencedContent) {
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
            this._exportReferencedContent = exportReferencedContent;
        }

        public String getFieldType() {
            return "document_library";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = null;
                try {
                    jsonObject = DDMFormValuesExportImportContentProcessor.this._jsonFactory.createJSONObject(valueString);
                }
                catch (JSONException jsonException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
                    continue;
                }
                long groupId = GetterUtil.getLong((Object)jsonObject.get("groupId"));
                String uuid = jsonObject.getString("uuid");
                if (groupId == 0L || Validator.isNull((String)uuid)) continue;
                FileEntry fileEntry = null;
                try {
                    fileEntry = DDMFormValuesExportImportContentProcessor.this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)"Unable to find file entry", (Throwable)portalException);
                    continue;
                }
                FileVersion fileVersion = fileEntry.getFileVersion();
                boolean disposableDependency = DDMFormValuesExportImportContentProcessor.this._hasNotExportableStatus((StagedModel)fileEntry, fileVersion.getStatus());
                if (this._exportReferencedContent && !disposableDependency) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)this._portletDataContext, (StagedModel)this._stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    continue;
                }
                Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
                String referenceType = "dependency";
                if (disposableDependency) {
                    referenceType = "disposable_dependency";
                }
                this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)fileEntry, referenceType, true);
            }
        }
    }
}

