/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessorTracker;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceReportLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMFormInstancePersistence;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport"}, service={AopService.class})
public class DDMFormInstanceReportLocalServiceImpl
extends DDMFormInstanceReportLocalServiceBaseImpl {
    @Reference
    private DDMFormFieldTypeReportProcessorTracker _ddmFormFieldTypeReportProcessorTracker;
    @Reference
    private DDMFormInstancePersistence _formInstancePersistence;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _formInstanceRecordVersionLocalService;

    public DDMFormInstanceReport addFormInstanceReport(long formInstanceId) throws PortalException {
        DDMFormInstanceReport formInstanceReport = this.ddmFormInstanceReportPersistence.create(this.counterLocalService.increment());
        DDMFormInstance formInstance = this._formInstancePersistence.findByPrimaryKey(formInstanceId);
        formInstanceReport.setGroupId(formInstance.getGroupId());
        formInstanceReport.setCompanyId(formInstance.getCompanyId());
        formInstanceReport.setCreateDate(new Date());
        formInstanceReport.setFormInstanceId(formInstance.getFormInstanceId());
        return (DDMFormInstanceReport)this.ddmFormInstanceReportPersistence.update((BaseModel)formInstanceReport);
    }

    public DDMFormInstanceReport getFormInstanceReportByFormInstanceId(long formInstanceId) throws PortalException {
        return this.ddmFormInstanceReportPersistence.findByFormInstanceId(formInstanceId);
    }

    public DDMFormInstanceReport updateFormInstanceReport(long formInstanceReportId, long formInstanceRecordVersionId, String formInstanceReportEvent) throws PortalException {
        DDMFormInstanceReport formInstanceReport = this.ddmFormInstanceReportPersistence.findByPrimaryKey(formInstanceReportId);
        formInstanceReport.setModifiedDate(new Date());
        formInstanceReport.setData(this._getData(formInstanceRecordVersionId, formInstanceReportEvent));
        return (DDMFormInstanceReport)this.ddmFormInstanceReportPersistence.update((BaseModel)formInstanceReport);
    }

    private String _getData(long formInstanceRecordVersionId, String formInstanceReportEvent) throws PortalException {
        try {
            DDMFormInstanceRecordVersion formInstanceRecordVersion = this._formInstanceRecordVersionLocalService.getDDMFormInstanceRecordVersion(formInstanceRecordVersionId);
            DDMFormInstanceReport formInstanceReport = this.ddmFormInstanceReportPersistence.findByFormInstanceId(formInstanceRecordVersion.getFormInstanceId());
            JSONObject formInstanceReportDataJSONObject = JSONFactoryUtil.createJSONObject((String)formInstanceReport.getData());
            DDMFormValues ddmFormValues = formInstanceRecordVersion.getDDMFormValues();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
                DDMFormFieldTypeReportProcessor ddmFormFieldTypeReportProcessor = this._ddmFormFieldTypeReportProcessorTracker.getDDMFormFieldTypeReportProcessor(ddmFormFieldValue.getType());
                if (ddmFormFieldTypeReportProcessor == null) continue;
                formInstanceReportDataJSONObject = ddmFormFieldTypeReportProcessor.process(ddmFormFieldValue, formInstanceReportDataJSONObject, formInstanceReportEvent);
            }
            int totalItems = formInstanceReportDataJSONObject.getInt("totalItems");
            if (formInstanceReportEvent.equals("add")) {
                ++totalItems;
            } else if (formInstanceReportEvent.equals("delete")) {
                --totalItems;
            }
            formInstanceReportDataJSONObject.put("totalItems", totalItems);
            return formInstanceReportDataJSONObject.toString();
        }
        catch (Exception exception) {
            throw new PortalException("Unable to process data for form instance record version " + formInstanceRecordVersionId, (Throwable)exception);
        }
    }
}

