/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToMapConverter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormValuesToMapConverter.class})
public class DDMFormValuesToMapConverterImpl
implements DDMFormValuesToMapConverter {
    public Map<String, Object> convert(DDMFormValues ddmFormValues, DDMStructure ddmStructure) throws PortalException {
        if (ddmFormValues == null) {
            return Collections.emptyMap();
        }
        Map ddmFormFields = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        HashMap<String, Object> values = new HashMap<String, Object>(ddmFormFields.size());
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this._addValues(ddmFormFields, ddmFormFieldValue, values);
        }
        return values;
    }

    private void _addValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        if (ddmFormField == null) {
            return;
        }
        String name = ddmFormField.getName();
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            values.put(name, null);
            return;
        }
        if (ddmFormField.isRepeatable()) {
            if (ddmFormField.isLocalizable()) {
                Map localizedValues = values.getOrDefault(name, new HashMap());
                LocalizedValue localizedValue = (LocalizedValue)value;
                Set availableLocales = localizedValue.getAvailableLocales();
                for (Locale locale : availableLocales) {
                    String languageId = LanguageUtil.getLanguageId((Locale)locale);
                    List list = localizedValues.getOrDefault(languageId, new ArrayList());
                    list.add(localizedValue.getString(locale));
                    localizedValues.put(languageId, list);
                }
                values.put(name, localizedValues);
            } else {
                List list = values.getOrDefault(name, new ArrayList());
                list.add(value.getString(value.getDefaultLocale()));
                values.put(name, list);
            }
        } else if (ddmFormField.isLocalizable()) {
            values.put(name, this._toLocalizedMap(ddmFormField.getType(), (LocalizedValue)value));
        } else {
            values.put(name, value.getString(value.getDefaultLocale()));
        }
    }

    private void _addValues(Map<String, DDMFormField> ddmFormFields, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        DDMFormField ddmFormField = ddmFormFields.get(ddmFormFieldValue.getName());
        this._addValue(ddmFormField, ddmFormFieldValue, values);
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addValues(ddmFormFields, nestedDDMFormFieldValue, values);
        }
    }

    private Map<String, Object> _toLocalizedMap(String fieldType, LocalizedValue localizedValue) {
        Set availableLocales = localizedValue.getAvailableLocales();
        Stream stream = availableLocales.stream();
        if (fieldType.equals("checkbox_multiple") || fieldType.equals("select")) {
            return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, locale -> this._toStringList((Locale)locale, localizedValue)));
        }
        return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, arg_0 -> ((LocalizedValue)localizedValue).getString(arg_0)));
    }

    private List<String> _toStringList(Locale locale, LocalizedValue localizedValue) {
        try {
            return JSONUtil.toStringList((JSONArray)JSONFactoryUtil.createJSONArray((String)localizedValue.getString(locale)));
        }
        catch (JSONException jsonException) {
            return Collections.emptyList();
        }
    }
}

