/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.dynamic.data.mapping.exception.NoSuchFormInstanceReportException;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceReportLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DDMFormInstanceRecordVersionModelListener
extends BaseModelListener<DDMFormInstanceRecordVersion> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordVersionModelListener.class);
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    @Reference
    private DDMFormInstanceReportLocalService _ddmFormInstanceReportLocalService;

    public void onAfterUpdate(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion) throws ModelListenerException {
        block3: {
            try {
                if (ddmFormInstanceRecordVersion.getStatus() != 0) {
                    return;
                }
                this._updateDDMFormInstanceReport(ddmFormInstanceRecordVersion, "add");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to update dynamic data mapping form ");
                sb.append("instance report for dynamic data mapping form ");
                sb.append("instance record ");
                sb.append(ddmFormInstanceRecordVersion.getFormInstanceRecordId());
                _log.warn((Object)sb.toString(), (Throwable)exception);
            }
        }
    }

    public void onBeforeRemove(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion) throws ModelListenerException {
        block2: {
            try {
                this._updateDDMFormInstanceReport(ddmFormInstanceRecordVersion, "delete");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to update dynamic data mapping form ");
                sb.append("instance report for dynamic data mapping form ");
                sb.append("instance record ");
                sb.append(ddmFormInstanceRecordVersion.getFormInstanceRecordId());
                _log.warn((Object)sb.toString(), (Throwable)exception);
            }
        }
    }

    public void onBeforeUpdate(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion) throws ModelListenerException {
        block3: {
            try {
                if (ddmFormInstanceRecordVersion.getStatus() != 0) {
                    return;
                }
                DDMFormInstanceRecordVersion latestDDMFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getLatestFormInstanceRecordVersion(ddmFormInstanceRecordVersion.getFormInstanceRecordId(), 0);
                this._updateDDMFormInstanceReport(latestDDMFormInstanceRecordVersion, "delete");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to update dynamic data mapping form ");
                sb.append("instance report for dynamic data mapping form ");
                sb.append("instance record ");
                sb.append(ddmFormInstanceRecordVersion.getFormInstanceRecordId());
                _log.warn((Object)sb.toString(), (Throwable)exception);
            }
        }
    }

    private void _updateDDMFormInstanceReport(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, String formInstanceReportEvent) throws PortalException {
        block2: {
            try {
                DDMFormInstanceReport ddmFormInstanceReport = this._ddmFormInstanceReportLocalService.getFormInstanceReportByFormInstanceId(ddmFormInstanceRecordVersion.getFormInstanceId());
                this._ddmFormInstanceReportLocalService.updateFormInstanceReport(ddmFormInstanceReport.getFormInstanceReportId(), ddmFormInstanceRecordVersion.getFormInstanceRecordVersionId(), formInstanceReportEvent);
            }
            catch (NoSuchFormInstanceReportException noSuchFormInstanceReportException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)noSuchFormInstanceReportException, (Throwable)noSuchFormInstanceReportException);
            }
        }
    }
}

