/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceReportLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DDMFormInstanceModelListener
extends BaseModelListener<DDMFormInstance> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceModelListener.class);
    @Reference
    private DDMFormInstanceReportLocalService _ddmFormInstanceReportLocalService;

    public void onAfterCreate(DDMFormInstance ddmFormInstance) throws ModelListenerException {
        try {
            this._ddmFormInstanceReportLocalService.addFormInstanceReport(ddmFormInstance.getFormInstanceId());
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to update dynamic data mapping form instance report for dynamic data mapping form instance " + ddmFormInstance.getFormInstanceId()), (Throwable)exception);
        }
    }

    public void onAfterRemove(DDMFormInstance ddmFormInstance) throws ModelListenerException {
        try {
            DDMFormInstanceReport ddmFormInstanceReport = this._ddmFormInstanceReportLocalService.getFormInstanceReportByFormInstanceId(ddmFormInstance.getFormInstanceId());
            if (ddmFormInstanceReport == null) {
                return;
            }
            this._ddmFormInstanceReportLocalService.deleteDDMFormInstanceReport(ddmFormInstanceReport.getFormInstanceReportId());
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to update dynamic data mapping form instance report for dynamic data mapping form instance " + ddmFormInstance.getFormInstanceId()), (Throwable)exception);
        }
    }
}

