/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.exception.StructureFieldException;
import com.liferay.dynamic.data.mapping.internal.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureBaseImpl;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMStructureImpl
extends DDMStructureBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureImpl.class);
    private String _className;
    private DDMForm _ddmForm;

    public DDMForm createFullHierarchyDDMForm() throws PortalException {
        DDMForm fullHierarchyDDMForm = this.getDDMForm();
        DDMStructure parentDDMStructure = this.getParentDDMStructure();
        if (parentDDMStructure != null) {
            DDMForm ancestorsDDMForm = parentDDMStructure.createFullHierarchyDDMForm();
            List ancestorsDDMFormFields = ancestorsDDMForm.getDDMFormFields();
            for (DDMFormField ancestorsDDMFormField : ancestorsDDMFormFields) {
                ancestorsDDMFormField.setDDMForm(fullHierarchyDDMForm);
            }
            List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
            ddmFormFields.addAll(0, ancestorsDDMFormFields);
        }
        return fullHierarchyDDMForm;
    }

    @Override
    public String[] getAvailableLanguageIds() {
        DDMForm ddmForm = this._getDDMForm();
        Set availableLocales = ddmForm.getAvailableLocales();
        return LocaleUtil.toLanguageIds((Locale[])availableLocales.toArray(new Locale[0]));
    }

    public List<String> getChildrenFieldNames(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return this.getDDMFormFieldNames(ddmFormField.getNestedDDMFormFields());
    }

    @Override
    public String getClassName() {
        if (this._className == null) {
            this._className = PortalUtil.getClassName((long)this.getClassNameId());
        }
        return this._className;
    }

    @Override
    public DDMForm getDDMForm() {
        return new DDMForm(this._getDDMForm());
    }

    public DDMFormField getDDMFormField(String fieldName) throws PortalException {
        return new DDMFormField(this._getDDMFormField(fieldName));
    }

    public List<DDMFormField> getDDMFormFields(boolean includeTransientFields) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>(ddmFormFieldsMap.values());
        if (includeTransientFields) {
            return ddmFormFields;
        }
        return this.filterTransientDDMFormFields(ddmFormFields);
    }

    public DDMFormLayout getDDMFormLayout() throws PortalException {
        DDMStructureVersion structureVersion = this.getStructureVersion();
        DDMStructureLayout ddmStructureLayout = DDMStructureLayoutLocalServiceUtil.getStructureLayoutByStructureVersionId((long)structureVersion.getStructureVersionId());
        return ddmStructureLayout.getDDMFormLayout();
    }

    @Override
    public String getDefaultLanguageId() {
        DDMForm ddmForm = this._getDDMForm();
        return LocaleUtil.toLanguageId((Locale)ddmForm.getDefaultLocale());
    }

    public String getFieldDataType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.getDataType();
    }

    public String getFieldLabel(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(locale);
    }

    public String getFieldLabel(String fieldName, String locale) throws PortalException {
        return this.getFieldLabel(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public Set<String> getFieldNames() {
        return SetUtil.fromList(this.getDDMFormFieldNames(this.getDDMFormFields(false)));
    }

    public String getFieldProperty(String fieldName, String property) throws PortalException {
        return BeanPropertiesUtil.getString((Object)this._getDDMFormField(fieldName), (String)property);
    }

    public boolean getFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean getFieldRequired(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.isRequired();
    }

    public String getFieldTip(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        LocalizedValue tip = ddmFormField.getTip();
        return tip.getString(locale);
    }

    public String getFieldTip(String fieldName, String locale) throws PortalException {
        return this.getFieldTip(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public String getFieldType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.getType();
    }

    public DDMForm getFullHierarchyDDMForm() {
        try {
            return this.createFullHierarchyDDMForm();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return new DDMForm();
        }
    }

    public Map<String, DDMFormField> getFullHierarchyDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return ddmForm.getDDMFormFieldsMap(includeNestedDDMFormFields);
    }

    public DDMStructureVersion getLatestStructureVersion() throws PortalException {
        return DDMStructureVersionLocalServiceUtil.getLatestStructureVersion((long)this.getStructureId());
    }

    public List<String> getRootFieldNames() {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return this.getDDMFormFieldNames(ddmForm.getDDMFormFields());
    }

    public DDMStructureVersion getStructureVersion() throws PortalException {
        return DDMStructureVersionLocalServiceUtil.getStructureVersion((long)this.getStructureId(), (String)this.getVersion());
    }

    public List<DDMTemplate> getTemplates() {
        return DDMTemplateLocalServiceUtil.getTemplates((long)this.getStructureId());
    }

    public String getUnambiguousName(List<DDMStructure> structures, long groupId, Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getName(locale);
        }
        boolean hasAmbiguousName = ListUtil.exists(structures, structure -> {
            if (structure.getStructureId() == this.getStructureId()) {
                return false;
            }
            String name = structure.getName(locale);
            return name.equals(this.getName(locale));
        });
        if (hasAmbiguousName) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getName(locale), locale);
        }
        return this.getName(locale);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, String webDAVToken) {
        StringBundler sb = new StringBundler(11);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        sb.append(portalURL);
        sb.append(themeDisplay.getPathContext());
        sb.append("/");
        sb.append("webdav");
        Group group = themeDisplay.getScopeGroup();
        sb.append(group.getFriendlyURL());
        sb.append("/");
        sb.append(webDAVToken);
        sb.append("/");
        sb.append("Structures");
        sb.append("/");
        sb.append(this.getStructureId());
        return sb.toString();
    }

    public boolean hasField(String fieldName) {
        DDMFormField ddmFormField = this._fetchDDMFormField(fieldName);
        if (ddmFormField != null) {
            return true;
        }
        try {
            DDMStructure parentDDMStructure = this.getParentDDMStructure();
            if (parentDDMStructure != null) {
                return parentDDMStructure.hasField(fieldName);
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
        return false;
    }

    public boolean isFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean isFieldTransient(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return Validator.isNull((String)ddmFormField.getDataType());
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        super.prepareLocalizedFieldsForImport(defaultImportLocale);
        try {
            this.setDefinition(DDMStructureLocalServiceUtil.prepareLocalizedDefinitionForImport((DDMStructure)this, (Locale)defaultImportLocale));
        }
        catch (Exception exception) {
            throw new LocaleException(2, (Throwable)exception);
        }
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setDDMForm(DDMForm ddmForm) {
        this._ddmForm = ddmForm;
    }

    @Override
    public void setDefinition(String definition) {
        super.setDefinition(definition);
        this._ddmForm = null;
    }

    protected List<DDMFormField> filterTransientDDMFormFields(List<DDMFormField> ddmFormFields) {
        return ListUtil.filter(ddmFormFields, ddmFormField -> Validator.isNotNull((String)ddmFormField.getDataType()));
    }

    protected List<String> getDDMFormFieldNames(List<DDMFormField> ddmFormFields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            fieldNames.add(ddmFormField.getName());
        }
        return fieldNames;
    }

    protected DDMStructure getParentDDMStructure() throws PortalException {
        if (this.getParentStructureId() == 0L) {
            return null;
        }
        return DDMStructureLocalServiceUtil.getStructure((long)this.getParentStructureId());
    }

    private DDMFormField _fetchDDMFormField(String fieldName) {
        DDMForm ddmForm = this._getDDMForm();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            DDMFormField targetDDMFormField = null;
            targetDDMFormField = fieldName.equals(ddmFormField.getName()) ? ddmFormField : this._getNestedDDMFormField(ddmFormField, fieldName);
            if (targetDDMFormField == null) continue;
            return targetDDMFormField;
        }
        return null;
    }

    private DDMForm _getDDMForm() {
        if (this._ddmForm == null) {
            DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)this.getDefinition());
            DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = DDMFormJSONDeserializer.internalDeserialize(builder.build());
            this._ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
        }
        return this._ddmForm;
    }

    private DDMFormField _getDDMFormField(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._fetchDDMFormField(fieldName);
        if (ddmFormField != null) {
            return ddmFormField;
        }
        try {
            DDMStructure parentDDMStructure = this.getParentDDMStructure();
            if (parentDDMStructure != null) {
                return parentDDMStructure.getDDMFormField(fieldName);
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
        throw new StructureFieldException("Unable to find field " + fieldName);
    }

    private DDMFormField _getNestedDDMFormField(DDMFormField ddmFormField, String fieldName) {
        DDMFormField nestedDDMFormField;
        DDMFormField targetDDMFormField = null;
        Iterator iterator = ddmFormField.getNestedDDMFormFields().iterator();
        while (iterator.hasNext() && (targetDDMFormField = fieldName.equals((nestedDDMFormField = (DDMFormField)iterator.next()).getName()) ? nestedDDMFormField : this._getNestedDDMFormField(nestedDDMFormField, fieldName)) == null) {
        }
        return targetDDMFormField;
    }
}

