/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.persistence.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureVersionException;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureVersionImpl;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureVersionModelImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureVersionPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DDMStructureVersionPersistenceImpl
extends BasePersistenceImpl<DDMStructureVersion>
implements DDMStructureVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDMStructureVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByStructureId;
    private FinderPath _finderPathWithoutPaginationFindByStructureId;
    private FinderPath _finderPathCountByStructureId;
    private static final String _FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2 = "ddmStructureVersion.structureId = ?";
    private FinderPath _finderPathFetchByS_V;
    private FinderPath _finderPathCountByS_V;
    private static final String _FINDER_COLUMN_S_V_STRUCTUREID_2 = "ddmStructureVersion.structureId = ? AND ";
    private static final String _FINDER_COLUMN_S_V_VERSION_2 = "ddmStructureVersion.version = ?";
    private static final String _FINDER_COLUMN_S_V_VERSION_3 = "(ddmStructureVersion.version IS NULL OR ddmStructureVersion.version = '')";
    private FinderPath _finderPathWithPaginationFindByS_S;
    private FinderPath _finderPathWithoutPaginationFindByS_S;
    private FinderPath _finderPathCountByS_S;
    private static final String _FINDER_COLUMN_S_S_STRUCTUREID_2 = "ddmStructureVersion.structureId = ? AND ";
    private static final String _FINDER_COLUMN_S_S_STATUS_2 = "ddmStructureVersion.status = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion";
    private static final String _SQL_SELECT_DDMSTRUCTUREVERSION_WHERE = "SELECT ddmStructureVersion FROM DDMStructureVersion ddmStructureVersion WHERE ";
    private static final String _SQL_COUNT_DDMSTRUCTUREVERSION = "SELECT COUNT(ddmStructureVersion) FROM DDMStructureVersion ddmStructureVersion";
    private static final String _SQL_COUNT_DDMSTRUCTUREVERSION_WHERE = "SELECT COUNT(ddmStructureVersion) FROM DDMStructureVersion ddmStructureVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddmStructureVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDMStructureVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDMStructureVersion exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureVersionPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type"});

    public List<DDMStructureVersion> findByStructureId(long structureId) {
        return this.findByStructureId(structureId, -1, -1, null);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end) {
        return this.findByStructureId(structureId, start, end, null);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findByStructureId(structureId, start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findByStructureId(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByStructureId;
            finderArgs = new Object[]{structureId};
        } else {
            finderPath = this._finderPathWithPaginationFindByStructureId;
            finderArgs = new Object[]{structureId, start, end, orderByComparator};
        }
        List<DDMStructureVersion> list = null;
        if (retrieveFromCache && (list = (List<DDMStructureVersion>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMStructureVersion ddmStructureVersion : list) {
                if (structureId == ddmStructureVersion.getStructureId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            query.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureVersion findByStructureId_First(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByStructureId_First(structureId, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByStructureId_First(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) {
        List<DDMStructureVersion> list = this.findByStructureId(structureId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion findByStructureId_Last(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByStructureId_Last(structureId, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByStructureId_Last(long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) {
        int count = this.countByStructureId(structureId);
        if (count == 0) {
            return null;
        }
        List<DDMStructureVersion> list = this.findByStructureId(structureId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion[] findByStructureId_PrevAndNext(long structureVersionId, long structureId, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByPrimaryKey(structureVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion[] array = new DDMStructureVersionImpl[]{this.getByStructureId_PrevAndNext(session, ddmStructureVersion, structureId, orderByComparator, true), ddmStructureVersion, this.getByStructureId_PrevAndNext(session, ddmStructureVersion, structureId, orderByComparator, false)};
            DDMStructureVersion[] dDMStructureVersionArray = array;
            return dDMStructureVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion getByStructureId_PrevAndNext(Session session, DDMStructureVersion ddmStructureVersion, long structureId, OrderByComparator<DDMStructureVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
        query.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(structureId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmStructureVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDMStructureVersion)list.get(1);
        }
        return null;
    }

    public void removeByStructureId(long structureId) {
        for (DDMStructureVersion ddmStructureVersion : this.findByStructureId(structureId, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countByStructureId(long structureId) {
        FinderPath finderPath = this._finderPathCountByStructureId;
        Object[] finderArgs = new Object[]{structureId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            query.append(_FINDER_COLUMN_STRUCTUREID_STRUCTUREID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureVersion findByS_V(long structureId, String version) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_V(structureId, version);
        if (ddmStructureVersion == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("structureId=");
            msg.append(structureId);
            msg.append(", version=");
            msg.append(version);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchStructureVersionException(msg.toString());
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion fetchByS_V(long structureId, String version) {
        return this.fetchByS_V(structureId, version, true);
    }

    public DDMStructureVersion fetchByS_V(long structureId, String version, boolean retrieveFromCache) {
        DDMStructureVersion ddmStructureVersion;
        version = Objects.toString(version, "");
        Object[] finderArgs = new Object[]{structureId, version};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByS_V, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof DDMStructureVersion && (structureId != (ddmStructureVersion = (DDMStructureVersion)result).getStructureId() || !Objects.equals(version, ddmStructureVersion.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append(_FINDER_COLUMN_S_V_VERSION_3);
            } else {
                bindVersion = true;
                query.append(_FINDER_COLUMN_S_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                if (bindVersion) {
                    qPos.add(version);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByS_V, finderArgs, (Object)list);
                } else {
                    DDMStructureVersion ddmStructureVersion2 = (DDMStructureVersion)list.get(0);
                    result = ddmStructureVersion2;
                    this.cacheResult(ddmStructureVersion2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByS_V, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDMStructureVersion)result;
    }

    public DDMStructureVersion removeByS_V(long structureId, String version) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByS_V(structureId, version);
        return (DDMStructureVersion)this.remove((BaseModel)ddmStructureVersion);
    }

    public int countByS_V(long structureId, String version) {
        version = Objects.toString(version, "");
        FinderPath finderPath = this._finderPathCountByS_V;
        Object[] finderArgs = new Object[]{structureId, version};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append(_FINDER_COLUMN_S_V_VERSION_3);
            } else {
                bindVersion = true;
                query.append(_FINDER_COLUMN_S_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                if (bindVersion) {
                    qPos.add(version);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status) {
        return this.findByS_S(structureId, status, -1, -1, null);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end) {
        return this.findByS_S(structureId, status, start, end, null);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findByS_S(structureId, status, start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findByS_S(long structureId, int status, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByS_S;
            finderArgs = new Object[]{structureId, status};
        } else {
            finderPath = this._finderPathWithPaginationFindByS_S;
            finderArgs = new Object[]{structureId, status, start, end, orderByComparator};
        }
        List<DDMStructureVersion> list = null;
        if (retrieveFromCache && (list = (List<DDMStructureVersion>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDMStructureVersion ddmStructureVersion : list) {
                if (structureId == ddmStructureVersion.getStructureId() && status == ddmStructureVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            query.append(_FINDER_COLUMN_S_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDMStructureVersion findByS_S_First(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_S_First(structureId, status, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByS_S_First(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) {
        List<DDMStructureVersion> list = this.findByS_S(structureId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion findByS_S_Last(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.fetchByS_S_Last(structureId, status, orderByComparator);
        if (ddmStructureVersion != null) {
            return ddmStructureVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("structureId=");
        msg.append(structureId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchStructureVersionException(msg.toString());
    }

    public DDMStructureVersion fetchByS_S_Last(long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) {
        int count = this.countByS_S(structureId, status);
        if (count == 0) {
            return null;
        }
        List<DDMStructureVersion> list = this.findByS_S(structureId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDMStructureVersion[] findByS_S_PrevAndNext(long structureVersionId, long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = this.findByPrimaryKey(structureVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion[] array = new DDMStructureVersionImpl[]{this.getByS_S_PrevAndNext(session, ddmStructureVersion, structureId, status, orderByComparator, true), ddmStructureVersion, this.getByS_S_PrevAndNext(session, ddmStructureVersion, structureId, status, orderByComparator, false)};
            DDMStructureVersion[] dDMStructureVersionArray = array;
            return dDMStructureVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion getByS_S_PrevAndNext(Session session, DDMStructureVersion ddmStructureVersion, long structureId, int status, OrderByComparator<DDMStructureVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DDMSTRUCTUREVERSION_WHERE);
        query.append("ddmStructureVersion.structureId = ? AND ");
        query.append(_FINDER_COLUMN_S_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddmStructureVersion.structureVersionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(structureId);
        qPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddmStructureVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDMStructureVersion)list.get(1);
        }
        return null;
    }

    public void removeByS_S(long structureId, int status) {
        for (DDMStructureVersion ddmStructureVersion : this.findByS_S(structureId, status, -1, -1, null)) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countByS_S(long structureId, int status) {
        FinderPath finderPath = this._finderPathCountByS_S;
        Object[] finderArgs = new Object[]{structureId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDMSTRUCTUREVERSION_WHERE);
            query.append("ddmStructureVersion.structureId = ? AND ");
            query.append(_FINDER_COLUMN_S_S_STATUS_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(structureId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDMStructureVersionPersistenceImpl() {
        this.setModelClass(DDMStructureVersion.class);
        this.setModelImplClass(DDMStructureVersionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
    }

    public void cacheResult(DDMStructureVersion ddmStructureVersion) {
        this.entityCache.putResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()), (Serializable)ddmStructureVersion);
        this.finderCache.putResult(this._finderPathFetchByS_V, new Object[]{ddmStructureVersion.getStructureId(), ddmStructureVersion.getVersion()}, (Object)ddmStructureVersion);
        ddmStructureVersion.resetOriginalValues();
    }

    public void cacheResult(List<DDMStructureVersion> ddmStructureVersions) {
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            if (this.entityCache.getResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey())) == null) {
                this.cacheResult(ddmStructureVersion);
                continue;
            }
            ddmStructureVersion.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDMStructureVersionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DDMStructureVersion ddmStructureVersion) {
        this.entityCache.removeResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DDMStructureVersionModelImpl)ddmStructureVersion, true);
    }

    public void clearCache(List<DDMStructureVersion> ddmStructureVersions) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            this.entityCache.removeResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()));
            this.clearUniqueFindersCache((DDMStructureVersionModelImpl)ddmStructureVersion, true);
        }
    }

    protected void cacheUniqueFindersCache(DDMStructureVersionModelImpl ddmStructureVersionModelImpl) {
        Object[] args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getVersion()};
        this.finderCache.putResult(this._finderPathCountByS_V, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByS_V, args, (Object)ddmStructureVersionModelImpl, false);
    }

    protected void clearUniqueFindersCache(DDMStructureVersionModelImpl ddmStructureVersionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getVersion()};
            this.finderCache.removeResult(this._finderPathCountByS_V, args);
            this.finderCache.removeResult(this._finderPathFetchByS_V, args);
        }
        if ((ddmStructureVersionModelImpl.getColumnBitmask() & this._finderPathFetchByS_V.getColumnBitmask()) != 0L) {
            args = new Object[]{ddmStructureVersionModelImpl.getOriginalStructureId(), ddmStructureVersionModelImpl.getOriginalVersion()};
            this.finderCache.removeResult(this._finderPathCountByS_V, args);
            this.finderCache.removeResult(this._finderPathFetchByS_V, args);
        }
    }

    public DDMStructureVersion create(long structureVersionId) {
        DDMStructureVersionImpl ddmStructureVersion = new DDMStructureVersionImpl();
        ddmStructureVersion.setNew(true);
        ddmStructureVersion.setPrimaryKey(structureVersionId);
        ddmStructureVersion.setCompanyId(this.companyProvider.getCompanyId());
        return ddmStructureVersion;
    }

    public DDMStructureVersion remove(long structureVersionId) throws NoSuchStructureVersionException {
        return this.remove(Long.valueOf(structureVersionId));
    }

    public DDMStructureVersion remove(Serializable primaryKey) throws NoSuchStructureVersionException {
        Session session = null;
        try {
            session = this.openSession();
            DDMStructureVersion ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, primaryKey);
            if (ddmStructureVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStructureVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDMStructureVersion dDMStructureVersion = (DDMStructureVersion)this.remove((BaseModel)ddmStructureVersion);
            return dDMStructureVersion;
        }
        catch (NoSuchStructureVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDMStructureVersion removeImpl(DDMStructureVersion ddmStructureVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddmStructureVersion)) {
                ddmStructureVersion = (DDMStructureVersion)session.get(DDMStructureVersionImpl.class, ddmStructureVersion.getPrimaryKeyObj());
            }
            if (ddmStructureVersion != null) {
                session.delete((Object)ddmStructureVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (ddmStructureVersion != null) {
            this.clearCache(ddmStructureVersion);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion updateImpl(DDMStructureVersion ddmStructureVersion) {
        boolean isNew = ddmStructureVersion.isNew();
        if (!(ddmStructureVersion instanceof DDMStructureVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddmStructureVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddmStructureVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in ddmStructureVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDMStructureVersion implementation " + ddmStructureVersion.getClass());
        }
        DDMStructureVersionModelImpl ddmStructureVersionModelImpl = (DDMStructureVersionModelImpl)ddmStructureVersion;
        Session session = null;
        try {
            session = this.openSession();
            if (ddmStructureVersion.isNew()) {
                session.save((Object)ddmStructureVersion);
                ddmStructureVersion.setNew(false);
            } else {
                ddmStructureVersion = (DDMStructureVersion)session.merge((Object)ddmStructureVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!DDMStructureVersionModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ddmStructureVersionModelImpl.getStructureId()};
            this.finderCache.removeResult(this._finderPathCountByStructureId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByStructureId, args);
            args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getStatus()};
            this.finderCache.removeResult(this._finderPathCountByS_S, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByS_S, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((ddmStructureVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByStructureId.getColumnBitmask()) != 0L) {
                args = new Object[]{ddmStructureVersionModelImpl.getOriginalStructureId()};
                this.finderCache.removeResult(this._finderPathCountByStructureId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByStructureId, args);
                args = new Object[]{ddmStructureVersionModelImpl.getStructureId()};
                this.finderCache.removeResult(this._finderPathCountByStructureId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByStructureId, args);
            }
            if ((ddmStructureVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByS_S.getColumnBitmask()) != 0L) {
                args = new Object[]{ddmStructureVersionModelImpl.getOriginalStructureId(), ddmStructureVersionModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(this._finderPathCountByS_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByS_S, args);
                args = new Object[]{ddmStructureVersionModelImpl.getStructureId(), ddmStructureVersionModelImpl.getStatus()};
                this.finderCache.removeResult(this._finderPathCountByS_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByS_S, args);
            }
        }
        this.entityCache.putResult(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionImpl.class, (Serializable)Long.valueOf(ddmStructureVersion.getPrimaryKey()), (Serializable)ddmStructureVersion, false);
        this.clearUniqueFindersCache(ddmStructureVersionModelImpl, false);
        this.cacheUniqueFindersCache(ddmStructureVersionModelImpl);
        ddmStructureVersion.resetOriginalValues();
        return ddmStructureVersion;
    }

    public DDMStructureVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchStructureVersionException {
        DDMStructureVersion ddmStructureVersion = (DDMStructureVersion)this.fetchByPrimaryKey(primaryKey);
        if (ddmStructureVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStructureVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddmStructureVersion;
    }

    public DDMStructureVersion findByPrimaryKey(long structureVersionId) throws NoSuchStructureVersionException {
        return this.findByPrimaryKey(Long.valueOf(structureVersionId));
    }

    public DDMStructureVersion fetchByPrimaryKey(long structureVersionId) {
        return (DDMStructureVersion)this.fetchByPrimaryKey(Long.valueOf(structureVersionId));
    }

    public List<DDMStructureVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDMStructureVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDMStructureVersion> findAll(int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDMStructureVersion> findAll(int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_DDMSTRUCTUREVERSION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DDMSTRUCTUREVERSION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY ddmStructureVersion.structureVersionId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDMStructureVersion ddmStructureVersion : this.findAll()) {
            this.remove((BaseModel)ddmStructureVersion);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_DDMSTRUCTUREVERSION);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "structureVersionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DDMSTRUCTUREVERSION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DDMStructureVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByStructureId = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStructureId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByStructureId = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStructureId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByStructureId = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStructureId", new String[]{Long.class.getName()});
        this._finderPathFetchByS_V = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByS_V", new String[]{Long.class.getName(), String.class.getName()}, 6L);
        this._finderPathCountByS_V = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_V", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByS_S = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByS_S = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, DDMStructureVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName()}, 3L);
        this._finderPathCountByS_S = new FinderPath(DDMStructureVersionModelImpl.ENTITY_CACHE_ENABLED, DDMStructureVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_S", new String[]{Long.class.getName(), Integer.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(DDMStructureVersionImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

