/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.security.permission.resource;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate"}, service={ModelResourcePermission.class})
public class DDMTemplateModelResourcePermission
implements ModelResourcePermission<DDMTemplate> {
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private StagingPermission _stagingPermission;

    public void check(PermissionChecker permissionChecker, DDMTemplate template, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, template, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._ddmPermissionSupport.getTemplateModelResourceName(template.getResourceClassName()), template.getTemplateId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        DDMTemplate template = this._ddmTemplateLocalService.getDDMTemplate(primaryKey);
        this.check(permissionChecker, template, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, DDMTemplate template, String actionId) throws PortalException {
        Boolean hasPermission;
        String templateModelResourceName = this._ddmPermissionSupport.getTemplateModelResourceName(template.getResourceClassName());
        String portletId = PortletProviderUtil.getPortletId((String)template.getResourceClassName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        if (Validator.isNotNull((String)portletId) && (hasPermission = this._stagingPermission.hasPermission(permissionChecker, template.getGroupId(), templateModelResourceName, template.getTemplateId(), portletId, actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(template.getCompanyId(), templateModelResourceName, template.getTemplateId(), template.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(template.getGroupId(), templateModelResourceName, template.getTemplateId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        DDMTemplate template = this._ddmTemplateLocalService.getDDMTemplate(primaryKey);
        return this.contains(permissionChecker, template, actionId);
    }

    public String getModelName() {
        return DDMTemplate.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }
}

