/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.exportimport.staged.model.repository;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.comparator.DDMFormInstanceNameComparator;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstance"}, service={DDMFormInstanceStagedModelRepository.class, StagedModelRepository.class})
public class DDMFormInstanceStagedModelRepository
implements StagedModelRepository<DDMFormInstance> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceStagedModelRepository.class);
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    public DDMFormInstance addStagedModel(PortletDataContext portletDataContext, DDMFormInstance ddmFormInstance) throws PortalException {
        long userId = portletDataContext.getUserId(ddmFormInstance.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstance);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddmFormInstance.getUuid());
        }
        return this._ddmFormInstanceLocalService.addFormInstance(userId, ddmFormInstance.getGroupId(), ddmFormInstance.getStructureId(), ddmFormInstance.getNameMap(), ddmFormInstance.getDescriptionMap(), ddmFormInstance.getSettings(), serviceContext);
    }

    public void deleteStagedModel(DDMFormInstance ddmFormInstance) throws PortalException {
        this._ddmFormInstanceLocalService.deleteFormInstance(ddmFormInstance);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMFormInstance ddmFormInstance = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddmFormInstance != null) {
            this.deleteStagedModel(ddmFormInstance);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        HashSet<Long> formInstanceDDMStructureIds = new HashSet<Long>();
        List formInstances = this._ddmFormInstanceLocalService.search(portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), null, -1, -1, (OrderByComparator)new DDMFormInstanceNameComparator());
        for (DDMFormInstance formInstance : formInstances) {
            formInstanceDDMStructureIds.add(formInstance.getStructureId());
            this._ddmFormInstanceLocalService.deleteFormInstance(formInstance);
        }
        this.deleteDDMStructures(formInstanceDDMStructureIds);
    }

    public DDMFormInstance fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddmFormInstanceLocalService.fetchDDMFormInstanceByUuidAndGroupId(uuid, groupId);
    }

    public List<DDMFormInstance> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddmFormInstanceLocalService.getDDMFormInstancesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = this._ddmFormInstanceLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DDMFormInstance>(){

            public void performAction(DDMFormInstance ddmFormInstance) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmFormInstance);
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmFormInstance.getStructure());
            }
        });
        return exportActionableDynamicQuery;
    }

    public DDMFormInstance getStagedModel(long ddmFormInstanceId) throws PortalException {
        return this._ddmFormInstanceLocalService.getDDMFormInstance(ddmFormInstanceId);
    }

    public DDMFormInstance saveStagedModel(DDMFormInstance ddmFormInstance) throws PortalException {
        return this._ddmFormInstanceLocalService.updateDDMFormInstance(ddmFormInstance);
    }

    public DDMFormInstance updateStagedModel(PortletDataContext portletDataContext, DDMFormInstance ddmFormInstance) throws PortalException {
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstance);
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return this._ddmFormInstanceLocalService.updateFormInstance(serviceContext.getUserId(), ddmFormInstance.getFormInstanceId(), ddmFormInstance.getNameMap(), ddmFormInstance.getDescriptionMap(), ddmStructure.getDDMForm(), ddmStructure.getDDMFormLayout(), ddmFormInstance.getSettingsDDMFormValues(), serviceContext);
    }

    protected void deleteDDMStructures(Set<Long> ddmStructureIds) throws PortalException {
        for (Long ddmStructureId : ddmStructureIds) {
            if (this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId.longValue()) == null) continue;
            this._ddmStructureLocalService.deleteStructure(ddmStructureId.longValue());
        }
    }
}

