/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues"}, service={DDMFormValuesExportImportContentProcessor.class, ExportImportContentProcessor.class})
public class DDMFormValuesExportImportContentProcessor
implements ExportImportContentProcessor<DDMFormValues> {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesExportImportContentProcessor.class);
    private DLAppService _dlAppService;
    private LayoutLocalService _layoutLocalService;

    public DDMFormValues replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, DDMFormValues ddmFormValues, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new FileEntryExportDDMFormFieldValueTransformer(exportReferencedContent, portletDataContext, stagedModel));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new LayoutExportDDMFormFieldValueTransformer(portletDataContext, stagedModel));
        ddmFormValuesTransformer.transform();
        return ddmFormValues;
    }

    public DDMFormValues replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new FileEntryImportDDMFormFieldValueTransformer(portletDataContext));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new LayoutImportDDMFormFieldValueTransformer(portletDataContext));
        ddmFormValuesTransformer.transform();
        return ddmFormValues;
    }

    public void validateContentReferences(long groupId, DDMFormValues ddmFormValues) {
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    private class LayoutExportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public LayoutExportDDMFormFieldValueTransformer(PortletDataContext portletDataContext, StagedModel stagedModel) {
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
        }

        public String getFieldType() {
            return "ddm-link-to-page";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                if (Validator.isNull((String)valueString)) {
                    return;
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                long groupId = GetterUtil.getLong((Object)jsonObject.get("groupId"));
                long layoutId = GetterUtil.getLong((Object)jsonObject.getLong("layoutId"));
                boolean privateLayout = jsonObject.getBoolean("privateLayout");
                Layout layout = DDMFormValuesExportImportContentProcessor.this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
                Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
                this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)layout, "dependency", true);
            }
        }
    }

    private class FileEntryImportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;

        public FileEntryImportDDMFormFieldValueTransformer(PortletDataContext portletDataContext) {
            this._portletDataContext = portletDataContext;
        }

        public String getFieldType() {
            return "ddm-documentlibrary";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                String type = jsonObject.getString("type");
                FileEntry importedFileEntry = this.fetchImportedFileEntry(this._portletDataContext, jsonObject);
                if (importedFileEntry == null) continue;
                value.addString(locale, this.toJSON(importedFileEntry, type));
            }
        }

        protected FileEntry fetchImportedFileEntry(PortletDataContext portletDataContext, JSONObject jsonObject) throws PortalException {
            block3: {
                Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
                long groupId = jsonObject.getLong("groupId");
                String uuid = jsonObject.getString("uuid");
                if ((groupId = MapUtil.getLong((Map)groupIds, (long)groupId, (long)groupId)) > 0L && Validator.isNotNull((String)uuid)) {
                    try {
                        return DDMFormValuesExportImportContentProcessor.this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
                    }
                    catch (NoSuchFileEntryException nsfee) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find file entry with uuid ", uuid, " and groupId ", String.valueOf(groupId)}), (Throwable)nsfee);
                    }
                }
            }
            return null;
        }

        protected String toJSON(FileEntry fileEntry, String type) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("groupId", fileEntry.getGroupId());
            jsonObject.put("title", fileEntry.getTitle());
            jsonObject.put("type", type);
            jsonObject.put("uuid", fileEntry.getUuid());
            return jsonObject.toString();
        }
    }

    private class FileEntryExportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final boolean _exportReferencedContent;
        private final PortletDataContext _portletDataContext;
        private final StagedModel _stagedModel;

        public FileEntryExportDDMFormFieldValueTransformer(boolean exportReferencedContent, PortletDataContext portletDataContext, StagedModel stagedModel) {
            this._exportReferencedContent = exportReferencedContent;
            this._portletDataContext = portletDataContext;
            this._stagedModel = stagedModel;
        }

        public String getFieldType() {
            return "ddm-documentlibrary";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                long groupId = GetterUtil.getLong((Object)jsonObject.get("groupId"));
                String uuid = jsonObject.getString("uuid");
                if (groupId == 0L || Validator.isNull((String)uuid)) continue;
                FileEntry fileEntry = DDMFormValuesExportImportContentProcessor.this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
                if (this._exportReferencedContent) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)this._portletDataContext, (StagedModel)this._stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    continue;
                }
                Element entityElement = this._portletDataContext.getExportDataElement((ClassedModel)this._stagedModel);
                this._portletDataContext.addReferenceElement((ClassedModel)this._stagedModel, entityElement, (ClassedModel)fileEntry, "dependency", true);
            }
        }
    }

    private static class LayoutImportDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final PortletDataContext _portletDataContext;

        public LayoutImportDDMFormFieldValueTransformer(PortletDataContext portletDataContext) {
            this._portletDataContext = portletDataContext;
        }

        public String getFieldType() {
            return "ddm-link-to-page";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                Layout importedLayout = this.fetchImportedLayout(this._portletDataContext, jsonObject);
                if (importedLayout == null) continue;
                value.addString(locale, this.toJSON(importedLayout));
            }
        }

        protected Layout fetchImportedLayout(PortletDataContext portletDataContext, JSONObject jsonObject) {
            long layoutId;
            Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
            Layout layout = (Layout)layouts.get(layoutId = jsonObject.getLong("layoutId"));
            if (layout == null && _log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find layout with ID " + layoutId));
            }
            return layout;
        }

        protected String toJSON(Layout layout) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("groupId", layout.getGroupId());
            jsonObject.put("layoutId", layout.getLayoutId());
            jsonObject.put("privateLayout", layout.isPrivateLayout());
            return jsonObject.toString();
        }
    }
}

