/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util.impl;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.FieldConstants;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.dynamic.data.mapping.util.comparator.StructureIdComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateIdComparator;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateModifiedDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@DoPrivileged
@Component(immediate=true)
public class DDMImpl
implements DDM {
    public static final String FIELDS_DISPLAY_NAME = "_fieldsDisplay";
    public static final String INSTANCE_SEPARATOR = "_INSTANCE_";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_DDM_DATE = "ddm-date";
    public static final String TYPE_DDM_DOCUMENTLIBRARY = "ddm-documentlibrary";
    public static final String TYPE_DDM_IMAGE = "ddm-image";
    public static final String TYPE_DDM_JOURNAL_ARTICLE = "ddm-journal-article";
    public static final String TYPE_DDM_LINK_TO_PAGE = "ddm-link-to-page";
    public static final String TYPE_DDM_TEXT_HTML = "ddm-text-html";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_SELECT = "select";
    private static final Log _log = LogFactoryUtil.getLog(DDMImpl.class);
    private DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private DDMFormJSONSerializer _ddmFormJSONSerializer;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private DDMFormValuesJSONSerializer _ddmFormValuesJSONSerializer;
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private DLAppLocalService _dlAppLocalService;
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private Http _http;
    private ImageLocalService _imageLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public DDMForm getDDMForm(long classNameId, long classPK) throws PortalException {
        if (classNameId <= 0L || classPK <= 0L) {
            return null;
        }
        long ddmStructureClassNameId = this._portal.getClassNameId(DDMStructure.class);
        long ddmTemplateClassNameId = this._portal.getClassNameId(DDMTemplate.class);
        if (classNameId == ddmStructureClassNameId) {
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)classPK);
            return structure.getFullHierarchyDDMForm();
        }
        if (classNameId == ddmTemplateClassNameId) {
            DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)classPK);
            return this._ddmFormJSONDeserializer.deserialize(template.getScript());
        }
        return null;
    }

    public DDMForm getDDMForm(PortletRequest portletRequest) throws PortalException {
        try {
            String definition = ParamUtil.getString((PortletRequest)portletRequest, (String)"definition");
            return this._ddmFormJSONDeserializer.deserialize(definition);
        }
        catch (PortalException pe) {
            throw new StructureDefinitionException((Throwable)pe);
        }
    }

    public DDMForm getDDMForm(String serializedJSONDDMForm) throws PortalException {
        return this._ddmFormJSONDeserializer.deserialize(serializedJSONDDMForm);
    }

    public JSONArray getDDMFormFieldsJSONArray(DDMStructure ddmStructure, String script) {
        DDMForm ddmForm = null;
        if (ddmStructure != null) {
            ddmForm = ddmStructure.getFullHierarchyDDMForm();
        }
        return this.getDDMFormFieldsJSONArray(ddmForm, script);
    }

    public JSONArray getDDMFormFieldsJSONArray(DDMStructureVersion ddmStructureVersion, String script) {
        DDMForm ddmForm = null;
        if (ddmStructureVersion != null) {
            ddmForm = ddmStructureVersion.getDDMForm();
        }
        return this.getDDMFormFieldsJSONArray(ddmForm, script);
    }

    public String getDDMFormJSONString(DDMForm ddmForm) {
        return this._ddmFormJSONSerializer.serialize(ddmForm);
    }

    public DDMFormValues getDDMFormValues(DDMForm ddmForm, String serializedJSONDDMFormValues) throws PortalException {
        return this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, serializedJSONDDMFormValues);
    }

    public DDMFormValues getDDMFormValues(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        Fields fields = this.getFields(ddmStructure.getStructureId(), fieldNamespace, serviceContext);
        return this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
    }

    public String getDDMFormValuesJSONString(DDMFormValues ddmFormValues) {
        return this._ddmFormValuesJSONSerializer.serialize(ddmFormValues);
    }

    public DDMFormLayout getDefaultDDMFormLayout(DDMForm ddmForm) {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        Locale defaultLocale = ddmForm.getDefaultLocale();
        ddmFormLayout.setDefaultLocale(defaultLocale);
        ddmFormLayout.setPaginationMode("single-page");
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        LocalizedValue title = this.getDefaultDDMFormPageTitle(defaultLocale);
        ddmFormLayoutPage.setTitle(title);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            ddmFormLayoutPage.addDDMFormLayoutRow(this.getDefaultDDMFormLayoutRow(ddmFormField));
        }
        ddmFormLayout.addDDMFormLayoutPage(ddmFormLayoutPage);
        return ddmFormLayout;
    }

    public Serializable getDisplayFieldValue(ThemeDisplay themeDisplay, Serializable fieldValue, String type) throws Exception {
        if (type.equals(TYPE_DDM_DATE)) {
            fieldValue = DateUtil.formatDate((String)"yyyy-MM-dd", (String)fieldValue.toString(), (Locale)themeDisplay.getLocale());
        } else if (type.equals(TYPE_CHECKBOX)) {
            Boolean valueBoolean = (Boolean)fieldValue;
            fieldValue = valueBoolean.booleanValue() ? LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"yes") : LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"no");
        } else if (type.equals(TYPE_DDM_DOCUMENTLIBRARY)) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
            fieldValue = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)true);
        } else if (type.equals(TYPE_DDM_LINK_TO_PAGE)) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long groupId = jsonObject.getLong("groupId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            long layoutId = jsonObject.getLong("layoutId");
            Layout layout = this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
            fieldValue = this._portal.getLayoutFriendlyURL(layout, themeDisplay);
        } else if (type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) {
            String valueString = String.valueOf(fieldValue);
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray[0];
        }
        return fieldValue;
    }

    public Fields getFields(long ddmStructureId, DDMFormValues ddmFormValues) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, ServiceContext serviceContext) throws PortalException {
        return this.getFields(ddmStructureId, ddmTemplateId, "", serviceContext);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = this.getDDMStructure(ddmStructureId, ddmTemplateId);
        Set fieldNames = ddmStructure.getFieldNames();
        boolean translating = true;
        String defaultLanguageId = (String)((Object)serviceContext.getAttribute("defaultLanguageId"));
        String toLanguageId = (String)((Object)serviceContext.getAttribute("toLanguageId"));
        if (Validator.isNull((String)toLanguageId) || Objects.equals(defaultLanguageId, toLanguageId)) {
            translating = false;
        }
        Fields fields = new Fields();
        for (String fieldName : fieldNames) {
            List<Serializable> fieldValues;
            boolean localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(fieldName, "localizable"), (boolean)true);
            if (!localizable && translating && !fieldName.startsWith("_") || (fieldValues = this.getFieldValues(ddmStructure, fieldName, fieldNamespace, serviceContext)) == null || fieldValues.isEmpty()) continue;
            Field field = this.createField(ddmStructure, fieldName, fieldValues, serviceContext);
            fields.put(field);
        }
        return fields;
    }

    public Fields getFields(long ddmStructureId, ServiceContext serviceContext) throws PortalException {
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute("ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getFields(ddmStructureId, serializedDDMFormValues);
        }
        return this.getFields(ddmStructureId, 0L, serviceContext);
    }

    public Fields getFields(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute(fieldNamespace + "ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getFields(ddmStructureId, serializedDDMFormValues);
        }
        return this.getFields(ddmStructureId, 0L, fieldNamespace, serviceContext);
    }

    public Serializable getIndexedFieldValue(Serializable fieldValue, String type) throws Exception {
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
            fieldValue = dateFormat.format(valueDate);
        } else if (type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) {
            String valueString = (String)fieldValue;
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray[0];
        }
        return fieldValue;
    }

    public OrderByComparator<DDMStructure> getStructureOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        StructureIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = new StructureIdComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new StructureModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public OrderByComparator<DDMTemplate> getTemplateOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        TemplateIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = new TemplateIdComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new TemplateModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public Fields mergeFields(Fields newFields, Fields existingFields) {
        String[] newFieldsDisplayValues = this.splitFieldsDisplayValue(newFields.get(FIELDS_DISPLAY_NAME));
        String[] existingFieldsDisplayValues = this.splitFieldsDisplayValue(existingFields.get(FIELDS_DISPLAY_NAME));
        Iterator itr = newFields.iterator(true);
        while (itr.hasNext()) {
            Field newField = (Field)itr.next();
            Field existingField = existingFields.get(newField.getName());
            if (existingField == null) {
                existingFields.put(newField);
                continue;
            }
            if (newField.isPrivate()) {
                String[] existingFieldValues = this.splitFieldsDisplayValue(existingField);
                String[] newFieldValues = this.splitFieldsDisplayValue(newField);
                if (newFieldValues.length <= existingFieldValues.length) continue;
                existingFields.put(newField);
                continue;
            }
            existingField.setDefaultLocale(newField.getDefaultLocale());
            Map<Locale, List<Serializable>> mergedFieldValuesMap = this.getMergedFieldValuesMap(newField, newFieldsDisplayValues, existingField, existingFieldsDisplayValues);
            existingField.setValuesMap(mergedFieldValuesMap);
        }
        return existingFields;
    }

    public DDMForm updateDDMFormDefaultLocale(DDMForm ddmForm, Locale newDefaultLocale) {
        DDMForm ddmFormCopy = new DDMForm(ddmForm);
        Locale defautLocale = ddmForm.getDefaultLocale();
        if (defautLocale.equals(newDefaultLocale)) {
            return ddmFormCopy;
        }
        ddmFormCopy.addAvailableLocale(newDefaultLocale);
        ddmFormCopy.setDefaultLocale(newDefaultLocale);
        this.updateDDMFormFieldsDefaultLocale(ddmFormCopy.getDDMFormFields(), newDefaultLocale);
        return ddmFormCopy;
    }

    protected void addDDMFormFieldLocalizedProperties(JSONObject jsonObject, DDMFormField ddmFormField, Locale locale, Locale defaultLocale) {
        this.addDDMFormFieldLocalizedProperty(jsonObject, "label", ddmFormField.getLabel(), locale, defaultLocale, ddmFormField.getType());
        this.addDDMFormFieldLocalizedProperty(jsonObject, "predefinedValue", ddmFormField.getPredefinedValue(), locale, defaultLocale, ddmFormField.getType());
        this.addDDMFormFieldLocalizedProperty(jsonObject, "tip", ddmFormField.getTip(), locale, defaultLocale, ddmFormField.getType());
    }

    protected void addDDMFormFieldLocalizedProperty(JSONObject jsonObject, String propertyName, LocalizedValue localizedValue, Locale locale, Locale defaultLocale, String type) {
        String propertyValue = localizedValue.getString(locale);
        if (Validator.isNull((String)propertyValue)) {
            propertyValue = localizedValue.getString(defaultLocale);
        }
        if ((type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) && propertyName.equals("predefinedValue")) {
            try {
                jsonObject.put(propertyName, JSONFactoryUtil.createJSONArray((String)propertyValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        jsonObject.put(propertyName, propertyValue);
    }

    protected void addDDMFormFieldOptions(JSONObject jsonObject, DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale) {
        String type = ddmFormField.getType();
        if (!type.equals(TYPE_RADIO) && !type.equals(TYPE_SELECT)) {
            return;
        }
        String fieldName = ddmFormField.getName();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            JSONObject optionJSONObject = JSONFactoryUtil.createJSONObject();
            String name = fieldName.concat(StringUtil.randomString());
            optionJSONObject.put("id", name);
            optionJSONObject.put("name", name);
            optionJSONObject.put("type", "option");
            optionJSONObject.put("value", optionValue);
            this.addDDMFormFieldLocalizedProperty(optionJSONObject, "label", ddmFormFieldOptions.getOptionLabels(optionValue), defaultLocale, defaultLocale, "option");
            JSONObject localizationMapJSONObject = JSONFactoryUtil.createJSONObject();
            for (Locale availableLocale : availableLocales) {
                JSONObject localeMap = JSONFactoryUtil.createJSONObject();
                this.addDDMFormFieldLocalizedProperty(localeMap, "label", ddmFormFieldOptions.getOptionLabels(optionValue), availableLocale, defaultLocale, "option");
                localizationMapJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localeMap);
            }
            optionJSONObject.put("localizationMap", localizationMapJSONObject);
            jsonArray.put(optionJSONObject);
        }
        jsonObject.put("options", jsonArray);
    }

    protected int countFieldRepetition(String[] fieldsDisplayValues, String fieldName) {
        int count = 0;
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            String prefix = StringUtil.extractFirst((String)fieldsDisplayValue, (String)INSTANCE_SEPARATOR);
            if (!prefix.equals(fieldName)) continue;
            ++count;
        }
        return count;
    }

    protected Field createField(DDMStructure ddmStructure, String fieldName, List<Serializable> fieldValues, ServiceContext serviceContext) {
        Field field = new Field();
        field.setDDMStructureId(ddmStructure.getStructureId());
        String languageId = GetterUtil.getString((Object)serviceContext.getAttribute("languageId"), (String)serviceContext.getLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        String defaultLanguageId = GetterUtil.getString((Object)serviceContext.getAttribute("defaultLanguageId"));
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        if (fieldName.startsWith("_")) {
            locale = LocaleUtil.getSiteDefault();
            defaultLocale = LocaleUtil.getSiteDefault();
        }
        field.setDefaultLocale(defaultLocale);
        field.setName(fieldName);
        field.setValues(locale, fieldValues);
        return field;
    }

    protected JSONArray getDDMFormFieldsJSONArray(DDMForm ddmForm, String script) {
        JSONArray ddmFormFieldsJSONArray;
        block5: {
            ddmFormFieldsJSONArray = null;
            if (ddmForm != null) {
                ddmFormFieldsJSONArray = this.getDDMFormFieldsJSONArray(ddmForm.getDDMFormFields(), ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
            } else if (Validator.isNotNull((String)script)) {
                try {
                    DDMForm scriptDDMForm = this._ddmFormJSONDeserializer.deserialize(script);
                    ddmFormFieldsJSONArray = this.getDDMFormFieldsJSONArray(scriptDDMForm.getDDMFormFields(), scriptDDMForm.getAvailableLocales(), scriptDDMForm.getDefaultLocale());
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)"Unable to deserialize script", (Throwable)pe);
                }
            }
        }
        return ddmFormFieldsJSONArray;
    }

    protected JSONArray getDDMFormFieldsJSONArray(List<DDMFormField> ddmFormFields, Set<Locale> availableLocales, Locale defaultLocale) {
        JSONArray ddmFormFieldsJSONArray = JSONFactoryUtil.createJSONArray();
        for (DDMFormField ddmFormField : ddmFormFields) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("dataType", ddmFormField.getDataType());
            jsonObject.put("id", ddmFormField.getName());
            jsonObject.put("indexType", ddmFormField.getIndexType());
            jsonObject.put("localizable", ddmFormField.isLocalizable());
            jsonObject.put("multiple", ddmFormField.isMultiple());
            jsonObject.put("name", ddmFormField.getName());
            jsonObject.put("readOnly", ddmFormField.isReadOnly());
            jsonObject.put("repeatable", ddmFormField.isRepeatable());
            jsonObject.put("required", ddmFormField.isRequired());
            jsonObject.put("showLabel", ddmFormField.isShowLabel());
            jsonObject.put("type", ddmFormField.getType());
            this.addDDMFormFieldLocalizedProperties(jsonObject, ddmFormField, defaultLocale, defaultLocale);
            this.addDDMFormFieldOptions(jsonObject, ddmFormField, availableLocales, defaultLocale);
            JSONObject localizationMapJSONObject = JSONFactoryUtil.createJSONObject();
            for (Locale availableLocale : availableLocales) {
                JSONObject localeMap = JSONFactoryUtil.createJSONObject();
                this.addDDMFormFieldLocalizedProperties(localeMap, ddmFormField, availableLocale, defaultLocale);
                localizationMapJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localeMap);
            }
            jsonObject.put("localizationMap", localizationMapJSONObject);
            jsonObject.put("fields", this.getDDMFormFieldsJSONArray(ddmFormField.getNestedDDMFormFields(), availableLocales, defaultLocale));
            ddmFormFieldsJSONArray.put(jsonObject);
        }
        return ddmFormFieldsJSONArray;
    }

    protected DDMStructure getDDMStructure(long ddmStructureId, long ddmTemplateId) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)ddmTemplateId);
        if (ddmTemplate != null) {
            ddmStructure = (DDMStructure)ddmStructure.clone();
            ddmStructure.setDefinition(ddmTemplate.getScript());
        }
        return ddmStructure;
    }

    protected DDMFormLayoutRow getDefaultDDMFormLayoutRow(DDMFormField ddmFormField) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        ddmFormLayoutRow.addDDMFormLayoutColumn(new DDMFormLayoutColumn(12, new String[]{ddmFormField.getName()}));
        return ddmFormLayoutRow;
    }

    protected LocalizedValue getDefaultDDMFormPageTitle(Locale defaultLocale) {
        LocalizedValue title = new LocalizedValue(defaultLocale);
        title.addString(defaultLocale, "");
        return title;
    }

    protected int getExistingFieldValueIndex(String[] newFieldsDisplayValues, String[] existingFieldsDisplayValues, String fieldName, int index) {
        String instanceId = this.getFieldIntanceId(newFieldsDisplayValues, fieldName, index);
        return this.getFieldValueIndex(existingFieldsDisplayValues, fieldName, instanceId);
    }

    protected String getFieldIntanceId(String[] fieldsDisplayValues, String fieldName, int index) {
        String prefix = fieldName.concat(INSTANCE_SEPARATOR);
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            if (!fieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)fieldsDisplayValue, (String)INSTANCE_SEPARATOR);
        }
        return null;
    }

    protected List<String> getFieldNames(String fieldNamespace, String fieldName, ServiceContext serviceContext) {
        String[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)serviceContext.getAttribute(fieldNamespace + FIELDS_DISPLAY_NAME))));
        List privateFieldNames = ListUtil.fromArray((Object[])new String[]{FIELDS_DISPLAY_NAME});
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (fieldsDisplayValues.length == 0 || privateFieldNames.contains(fieldName)) {
            fieldNames.add(fieldNamespace + fieldName);
        } else {
            for (String namespacedFieldName : fieldsDisplayValues) {
                String fieldNameValue = StringUtil.extractFirst((String)namespacedFieldName, (String)INSTANCE_SEPARATOR);
                if (!fieldNameValue.equals(fieldName)) continue;
                fieldNames.add(fieldNamespace + namespacedFieldName);
            }
        }
        return fieldNames;
    }

    protected Fields getFields(long ddmStructureId, String serializedDDMFormValues) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMFormValues ddmFormValues = this.getDDMFormValues(ddmStructure.getFullHierarchyDDMForm(), serializedDDMFormValues);
        return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
    }

    protected int getFieldValueIndex(String[] fieldsDisplayValues, String fieldName, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            return -1;
        }
        int offset = 0;
        String prefix = fieldName.concat(INSTANCE_SEPARATOR);
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            if (!fieldsDisplayValue.startsWith(prefix)) continue;
            String fieldIstanceId = StringUtil.extractLast((String)fieldsDisplayValue, (String)INSTANCE_SEPARATOR);
            if (fieldIstanceId.equals(instanceId)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    protected List<Serializable> getFieldValues(DDMStructure ddmStructure, String fieldName, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(fieldName);
        String fieldDataType = ddmFormField.getDataType();
        String fieldType = ddmFormField.getType();
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        List<String> fieldNames = this.getFieldNames(fieldNamespace, fieldName, serviceContext);
        ArrayList<Serializable> fieldValues = new ArrayList<Serializable>(fieldNames.size());
        for (String fieldNameValue : fieldNames) {
            String predefinedValueString;
            String imageFieldValue;
            HttpServletRequest request;
            Object fieldValue = serviceContext.getAttribute(fieldNameValue);
            if (Validator.isNull((Object)fieldValue)) {
                fieldValue = predefinedValue.getString(serviceContext.getLocale());
            }
            if (fieldType.equals(TYPE_CHECKBOX) && Validator.isNull((Object)fieldValue)) {
                fieldValue = "false";
            } else if (fieldDataType.equals("date")) {
                Date fieldValueDate = null;
                if (Validator.isNull((Object)fieldValue)) {
                    int fieldValueMonth = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Month"));
                    int fieldValueDay = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Day"));
                    int fieldValueYear = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Year"));
                    fieldValueDate = this._portal.getDate(fieldValueMonth, fieldValueDay, fieldValueYear);
                } else {
                    try {
                        fieldValueDate = DateUtil.parseDate((String)String.valueOf(fieldValue), (Locale)serviceContext.getLocale());
                    }
                    catch (ParseException pe) {
                        _log.error((Object)("Unable to parse date " + fieldValue));
                    }
                }
                if (fieldValueDate != null) {
                    fieldValue = String.valueOf(fieldValueDate.getTime());
                }
            } else if (fieldDataType.equals("image") && Validator.isNull((Object)fieldValue) && (request = serviceContext.getRequest()) instanceof UploadRequest && Validator.isNotNull((String)(imageFieldValue = this.getImageFieldValue((UploadRequest)request, fieldNameValue)))) {
                fieldValue = imageFieldValue;
            }
            if (Validator.isNull((Object)fieldValue)) {
                return null;
            }
            if ((TYPE_RADIO.equals(fieldType) || TYPE_SELECT.equals(fieldType)) && !fieldValue.equals(predefinedValueString = predefinedValue.getString(serviceContext.getLocale())) && fieldValue instanceof String) {
                fieldValue = new String[]{String.valueOf(fieldValue)};
                fieldValue = JSONFactoryUtil.serialize((Object)fieldValue);
            }
            Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)GetterUtil.getString((Object)fieldValue));
            fieldValues.add(fieldValueSerializable);
        }
        return fieldValues;
    }

    protected List<Serializable> getFieldValues(Field field, Locale locale) {
        Map fieldValuesMap = field.getValuesMap();
        return (List)fieldValuesMap.get(locale);
    }

    protected byte[] getImageBytes(UploadRequest uploadRequest, String fieldNameValue) throws Exception {
        File file = uploadRequest.getFile(fieldNameValue + "File");
        byte[] bytes = FileUtil.getBytes((File)file);
        if (ArrayUtil.isNotEmpty((byte[])bytes)) {
            return bytes;
        }
        String url = uploadRequest.getParameter(fieldNameValue + "URL");
        long imageId = GetterUtil.getLong((String)this._http.getParameter(url, "img_id", false));
        Image image = this._imageLocalService.fetchImage(imageId);
        if (image == null) {
            return null;
        }
        return image.getTextObj();
    }

    protected String getImageFieldValue(UploadRequest uploadRequest, String fieldNameValue) {
        try {
            byte[] bytes = this.getImageBytes(uploadRequest, fieldNameValue);
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("alt", uploadRequest.getParameter(fieldNameValue + "Alt"));
                jsonObject.put("data", UnicodeFormatter.bytesToHex((byte[])bytes));
                return jsonObject.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected Set<Locale> getMergedAvailableLocales(Set<Locale> newFieldAvailableLocales, Set<Locale> existingFieldAvailableLocales) {
        HashSet<Locale> mergedAvailableLocales = new HashSet<Locale>();
        mergedAvailableLocales.addAll(newFieldAvailableLocales);
        mergedAvailableLocales.addAll(existingFieldAvailableLocales);
        return mergedAvailableLocales;
    }

    protected List<Serializable> getMergedFieldValues(String fieldName, List<Serializable> newFieldValues, String[] newFieldsDisplayValues, List<Serializable> existingFieldValues, String[] existingFieldsDisplayValues, List<Serializable> defaultFieldValues) {
        if (existingFieldValues == null) {
            return newFieldValues;
        }
        ArrayList<Serializable> mergedLocaleValues = new ArrayList<Serializable>();
        int repetition = this.countFieldRepetition(newFieldsDisplayValues, fieldName);
        for (int i = 0; i < repetition; ++i) {
            int existingFieldValueIndex = this.getExistingFieldValueIndex(newFieldsDisplayValues, existingFieldsDisplayValues, fieldName, i);
            if (existingFieldValueIndex == -1) {
                mergedLocaleValues.add(i, defaultFieldValues.get(i));
                continue;
            }
            if (newFieldValues != null) {
                mergedLocaleValues.add(i, newFieldValues.get(i));
                continue;
            }
            Serializable existingValue = existingFieldValues.get(existingFieldValueIndex);
            mergedLocaleValues.add(i, existingValue);
        }
        return mergedLocaleValues;
    }

    protected Map<Locale, List<Serializable>> getMergedFieldValuesMap(Field newField, String[] newFieldsDisplayValues, Field existingField, String[] existingFieldsDisplayValues) {
        Set<Locale> availableLocales = this.getMergedAvailableLocales(newField.getAvailableLocales(), existingField.getAvailableLocales());
        for (Locale locale : availableLocales) {
            List<Serializable> newFieldValues = this.getFieldValues(newField, locale);
            List<Serializable> existingFieldValues = this.getFieldValues(existingField, locale);
            List<Serializable> defaultFieldValues = this.getFieldValues(newField, newField.getDefaultLocale());
            List<Serializable> mergedLocaleValues = this.getMergedFieldValues(newField.getName(), newFieldValues, newFieldsDisplayValues, existingFieldValues, existingFieldsDisplayValues, defaultFieldValues);
            existingField.setValues(locale, mergedLocaleValues);
        }
        return existingField.getValuesMap();
    }

    @Reference(unbind="-")
    protected void setDDMFormJSONDeserializer(DDMFormJSONDeserializer ddmFormJSONDeserializer) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormJSONSerializer(DDMFormJSONSerializer ddmFormJSONSerializer) {
        this._ddmFormJSONSerializer = ddmFormJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONSerializer(DDMFormValuesJSONSerializer ddmFormValuesJSONSerializer) {
        this._ddmFormValuesJSONSerializer = ddmFormValuesJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setFieldsToDDMFormValuesConverter(FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }

    protected void updateDDMFormFieldDefaultLocale(DDMFormField ddmFormField, Locale newDefaultLocale) {
        this.updateDDMFormFieldOptionsDefaultLocale(ddmFormField.getDDMFormFieldOptions(), newDefaultLocale);
        this.updateLocalizedValueDefaultLocale(ddmFormField.getLabel(), newDefaultLocale);
        this.updateLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), newDefaultLocale);
        this.updateLocalizedValueDefaultLocale(ddmFormField.getStyle(), newDefaultLocale);
        this.updateLocalizedValueDefaultLocale(ddmFormField.getTip(), newDefaultLocale);
    }

    protected void updateDDMFormFieldOptionsDefaultLocale(DDMFormFieldOptions ddmFormFieldOptions, Locale newDefaultLocale) {
        Map options = ddmFormFieldOptions.getOptions();
        for (LocalizedValue localizedValue : options.values()) {
            this.updateLocalizedValueDefaultLocale(localizedValue, newDefaultLocale);
        }
        ddmFormFieldOptions.setDefaultLocale(newDefaultLocale);
    }

    protected void updateDDMFormFieldsDefaultLocale(List<DDMFormField> ddmFormFields, Locale newDefaultLocale) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this.updateDDMFormFieldDefaultLocale(ddmFormField, newDefaultLocale);
            this.updateDDMFormFieldsDefaultLocale(ddmFormField.getNestedDDMFormFields(), newDefaultLocale);
        }
    }

    protected void updateLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale newDefaultLocale) {
        Set availableLocales = localizedValue.getAvailableLocales();
        if (!availableLocales.contains(newDefaultLocale)) {
            String defaultValueString = localizedValue.getString(localizedValue.getDefaultLocale());
            localizedValue.addString(newDefaultLocale, defaultValueString);
        }
        localizedValue.setDefaultLocale(newDefaultLocale);
    }
}

