/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.permission;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.permission.DDMPermissionSupportTracker;
import com.liferay.dynamic.data.mapping.util.DDMStructurePermissionSupport;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseResourcePermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMStructurePermission.class})
public class DDMStructurePermission
extends BaseResourcePermissionChecker {
    private static DDMPermissionSupportTracker _ddmPermissionSupportTracker;
    private static DDMStructureLocalService _ddmStructureLocalService;

    public static void check(PermissionChecker permissionChecker, DDMStructure structure, String actionId) throws PortalException {
        if (!DDMStructurePermission.contains(permissionChecker, structure, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMStructurePermission.getStructureModelResourceName(structure.getClassNameId()), structure.getStructureId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long classNameId, String structureKey, String actionId) throws PortalException {
        DDMStructure structure = _ddmStructureLocalService.getStructure(groupId, classNameId, structureKey, true);
        DDMStructurePermission.check(permissionChecker, structure, actionId);
    }

    public static void check(PermissionChecker permissionChecker, long structureId, String actionId) throws PortalException {
        DDMStructure structure = _ddmStructureLocalService.getStructure(structureId);
        DDMStructurePermission.check(permissionChecker, structure, actionId);
    }

    public static void checkAddStruturePermission(PermissionChecker permissionChecker, long groupId, long classNameId) throws PortalException {
        if (!DDMStructurePermission.containsAddStruturePermission(permissionChecker, groupId, classNameId)) {
            ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper = _ddmPermissionSupportTracker.getDDMStructurePermissionSupportServiceWrapper(classNameId);
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMStructurePermission.getResourceName(structurePermissionSupportServiceWrapper), groupId, new String[]{DDMStructurePermission.getAddStructureActionId(structurePermissionSupportServiceWrapper)});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMStructure structure, String actionId) throws PortalException {
        return DDMStructurePermission.contains(permissionChecker, structure, null, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMStructure structure, String portletId, String actionId) throws PortalException {
        Boolean hasPermission;
        String structureModelResourceName = DDMStructurePermission.getStructureModelResourceName(structure.getClassNameId());
        if (Validator.isNotNull((String)portletId) && (hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)structure.getGroupId(), (String)structureModelResourceName, (long)structure.getStructureId(), (String)portletId, (String)actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(structure.getCompanyId(), structureModelResourceName, structure.getStructureId(), structure.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(structure.getGroupId(), structureModelResourceName, structure.getStructureId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long classNameId, String structureKey, String actionId) throws PortalException {
        DDMStructure structure = _ddmStructureLocalService.getStructure(groupId, classNameId, structureKey, true);
        return DDMStructurePermission.contains(permissionChecker, structure, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long structureId, String actionId) throws PortalException {
        return DDMStructurePermission.contains(permissionChecker, structureId, null, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long structureId, String portletId, String actionId) throws PortalException {
        DDMStructure structure = _ddmStructureLocalService.getStructure(structureId);
        return DDMStructurePermission.contains(permissionChecker, structure, portletId, actionId);
    }

    public static boolean containsAddStruturePermission(PermissionChecker permissionChecker, long groupId, long classNameId) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper = _ddmPermissionSupportTracker.getDDMStructurePermissionSupportServiceWrapper(classNameId);
        return DDMStructurePermission.contains((PermissionChecker)permissionChecker, (String)DDMStructurePermission.getResourceName(structurePermissionSupportServiceWrapper), (long)groupId, (String)DDMStructurePermission.getAddStructureActionId(structurePermissionSupportServiceWrapper));
    }

    public static String getStructureModelResourceName(long classNameId) throws PortalException {
        ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper = _ddmPermissionSupportTracker.getDDMStructurePermissionSupportServiceWrapper(classNameId);
        Map properties = structurePermissionSupportServiceWrapper.getProperties();
        boolean defaultModelResourceName = MapUtil.getBoolean((Map)properties, (String)"default.model.resource.name");
        if (defaultModelResourceName) {
            return DDMStructure.class.getName();
        }
        StringBundler sb = new StringBundler(3);
        sb.append(PortalUtil.getClassName((long)classNameId));
        sb.append(ResourceActionsUtil.getCompositeModelNameSeparator());
        sb.append(DDMStructure.class.getName());
        return sb.toString();
    }

    public Boolean checkResource(PermissionChecker permissionChecker, long classPK, String actionId) {
        try {
            return DDMStructurePermission.contains(permissionChecker, classPK, actionId);
        }
        catch (PortalException pe) {
            return false;
        }
    }

    protected static String getAddStructureActionId(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper) {
        Map properties = structurePermissionSupportServiceWrapper.getProperties();
        return MapUtil.getString((Map)properties, (String)"add.structure.action.id", (String)"ADD_STRUCTURE");
    }

    protected static String getResourceName(ServiceTrackerCustomizerFactory.ServiceWrapper<DDMStructurePermissionSupport> structurePermissionSupportServiceWrapper) {
        DDMStructurePermissionSupport structurePermissionSupport = (DDMStructurePermissionSupport)structurePermissionSupportServiceWrapper.getService();
        return structurePermissionSupport.getResourceName();
    }

    @Reference(unbind="-")
    protected void setDDMPermissionSupportTracker(DDMPermissionSupportTracker ddmPermissionSupportTracker) {
        _ddmPermissionSupportTracker = ddmPermissionSupportTracker;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        _ddmStructureLocalService = ddmStructureLocalService;
    }
}

