/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.io.DDMFormXSDDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.XPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormXSDDeserializer.class})
public class DDMFormXSDDeserializerImpl
implements DDMFormXSDDeserializer {
    private SAXReader _saxReader;

    public DDMForm deserialize(String serializedDDMForm) throws PortalException {
        try {
            Document document = this._saxReader.read(serializedDDMForm);
            DDMForm ddmForm = new DDMForm();
            this.setDDMFormAvailableLocales(document.getRootElement(), ddmForm);
            this.setDDMFormDefaultLocale(document.getRootElement(), ddmForm);
            this.setDDMFormFields(document.getRootElement(), ddmForm);
            this.setDDMFormLocalizedValuesDefaultLocale(ddmForm);
            return ddmForm;
        }
        catch (DocumentException de) {
            throw new PortalException((Throwable)de);
        }
    }

    protected void addOptionValueLabels(Element dynamicElementElement, DDMFormFieldOptions ddmFormFieldOptions, String optionValue) {
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String languageId = metadataElement.attributeValue("locale");
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            Element labelElement = this.fetchMetadataEntry(metadataElement, "label");
            ddmFormFieldOptions.addOptionLabel(optionValue, locale, labelElement.getText());
        }
    }

    protected Element fetchMetadataEntry(Element parentElement, String entryName) {
        XPath xPathSelector = this._saxReader.createXPath("entry[@name=" + HtmlUtil.escapeXPathAttribute((String)entryName) + "]");
        return (Element)xPathSelector.selectSingleNode((Object)parentElement);
    }

    protected Set<Locale> getAvailableLocales(Element rootElement) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        String availableLanguageIds = rootElement.attributeValue("available-locales");
        for (String availableLanguageId : StringUtil.split((String)availableLanguageIds)) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)availableLanguageId);
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormField getDDMFormField(Element dynamicElementElement) {
        String name = dynamicElementElement.attributeValue("name");
        String type = dynamicElementElement.attributeValue("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this.setDDMFormFieldDataType(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldIndexType(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldLocalizable(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldMultiple(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldNamespace(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldReadOnly(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldRepeatable(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldRequired(dynamicElementElement, ddmFormField);
        this.setDDMFormFieldShowLabel(dynamicElementElement, ddmFormField);
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            this.setDDMFormFieldMetadata(metadataElement, ddmFormField);
        }
        if (type.equals("radio") || type.equals("select")) {
            this.setDDMFormFieldOptions(dynamicElementElement, ddmFormField);
        } else {
            this.setNestedDDMFormField(dynamicElementElement, ddmFormField);
        }
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(List<Element> dynamicElementElements) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (Element dynamicElementElement : dynamicElementElements) {
            String value = dynamicElementElement.attributeValue("value");
            ddmFormFieldOptions.addOption(value);
            this.addOptionValueLabels(dynamicElementElement, ddmFormFieldOptions, value);
        }
        return ddmFormFieldOptions;
    }

    protected List<DDMFormField> getDDMFormFields(Element rootElement) {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (Element dynamicElement : rootElement.elements("dynamic-element")) {
            DDMFormField ddmFormField = this.getDDMFormField(dynamicElement);
            ddmFormFields.add(ddmFormField);
        }
        return ddmFormFields;
    }

    protected Locale getDefaultLocale(Element rootElement) {
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        return LocaleUtil.fromLanguageId((String)defaultLanguageId);
    }

    protected void setDDMFormAvailableLocales(Element rootElement, DDMForm ddmForm) {
        Set<Locale> availableLocales = this.getAvailableLocales(rootElement);
        ddmForm.setAvailableLocales(availableLocales);
    }

    protected void setDDMFormDefaultLocale(Element rootElement, DDMForm ddmForm) {
        Locale defaultLocale = this.getDefaultLocale(rootElement);
        ddmForm.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFieldDataType(Element dynamicElementElement, DDMFormField ddmFormField) {
        String dataType = dynamicElementElement.attributeValue("dataType");
        ddmFormField.setDataType(dataType);
    }

    protected void setDDMFormFieldIndexType(Element dynamicElementElement, DDMFormField ddmFormField) {
        String indexType = dynamicElementElement.attributeValue("indexType");
        ddmFormField.setIndexType(indexType);
    }

    protected void setDDMFormFieldLocalizable(Element dynamicElementElement, DDMFormField ddmFormField) {
        boolean localizable = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("localizable"), (boolean)true);
        ddmFormField.setLocalizable(localizable);
    }

    protected void setDDMFormFieldLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale defaultLocale) {
        if (localizedValue == null) {
            return;
        }
        localizedValue.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFieldLocalizedValuesDefaultLocale(DDMFormField ddmFormField, Locale defaultLocale) {
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getLabel(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getStyle(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getTip(), defaultLocale);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions != null) {
            ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(nestedDDMFormField, defaultLocale);
        }
    }

    protected void setDDMFormFieldMetadata(Element metadataElement, DDMFormField ddmFormField) {
        Element tipElement;
        Element styleElement;
        Element predefinedValueElement;
        String languageId = metadataElement.attributeValue("locale");
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        Element labelElement = this.fetchMetadataEntry(metadataElement, "label");
        if (labelElement != null) {
            LocalizedValue label = ddmFormField.getLabel();
            label.addString(locale, labelElement.getText());
        }
        if ((predefinedValueElement = this.fetchMetadataEntry(metadataElement, "predefinedValue")) != null) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            predefinedValue.addString(locale, predefinedValueElement.getText());
        }
        if ((styleElement = this.fetchMetadataEntry(metadataElement, "style")) != null) {
            LocalizedValue style = ddmFormField.getStyle();
            style.addString(locale, styleElement.getText());
        }
        if ((tipElement = this.fetchMetadataEntry(metadataElement, "tip")) != null) {
            LocalizedValue tip = ddmFormField.getTip();
            tip.addString(locale, tipElement.getText());
        }
    }

    protected void setDDMFormFieldMultiple(Element dynamicElementElement, DDMFormField ddmFormField) {
        boolean multiple = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("multiple"));
        ddmFormField.setMultiple(multiple);
    }

    protected void setDDMFormFieldNamespace(Element dynamicElementElement, DDMFormField ddmFormField) {
        String fieldNamespace = dynamicElementElement.attributeValue("fieldNamespace");
        ddmFormField.setFieldNamespace(fieldNamespace);
    }

    protected void setDDMFormFieldOptions(Element dynamicElementElement, DDMFormField ddmFormField) {
        DDMFormFieldOptions ddmFormFieldOptions = this.getDDMFormFieldOptions(dynamicElementElement.elements("dynamic-element"));
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
    }

    protected void setDDMFormFieldReadOnly(Element dynamicElementElement, DDMFormField ddmFormField) {
        boolean readOnly = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("readOnly"));
        ddmFormField.setReadOnly(readOnly);
    }

    protected void setDDMFormFieldRepeatable(Element dynamicElementElement, DDMFormField ddmFormField) {
        boolean repeatable = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("repeatable"));
        ddmFormField.setRepeatable(repeatable);
    }

    protected void setDDMFormFieldRequired(Element dynamicElementElement, DDMFormField ddmFormField) {
        boolean required = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("required"));
        ddmFormField.setRequired(required);
    }

    protected void setDDMFormFields(Element rootElement, DDMForm ddmForm) {
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(rootElement);
        ddmForm.setDDMFormFields(ddmFormFields);
    }

    protected void setDDMFormFieldShowLabel(Element dynamicElementElement, DDMFormField ddmFormField) {
        boolean showLabel = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("showLabel"), (boolean)true);
        ddmFormField.setShowLabel(showLabel);
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(ddmFormField, ddmForm.getDefaultLocale());
        }
    }

    protected void setNestedDDMFormField(Element dynamicElementElement, DDMFormField ddmFormField) {
        List<DDMFormField> nestedDDMFormFields = this.getDDMFormFields(dynamicElementElement);
        ddmFormField.setNestedDDMFormFields(nestedDDMFormFields);
    }

    @Reference(unbind="-")
    protected void setSAXReader(SAXReader saxReader) {
        this._saxReader = saxReader;
    }
}

