Liferay.Loader.define('dynamic-data-mapping-form-web$clipboard@2.0.4/webpack.config', ['module', 'exports', 'require', './package.json', 'dynamic-data-mapping-form-web$path', 'dynamic-data-mapping-form-web$webpack', 'dynamic-data-mapping-form-web$uglifyjs-webpack-plugin', 'dynamic-data-mapping-form-web$os'], function (module, exports, require) {
    var define = undefined;
    const pkg = require('./package.json');
    const path = require('dynamic-data-mapping-form-web$path');
    const webpack = require('dynamic-data-mapping-form-web$webpack');
    const UglifyJSPlugin = require('dynamic-data-mapping-form-web$uglifyjs-webpack-plugin');

    const production = true || false;

    const banner = `clipboard.js v${pkg.version}
https://zenorocha.github.io/clipboard.js

Licensed MIT © Zeno Rocha`;

    module.exports = {
        entry: './src/clipboard.js',
        mode: 'production',
        output: {
            filename: 'clipboard.min.js',
            path: path.resolve(__dirname, 'dist'),
            library: 'ClipboardJS',
            libraryTarget: 'umd',
            globalObject: 'this'
        },
        module: {
            rules: [{ test: /\.js$/, exclude: /node_modules/, loader: 'babel-loader' }]
        },
        optimization: {
            minimize: production,
            minimizer: [new UglifyJSPlugin({
                parallel: require('dynamic-data-mapping-form-web$os').cpus().length,
                uglifyOptions: {
                    ie8: false,
                    keep_fnames: false,
                    output: {
                        beautify: false,
                        comments: (node, { value, type }) => type == 'comment2' && value.startsWith('!')
                    }
                }
            })]
        },
        plugins: [new webpack.BannerPlugin({ banner })]
    };
});
//# sourceMappingURL=webpack.config.js.map