Liferay.Loader.define("dynamic-data-mapping-form-web@3.0.19/admin/js/components/Popover/Popover.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-position', './PopoverBase.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _metalJsx = _interopRequireWildcard(require("frontend-js-metal-web$metal-jsx"));

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _PopoverBase = _interopRequireDefault(require("./PopoverBase.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var POSITIONS = ['top', 'left', 'right', 'bottom'];

  var getAlignPosition = function getAlignPosition(source, target, suggestedPosition) {
    if (!suggestedPosition) {
      suggestedPosition = _metalPosition.Align.TopCenter;
    }

    var position = _metalPosition.Align.align(source, target, suggestedPosition);

    var returnedPositon = POSITIONS[position];

    if (!returnedPositon) {
      returnedPositon = 'left';
    }

    return returnedPositon;
  };

  var CLASSNAME = 'ddm-share-url-popover';

  var Popover =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Popover, _Component);

    function Popover() {
      _classCallCheck(this, Popover);

      return _possibleConstructorReturn(this, _getPrototypeOf(Popover).apply(this, arguments));
    }

    _createClass(Popover, [{
      key: "attached",
      value: function attached() {
        var alignElement = this.props.alignElement;
        this._eventHandler = new _metalEvents.EventHandler();

        this._eventHandler.add(_metalDom["default"].on(document, 'mousedown', this._handleDocumentMouseDown.bind(this), true), _metalDom["default"].on(alignElement, 'click', this._handleAlignElementClicked.bind(this)));

        return this.setPopoverWidth();
      }
    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(Popover.prototype), "disposeInternal", this).call(this);

        this._eventHandler.removeAllListeners();
      }
    }, {
      key: "render",
      value: function render() {
        var _this = this;

        var _this$props = this.props,
            alignElement = _this$props.alignElement,
            children = _this$props.children,
            content = _this$props.content,
            placement = _this$props.placement,
            title = _this$props.title;
        var _this$state = this.state,
            displayed = _this$state.displayed,
            position = _this$state.position,
            width = _this$state.width;
        var classes = (0, _classnames["default"])(CLASSNAME, {
          'popover-large': width > 600
        });
        IncrementalDOM.elementOpen(_PopoverBase["default"], null, null, "elementClasses", classes, "events", {
          stateSynced: function stateSynced() {
            if (!displayed) {
              return;
            }

            _this.setState({
              position: getAlignPosition(_this.refs.popover.element, alignElement, placement)
            });
          }
        }, "placement", position, "visible", displayed, "ref", "popover");
        iDOMHelpers.renderArbitrary(title && (IncrementalDOM.elementOpen(_PopoverBase["default"].Header), iDOMHelpers.renderArbitrary(title), IncrementalDOM.elementClose(_PopoverBase["default"].Header)));
        IncrementalDOM.elementOpen(_PopoverBase["default"].Body);
        iDOMHelpers.renderArbitrary(content && (IncrementalDOM.elementOpen("span", null, null, "class", "text-secondary"), iDOMHelpers.renderArbitrary(content), IncrementalDOM.elementClose("span")));
        iDOMHelpers.renderArbitrary(children.length && children);
        IncrementalDOM.elementClose(_PopoverBase["default"].Body);
        return IncrementalDOM.elementClose(_PopoverBase["default"]);
      }
    }, {
      key: "setPopoverWidth",
      value: function setPopoverWidth() {
        var element = this.element;
        element.style.visibility = 'hidden';
        element.style.display = 'block';
        var width = element.offsetHeight;
        element.style.visibility = 'visible';
        element.style.display = 'none';
        this.setState({
          width: width
        });
      }
    }, {
      key: "willReceiveProps",
      value: function willReceiveProps(_ref) {
        var visible = _ref.visible;

        if (visible) {
          this.setState({
            displayed: !!visible.newVal
          });
        }
      }
    }, {
      key: "_handleAlignElementClicked",
      value: function _handleAlignElementClicked() {
        var displayed = this.state.displayed;

        if (displayed) {
          this.emit('popoverClosed');
        }

        this.setState({
          displayed: !displayed
        });
      }
    }, {
      key: "_handleDocumentMouseDown",
      value: function _handleDocumentMouseDown(_ref2) {
        var target = _ref2.target;
        var alignElement = this.props.alignElement;
        var displayed = this.state.displayed;

        if (!this.element.contains(target) && !alignElement.contains(target) && displayed) {
          this.setState({
            displayed: false
          });
          this.emit('popoverClosed');
        }
      }
    }, {
      key: "_visibleValueFn",
      value: function _visibleValueFn() {
        return this.props.visible;
      }
    }]);

    return Popover;
  }(_metalJsx["default"]);

  Popover.PROPS = {
    alignElement: _metalJsx.Config.object(),
    content: _metalJsx.Config.string(),
    placement: _metalJsx.Config.number(),
    title: _metalJsx.Config.string(),
    visible: _metalJsx.Config.bool()
  };
  Popover.STATE = {
    displayed: _metalJsx.Config.bool().valueFn('_visibleValueFn'),
    position: _metalJsx.Config.string(),
    width: _metalJsx.Config.number().value(240)
  };
  var _default = Popover;
  exports["default"] = _default;
  //# sourceMappingURL=Popover.es.js.map
});
//# sourceMappingURL=Popover.es.js.map