/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.util;

import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextVisitor;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateResponse;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorFieldContextKey;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.web.FormInstanceFieldSettingsException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormInstanceFieldSettingsValidator.class})
public class DDMFormInstanceFieldSettingsValidator {
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public void validate(PortletRequest portletRequest, DDMForm ddmForm) throws PortalException {
        Map<String, Set<String>> fieldNamePropertiesMap = this.evaluate(portletRequest, ddmForm);
        if (!fieldNamePropertiesMap.isEmpty()) {
            throw new FormInstanceFieldSettingsException.MustSetValidValueForProperties(fieldNamePropertiesMap);
        }
    }

    protected DDMFormValues createDDMFormFieldFormValues(JSONObject jsonObject, DDMForm fieldSettingsDDMForm) {
        final DDMFormValues fieldSettingsDDMFormValues = new DDMFormValues(fieldSettingsDDMForm);
        final Locale defaultLocale = fieldSettingsDDMForm.getDefaultLocale();
        fieldSettingsDDMFormValues.setDefaultLocale(defaultLocale);
        final Set availableLocales = fieldSettingsDDMForm.getAvailableLocales();
        fieldSettingsDDMFormValues.setAvailableLocales(availableLocales);
        DDMFormContextVisitor ddmFormContextVisitor = new DDMFormContextVisitor(jsonObject.getJSONArray("pages"));
        ddmFormContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject jsonObject) {
                DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
                ddmFormFieldValue.setDDMFormValues(fieldSettingsDDMFormValues);
                ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
                ddmFormFieldValue.setName(jsonObject.getString("fieldName"));
                ddmFormFieldValue.setValue(this.getValue(jsonObject));
                fieldSettingsDDMFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            }

            protected LocalizedValue getLocalizedValue(String serializedValue, Set<Locale> availableLocales2, Locale defaultLocale2) {
                LocalizedValue localizedValue = new LocalizedValue(defaultLocale2);
                try {
                    JSONObject jsonObject = DDMFormInstanceFieldSettingsValidator.this._jsonFactory.createJSONObject(serializedValue);
                    String defaultValueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)defaultLocale2));
                    for (Locale availableLocale : availableLocales2) {
                        String valueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)availableLocale), defaultValueString);
                        localizedValue.addString(availableLocale, valueString);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return localizedValue;
            }

            protected Value getValue(JSONObject jsonObject) {
                boolean localizable = jsonObject.getBoolean("localizable", false);
                if (localizable) {
                    return this.getLocalizedValue(jsonObject.getString("localizedValue"), availableLocales, defaultLocale);
                }
                return new UnlocalizedValue(jsonObject.getString("value"));
            }
        });
        ddmFormContextVisitor.visit();
        return fieldSettingsDDMFormValues;
    }

    protected DDMFormEvaluatorEvaluateResponse doEvaluate(PortletRequest portletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        DDMFormEvaluatorEvaluateRequest.Builder builder = DDMFormEvaluatorEvaluateRequest.Builder.newBuilder((DDMForm)ddmForm, (DDMFormValues)ddmFormValues, (Locale)locale);
        builder.withCompanyId(this._portal.getCompanyId(portletRequest)).withGroupId(ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId")).withUserId(this._portal.getUserId(portletRequest));
        return this._ddmFormEvaluator.evaluate(builder.build());
    }

    protected Map<String, Set<String>> evaluate(final PortletRequest portletRequest, final DDMForm ddmForm) throws JSONException {
        final HashMap<String, Set<String>> fieldNamePropertiesMap = new HashMap<String, Set<String>>();
        final Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        String serializedFormBuilderContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"serializedFormBuilderContext");
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedFormBuilderContext);
        DDMFormContextVisitor ddmFormContextVisitor = new DDMFormContextVisitor(jsonObject.getJSONArray("pages"));
        ddmFormContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject jsonObject) {
                DDMFormValues fieldDDMFormValues;
                DDMFormEvaluatorEvaluateResponse ddmFormEvaluatorEvaluateResponse;
                DDMFormField field = (DDMFormField)ddmFormFieldsMap.get(jsonObject.getString("fieldName"));
                DDMFormFieldType ddmFormFieldType = DDMFormInstanceFieldSettingsValidator.this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(field.getType());
                DDMForm fieldDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
                Set<String> invalidDDMFormFields = DDMFormInstanceFieldSettingsValidator.this.getInvalidDDMFormFields(fieldDDMForm, ddmFormEvaluatorEvaluateResponse = DDMFormInstanceFieldSettingsValidator.this.doEvaluate(portletRequest, fieldDDMForm, fieldDDMFormValues = DDMFormInstanceFieldSettingsValidator.this.createDDMFormFieldFormValues(jsonObject.getJSONObject("settingsContext"), fieldDDMForm), ddmForm.getDefaultLocale()), fieldDDMForm.getDefaultLocale());
                if (!invalidDDMFormFields.isEmpty()) {
                    fieldNamePropertiesMap.put(DDMFormInstanceFieldSettingsValidator.this.getFieldLabel(field, ddmForm.getDefaultLocale()), invalidDDMFormFields);
                }
            }
        });
        ddmFormContextVisitor.visit();
        return fieldNamePropertiesMap;
    }

    protected String getFieldLabel(DDMFormField ddmFormField, Locale locale) {
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(locale);
    }

    protected Set<String> getInvalidDDMFormFields(DDMForm fieldDDMForm, DDMFormEvaluatorEvaluateResponse ddmFormEvaluatorEvaluateResponse, Locale locale) {
        Map ddmFormFieldsPropertyChanges = ddmFormEvaluatorEvaluateResponse.getDDMFormFieldsPropertyChanges();
        if (MapUtil.isEmpty((Map)ddmFormFieldsPropertyChanges)) {
            return Collections.emptySet();
        }
        HashSet<String> ddmFormFieldList = new HashSet<String>();
        Map ddmFormFieldsMap = fieldDDMForm.getDDMFormFieldsMap(true);
        Set entrySet = ddmFormFieldsPropertyChanges.entrySet();
        Stream stream = entrySet.stream();
        stream.forEach(entry -> {
            if (!MapUtil.getBoolean((Map)((Map)entry.getValue()), (String)"valid", (boolean)true)) {
                DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey = (DDMFormEvaluatorFieldContextKey)entry.getKey();
                DDMFormField propertyFormField = (DDMFormField)ddmFormFieldsMap.get(ddmFormFieldContextKey.getName());
                ddmFormFieldList.add(this.getFieldLabel(propertyFormField, locale));
            }
        });
        return ddmFormFieldList;
    }
}

