/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.web.internal.configuration.DDMFormWebConfiguration;
import com.liferay.dynamic.data.mapping.form.web.internal.configuration.activator.DDMFormWebConfigurationActivator;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordExporter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordExporterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordExporterResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "mvc.command.name=exportFormInstance"}, service={MVCResourceCommand.class})
public class ExportFormInstanceMVCResourceCommand
extends BaseMVCResourceCommand {
    @Reference
    private DDMFormInstanceRecordExporter _ddmFormInstanceRecordExporter;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unsetDDMFormWebConfigurationActivator")
    private volatile DDMFormWebConfigurationActivator _ddmFormWebConfigurationActivator;
    @Reference
    private DDMFormInstanceService _formInstanceService;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        String fileExtension = ParamUtil.getString((PortletRequest)resourceRequest, (String)"fileExtension");
        DDMFormWebConfiguration ddmFormWebConfiguration = this._ddmFormWebConfigurationActivator.getDDMFormWebConfiguration();
        if (StringUtil.equals((String)fileExtension, (String)"csv") && StringUtil.equals((String)ddmFormWebConfiguration.csvExport(), (String)"disabled")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long formInstanceId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"formInstanceId");
        DDMFormInstanceRecordExporterRequest.Builder builder = DDMFormInstanceRecordExporterRequest.Builder.newBuilder((long)formInstanceId, (String)fileExtension);
        DDMFormInstanceRecordExporterRequest ddmFormInstanceRecordExporterRequest = builder.withLocale(themeDisplay.getLocale()).withStatus(0).build();
        DDMFormInstanceRecordExporterResponse ddmFormInstanceRecordExporterResponse = this._ddmFormInstanceRecordExporter.export(ddmFormInstanceRecordExporterRequest);
        DDMFormInstance formInstance = this._formInstanceService.getFormInstance(formInstanceId);
        String fileName = formInstance.getName(themeDisplay.getLocale()) + '.' + fileExtension;
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (byte[])ddmFormInstanceRecordExporterResponse.getContent(), (String)MimeTypesUtil.getContentType((String)fileName));
    }

    protected void unsetDDMFormWebConfigurationActivator(DDMFormWebConfigurationActivator ddmFormWebConfigurationActivator) {
        this._ddmFormWebConfigurationActivator = null;
    }
}

