/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateResponse;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorFieldContextKey;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AddFormInstanceRecordMVCCommandHelper.class})
public class AddFormInstanceRecordMVCCommandHelper {
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;

    public void updateRequiredFieldsAccordingToVisibility(ActionRequest actionRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) throws Exception {
        List<DDMFormField> requiredFields = this.getRequiredFields(ddmForm);
        if (requiredFields.isEmpty()) {
            return;
        }
        DDMFormEvaluatorEvaluateResponse ddmFormEvaluatorEvaluateResponse = this.evaluate(actionRequest, ddmForm, ddmFormValues, locale);
        Set<String> invisibleFields = this.getInvisibleFields(ddmFormEvaluatorEvaluateResponse);
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(actionRequest);
        Set<String> fieldsFromDisabledPages = this.getFieldNamesFromDisabledPages(ddmFormEvaluatorEvaluateResponse, ddmFormLayout);
        invisibleFields.addAll(fieldsFromDisabledPages);
        if (invisibleFields.isEmpty()) {
            return;
        }
        this.removeRequiredProperty(invisibleFields, requiredFields);
    }

    protected DDMFormEvaluatorEvaluateResponse evaluate(ActionRequest actionRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) throws Exception {
        DDMFormEvaluatorEvaluateRequest.Builder builder = DDMFormEvaluatorEvaluateRequest.Builder.newBuilder((DDMForm)ddmForm, (DDMFormValues)ddmFormValues, (Locale)locale);
        builder.withCompanyId(this._portal.getCompanyId((PortletRequest)actionRequest)).withGroupId(ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId")).withUserId(this._portal.getUserId((PortletRequest)actionRequest));
        return this._ddmFormEvaluator.evaluate(builder.build());
    }

    protected DDMFormLayout getDDMFormLayout(ActionRequest actionRequest) throws PortalException {
        long formInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"formInstanceId");
        DDMFormInstance formInstance = this._ddmFormInstanceService.getFormInstance(formInstanceId);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(formInstance.getStructureId());
        return ddmStructure.getDDMFormLayout();
    }

    protected Set<String> getFieldNamesFromDisabledPages(DDMFormEvaluatorEvaluateResponse ddmFormEvaluatorEvaluateResponse, DDMFormLayout ddmFormLayout) {
        Set disabledPagesIndexes = ddmFormEvaluatorEvaluateResponse.getDisabledPagesIndexes();
        Stream disablePagesIndexesStream = disabledPagesIndexes.stream();
        Stream fieldsStream = disablePagesIndexesStream.map(index -> this.getFieldNamesFromPage((int)index, ddmFormLayout)).flatMap(field -> field.stream());
        return fieldsStream.collect(Collectors.toSet());
    }

    protected Set<String> getFieldNamesFromPage(int index, DDMFormLayout ddmFormLayout) {
        DDMFormLayoutPage ddmFormLayoutPage = ddmFormLayout.getDDMFormLayoutPage(index);
        List ddmFormLayoutRows = ddmFormLayoutPage.getDDMFormLayoutRows();
        HashSet<String> fieldNames = new HashSet<String>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                fieldNames.addAll(ddmFormLayoutColumn.getDDMFormFieldNames());
            }
        }
        return fieldNames;
    }

    protected Set<String> getInvisibleFields(DDMFormEvaluatorEvaluateResponse ddmFormEvaluatorEvaluateResponse) {
        Map ddmFormFieldsPropertyChanges = ddmFormEvaluatorEvaluateResponse.getDDMFormFieldsPropertyChanges();
        Set entrySet = ddmFormFieldsPropertyChanges.entrySet();
        Stream stream = entrySet.stream();
        return stream.filter(result -> !MapUtil.getBoolean((Map)((Map)result.getValue()), (String)"visible", (boolean)true)).map(result -> {
            DDMFormEvaluatorFieldContextKey ddmFormFieldContextKey = (DDMFormEvaluatorFieldContextKey)result.getKey();
            return ddmFormFieldContextKey.getName();
        }).collect(Collectors.toSet());
    }

    protected List<DDMFormField> getRequiredFields(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Collection ddmFormFields = ddmFormFieldsMap.values();
        Stream<Object> stream = ddmFormFields.stream();
        stream = stream.filter(ddmFormField -> ddmFormField.isRequired());
        return stream.collect(Collectors.toList());
    }

    protected void removeRequiredProperty(DDMFormField ddmFormField) {
        ddmFormField.setRequired(false);
    }

    protected void removeRequiredProperty(Set<String> invisibleFields, List<DDMFormField> requiredFields) {
        Stream<Object> stream = requiredFields.stream();
        stream = stream.filter(field -> invisibleFields.contains(field.getName()));
        stream.forEach(this::removeRequiredProperty);
    }
}

