/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.display.context;

import com.liferay.dynamic.data.mapping.form.web.internal.display.context.util.DDMFormWebRequestHelper;
import com.liferay.dynamic.data.mapping.form.web.internal.search.FormInstanceSearch;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.util.comparator.DDMFormInstanceModifiedDateComparator;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DDMFormBrowserDisplayContext {
    private String _displayStyle;
    private String _eventName;
    private FormInstanceSearch _formInstanceSearch;
    private Integer _formInstanceSearchTotal;
    private final DDMFormInstanceService _formInstanceService;
    private final DDMFormWebRequestHelper _formWebRequestHelper;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public DDMFormBrowserDisplayContext(DDMFormInstanceService formInstanceService, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._formInstanceService = formInstanceService;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        this._formWebRequestHelper = new DDMFormWebRequestHelper(this._httpServletRequest);
    }

    public String getClearResultsURL() throws PortletException {
        PortletURL clearResultsURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (Validator.isNotNull((String)this._eventName)) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectDDMForm"));
        return this._eventName;
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        final HttpServletRequest httpServletRequest = this._formWebRequestHelper.getRequest();
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMFormBrowserDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMFormBrowserDisplayContext.this.getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public FormInstanceSearch getFormInstanceSearch() throws PortalException {
        if (this._formInstanceSearch != null) {
            return this._formInstanceSearch;
        }
        String displayStyle = this.getDisplayStyle();
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("displayStyle", displayStyle);
        FormInstanceSearch formInstanceSearch = new FormInstanceSearch((PortletRequest)this._renderRequest, portletURL);
        String orderByType = this.getOrderByType();
        OrderByComparator<DDMFormInstance> orderByComparator = this._getDDMFormInstanceOrderByComparator(orderByType);
        String orderByCol = this.getOrderByCol();
        formInstanceSearch.setOrderByCol(orderByCol);
        formInstanceSearch.setOrderByComparator(orderByComparator);
        formInstanceSearch.setOrderByType(orderByType);
        if (formInstanceSearch.isSearch()) {
            formInstanceSearch.setEmptyResultsMessage("no-forms-were-found");
        } else {
            formInstanceSearch.setEmptyResultsMessage("there-are-no-forms");
        }
        List results = this._formInstanceService.search(this._formWebRequestHelper.getCompanyId(), this._formWebRequestHelper.getScopeGroupId(), this.getKeywords(), formInstanceSearch.getStart(), formInstanceSearch.getEnd(), formInstanceSearch.getOrderByComparator());
        formInstanceSearch.setResults(results);
        formInstanceSearch.setTotal(this.getTotalItems());
        this._formInstanceSearch = formInstanceSearch;
        return this._formInstanceSearch;
    }

    public String getKeywords() {
        if (Validator.isNotNull((String)this._keywords)) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public List<NavigationItem> getNavigationItems() {
        final HttpServletRequest httpServletRequest = this._formWebRequestHelper.getRequest();
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref(DDMFormBrowserDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/browser/view.jsp"});
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"entries"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/browser/view.jsp");
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("eventName", this.getEventName());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        String delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(displayStyle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"displayStyle")))) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/browser/view.jsp");
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("eventName", this.getEventName());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL.toString();
    }

    public String getSearchContainerId() {
        return "ddmFormInstance";
    }

    public String getSortingURL() throws Exception {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        sortingURL.setParameter("orderByType", orderByType.equals("asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() {
        if (this._formInstanceSearchTotal != null) {
            return this._formInstanceSearchTotal;
        }
        this._formInstanceSearchTotal = this._formInstanceService.searchCount(this._formWebRequestHelper.getCompanyId(), this._formWebRequestHelper.getScopeGroupId(), this.getKeywords());
        return this._formInstanceSearchTotal;
    }

    public boolean isDisabledManagementBar() {
        return this.getTotalItems() <= 0;
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(DDMFormBrowserDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMFormBrowserDisplayContext.this._formWebRequestHelper.getRequest(), (String)"all"));
                });
            }
        };
    }

    protected UnsafeConsumer<DropdownItem, Exception> getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(orderByCol.equals(this.getOrderByCol()));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._formWebRequestHelper.getRequest(), (String)orderByCol));
        };
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(DDMFormBrowserDisplayContext.this.getOrderByDropdownItem("modified-date"));
            }
        };
    }

    private OrderByComparator<DDMFormInstance> _getDDMFormInstanceOrderByComparator(String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        return new DDMFormInstanceModifiedDateComparator(orderByAsc);
    }
}

