/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.util;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseDDMFormMVCResourceCommand
extends BaseMVCResourceCommand {
    @Reference
    protected JSONFactory jsonFactory;

    public String formatDate(Date date, Locale locale, String timezoneId) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT);
        dateTimeFormatter = dateTimeFormatter.withLocale(locale);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.of(timezoneId));
        return dateTimeFormatter.format(localDateTime);
    }

    public void writeResponse(ResourceRequest resourceRequest, ResourceResponse resourceResponse, DDMFormInstance formInstance) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("ddmStructureId", formInstance.getStructureId());
        response.put("formInstanceId", formInstance.getFormInstanceId());
        User user = themeDisplay.getUser();
        response.put("modifiedDate", this.formatDate(formInstance.getModifiedDate(), user.getLocale(), user.getTimeZoneId()));
        JSONSerializer jsonSerializer = this.jsonFactory.createJSONSerializer();
        PortletResponseUtil.write((MimeResponse)resourceResponse, (String)jsonSerializer.serializeDeep(response));
    }
}

