/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.display.context;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.form.web.internal.display.context.util.DDMFormAdminRequestHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DDMFormViewFormInstanceRecordDisplayContext {
    private final DDMFormAdminRequestHelper _ddmFormAdminRequestHelper;
    private final DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    private final DDMFormInstanceVersionLocalService _ddmFormInstanceVersionLocalService;
    private final DDMFormRenderer _ddmFormRenderer;
    private final DDMFormValuesFactory _ddmFormValuesFactory;
    private final DDMFormValuesMerger _ddmFormValuesMerger;
    private final HttpServletResponse _httpServletResponse;

    public DDMFormViewFormInstanceRecordDisplayContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DDMFormInstanceRecordLocalService formInstanceRecordLocalService, DDMFormInstanceVersionLocalService formInstanceVersionLocalService, DDMFormRenderer formRenderer, DDMFormValuesFactory formValuesFactory, DDMFormValuesMerger formValuesMerger) {
        this._httpServletResponse = httpServletResponse;
        this._ddmFormInstanceRecordLocalService = formInstanceRecordLocalService;
        this._ddmFormInstanceVersionLocalService = formInstanceVersionLocalService;
        this._ddmFormRenderer = formRenderer;
        this._ddmFormValuesFactory = formValuesFactory;
        this._ddmFormValuesMerger = formValuesMerger;
        this._ddmFormAdminRequestHelper = new DDMFormAdminRequestHelper(httpServletRequest);
    }

    public String getDDMFormHTML(RenderRequest renderRequest) throws PortalException {
        DDMFormInstanceRecord formInstanceRecord = this.getDDMFormInstanceRecord();
        DDMFormInstance formInstance = formInstanceRecord.getFormInstance();
        DDMFormInstanceVersion formInstanceVersion = formInstance.getFormInstanceVersion(formInstanceRecord.getFormInstanceVersion());
        DDMStructureVersion structureVersion = formInstanceVersion.getStructureVersion();
        DDMFormRenderingContext formRenderingContext = this.createDDMFormRenderingContext(structureVersion.getDDMForm());
        DDMFormValues formValues = this.getDDMFormValues(renderRequest, formInstanceRecord, structureVersion);
        formRenderingContext.setDDMFormValues(formValues);
        formRenderingContext.setLocale(formValues.getDefaultLocale());
        DDMFormInstanceVersion latestApprovedFormInstanceVersion = this._ddmFormInstanceVersionLocalService.getLatestFormInstanceVersion(formInstance.getFormInstanceId(), 0);
        DDMStructureVersion latestApprovedStructureVersion = latestApprovedFormInstanceVersion.getStructureVersion();
        this.updateDDMFormFields(structureVersion.getDDMForm(), latestApprovedStructureVersion.getDDMForm());
        DDMFormLayout formLayout = structureVersion.getDDMFormLayout();
        return this._ddmFormRenderer.render(structureVersion.getDDMForm(), formLayout, formRenderingContext);
    }

    protected DDMFormRenderingContext createDDMFormRenderingContext(DDMForm ddmForm) {
        DDMFormRenderingContext formRenderingContext = new DDMFormRenderingContext();
        formRenderingContext.setHttpServletRequest(this._ddmFormAdminRequestHelper.getRequest());
        formRenderingContext.setHttpServletResponse(this._httpServletResponse);
        Set availableLocales = ddmForm.getAvailableLocales();
        Locale locale = ddmForm.getDefaultLocale();
        if (availableLocales.contains(this._ddmFormAdminRequestHelper.getLocale())) {
            locale = this._ddmFormAdminRequestHelper.getLocale();
        }
        formRenderingContext.setLocale(locale);
        formRenderingContext.setPortletNamespace(PortalUtil.getPortletNamespace((String)"com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet"));
        formRenderingContext.setReadOnly(true);
        return formRenderingContext;
    }

    protected DDMFormInstanceRecord getDDMFormInstanceRecord() throws PortalException {
        HttpServletRequest httpServletRequest = this._ddmFormAdminRequestHelper.getRequest();
        long formInstanceRecordId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"formInstanceRecordId");
        if (formInstanceRecordId > 0L) {
            return this._ddmFormInstanceRecordLocalService.fetchFormInstanceRecord(formInstanceRecordId);
        }
        DDMFormInstanceRecord formInstanceRecord = (DDMFormInstanceRecord)httpServletRequest.getAttribute("DYNAMIC_DATA_MAPPING_FORM_INSTANCE_RECORD");
        return formInstanceRecord;
    }

    protected DDMFormValues getDDMFormValues(RenderRequest renderRequest, DDMFormInstanceRecord formInstanceRecord, DDMStructureVersion structureVersion) throws PortalException {
        DDMFormValues formValues = formInstanceRecord.getDDMFormValues();
        DDMFormValues mergedFormValues = this._ddmFormValuesMerger.merge(formValues, this._ddmFormValuesFactory.create((PortletRequest)renderRequest, structureVersion.getDDMForm()));
        mergedFormValues.setAvailableLocales(formValues.getAvailableLocales());
        mergedFormValues.setDefaultLocale(formValues.getDefaultLocale());
        return mergedFormValues;
    }

    protected boolean isDDMFormFieldRemoved(Map<String, DDMFormField> latestFormFieldMap, String fieldName) {
        return !latestFormFieldMap.containsKey(fieldName);
    }

    protected void setDDMFormFieldRemovedLabel(DDMFormField formField) {
        Locale locale = this._ddmFormAdminRequestHelper.getLocale();
        LocalizedValue label = formField.getLabel();
        String labelString = label.getString(locale);
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        label.addString(locale, LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-removed", (Object)labelString, (boolean)false));
    }

    protected void updateDDMFormField(Map<String, DDMFormField> latestFormFieldMap, DDMFormField formField) {
        boolean removed = this.isDDMFormFieldRemoved(latestFormFieldMap, formField.getName());
        if (removed) {
            this.setDDMFormFieldRemovedLabel(formField);
        }
        formField.setReadOnly(true);
        for (DDMFormField nestedFormField : formField.getNestedDDMFormFields()) {
            this.updateDDMFormField(latestFormFieldMap, nestedFormField);
        }
    }

    protected void updateDDMFormFields(DDMForm currentForm, DDMForm latestForm) {
        if (Objects.equals(currentForm, latestForm)) {
            return;
        }
        Map latestDDMFormFieldMap = latestForm.getDDMFormFieldsMap(true);
        for (DDMFormField formField : currentForm.getDDMFormFields()) {
            this.updateDDMFormField(latestDDMFormFieldMap, formField);
        }
    }
}

