/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.values.factory.internal;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRequestParameterRetriever;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueRequestParameterRetriever;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormValuesFactory.class})
public class DDMFormValuesFactoryImpl
implements DDMFormValuesFactory {
    private static final int _DDM_FORM_FIELD_INDEX_INDEX = 2;
    private static final int _DDM_FORM_FIELD_INSTANCE_ID_INDEX = 1;
    private static final int _DDM_FORM_FIELD_NAME_INDEX = 0;
    private final DDMFormFieldValueRequestParameterRetriever _defaultDDMFormFieldValueRequestParameterRetriever = new DefaultDDMFormFieldValueRequestParameterRetriever();
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, DDMFormFieldValueRequestParameterRetriever> _serviceTrackerMap;

    public DDMFormValues create(HttpServletRequest httpServletRequest, DDMForm ddmForm) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        this.setDDMFormValuesAvailableLocales(httpServletRequest, ddmForm, ddmFormValues);
        this.setDDMFormValuesDefaultLocale(httpServletRequest, ddmForm, ddmFormValues);
        this.setDDMFormFieldValues(httpServletRequest, ddmFormValues);
        return ddmFormValues;
    }

    public DDMFormValues create(PortletRequest portletRequest, DDMForm ddmForm) {
        return this.create(this._portal.getHttpServletRequest(portletRequest), ddmForm);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMFormFieldValueRequestParameterRetriever.class, (String)"ddm.form.field.type.name");
    }

    protected void checkDDMFormFieldParameterNames(DDMForm ddmForm, Set<String> ddmFormFieldParameterNames) {
        if (ddmFormFieldParameterNames.isEmpty()) {
            ddmFormFieldParameterNames.addAll(this.createDefaultDDMFormFieldParameterNames(ddmForm));
            return;
        }
        this.checkDDMFormFieldParameterNames(ddmForm.getDDMFormFields(), "", ddmFormFieldParameterNames);
    }

    protected void checkDDMFormFieldParameterNames(List<DDMFormField> ddmFormFields, String parentDDMFormFieldParameterName, Set<String> ddmFormFieldParameterNames) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            Set<String> filteredDDMFormFieldParameterNames = this.filterDDMFormFieldParameterNames(ddmFormField, ddmFormFieldParameterNames);
            String ddmFormFieldParameterPrefix = this.getDDMFormFieldParameterPrefix(ddmFormField, parentDDMFormFieldParameterName);
            boolean containsDefaultDDMFormFieldParameterName = this.containsDefaultDDMFormFieldParameterName(filteredDDMFormFieldParameterNames, ddmFormFieldParameterPrefix);
            if (!ddmFormField.isTransient() && !containsDefaultDDMFormFieldParameterName) {
                String defaultDDMFormFieldParameterName = this.createDefaultDDMFormFieldParameterName(ddmFormField, parentDDMFormFieldParameterName);
                ddmFormFieldParameterNames.add(defaultDDMFormFieldParameterName);
            }
            for (String filteredDDMFormFieldParameterName : filteredDDMFormFieldParameterNames) {
                this.checkDDMFormFieldParameterNames(ddmFormField.getNestedDDMFormFields(), filteredDDMFormFieldParameterName, ddmFormFieldParameterNames);
            }
        }
    }

    protected boolean containsDefaultDDMFormFieldParameterName(Set<String> filteredDDMFormFieldParameterNames, String ddmFormFieldParameterPrefix) {
        for (String filteredDDMFormFieldParameterName : filteredDDMFormFieldParameterNames) {
            if (!filteredDDMFormFieldParameterName.startsWith(ddmFormFieldParameterPrefix)) continue;
            return true;
        }
        return false;
    }

    protected DDMFormFieldValue createDDMFormFieldValue(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, String ddmFormFieldParameterName, Map<String, DDMFormField> ddmFormFieldsMap) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        String[] lastDDMFormFieldParameterNameParts = this.getLastDDMFormFieldParameterNameParts(ddmFormFieldParameterName);
        String fieldName = this.getFieldName(lastDDMFormFieldParameterNameParts);
        ddmFormFieldValue.setName(fieldName);
        ddmFormFieldValue.setInstanceId(this.getFieldInstanceId(lastDDMFormFieldParameterNameParts));
        DDMFormField ddmFormField = ddmFormFieldsMap.get(fieldName);
        if (ddmFormField.isTransient()) {
            return ddmFormFieldValue;
        }
        if (ddmFormField.isLocalizable()) {
            this.setDDMFormFieldValueLocalizedValue(httpServletRequest, ddmFormField.getType(), ddmFormFieldParameterName, ddmFormField.getPredefinedValue(), ddmFormFieldValue, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale());
        } else {
            this.setDDMFormFieldValueUnlocalizedValue(httpServletRequest, ddmFormField.getType(), ddmFormFieldParameterName, ddmFormField.getPredefinedValue(), ddmFormFieldValue, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale());
        }
        return ddmFormFieldValue;
    }

    protected Map<String, DDMFormFieldValue> createDDMFormFieldValuesMap(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        HashMap<String, DDMFormFieldValue> ddmFormFieldValuesMap = new HashMap<String, DDMFormFieldValue>();
        Set<String> ddmFormFieldParameterNames = this.getDDMFormFieldParameterNames(httpServletRequest, ddmForm);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (String ddmFormFieldParameterName : ddmFormFieldParameterNames) {
            DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(httpServletRequest, ddmForm, ddmFormValues, ddmFormFieldParameterName, ddmFormFieldsMap);
            ddmFormFieldValuesMap.put(ddmFormFieldParameterName, ddmFormFieldValue);
        }
        return ddmFormFieldValuesMap;
    }

    protected String createDefaultDDMFormFieldParameterName(DDMFormField ddmFormField, String parentDefaultDDMFormFieldParameterName) {
        StringBundler sb = new StringBundler(7);
        if (Validator.isNotNull((String)parentDefaultDDMFormFieldParameterName)) {
            sb.append(parentDefaultDDMFormFieldParameterName);
            sb.append("#");
        }
        sb.append(ddmFormField.getName());
        sb.append("$");
        sb.append(StringUtil.randomString());
        sb.append("$");
        sb.append(0);
        return sb.toString();
    }

    protected Set<String> createDefaultDDMFormFieldParameterNames(DDMForm ddmForm) {
        TreeSet<String> defaultDDMFormFieldParameterNames = new TreeSet<String>();
        this.poupulateDefaultDDMFormFieldParameterNames(ddmForm.getDDMFormFields(), "", defaultDDMFormFieldParameterNames);
        return defaultDDMFormFieldParameterNames;
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected String extractPrefix(String ddmFormFieldParameterName) {
        return StringUtil.extractLast((String)ddmFormFieldParameterName, (String)"ddm$$");
    }

    protected String extractSuffix(String ddmFormFieldParameterName) {
        int pos = ddmFormFieldParameterName.lastIndexOf("$$");
        return ddmFormFieldParameterName.substring(0, pos);
    }

    protected Set<String> filterDDMFormFieldParameterNames(DDMFormField ddmFormField, Set<String> ddmFormFieldParameterNames) {
        HashSet<String> filteredDDMFormFieldParameterNames = new HashSet<String>();
        for (String ddmFormFieldParameterName : ddmFormFieldParameterNames) {
            String[] ddmFormFieldParameterNameParts = this.getLastDDMFormFieldParameterNameParts(ddmFormFieldParameterName);
            String fieldName = this.getFieldName(ddmFormFieldParameterNameParts);
            if (!fieldName.equals(ddmFormField.getName())) continue;
            filteredDDMFormFieldParameterNames.add(ddmFormFieldParameterName);
        }
        return filteredDDMFormFieldParameterNames;
    }

    protected String[] getDDMFormFieldParameterNameParts(String ddmFormFieldParameterName) {
        return StringUtil.split((String)ddmFormFieldParameterName, (String)"$");
    }

    protected Set<String> getDDMFormFieldParameterNames(HttpServletRequest httpServletRequest, DDMForm ddmForm) {
        TreeSet<String> ddmFormFieldParameterNames = new TreeSet<String>();
        Map parameterMap = httpServletRequest.getParameterMap();
        for (String parameterName : parameterMap.keySet()) {
            if (!this.isDDMFormFieldParameter(parameterName)) continue;
            ddmFormFieldParameterNames.addAll(this.getDDMFormFieldParameterNames(parameterName));
        }
        this.checkDDMFormFieldParameterNames(ddmForm, ddmFormFieldParameterNames);
        return ddmFormFieldParameterNames;
    }

    protected Set<String> getDDMFormFieldParameterNames(String ddmFormFieldParameterName) {
        TreeSet<String> ddmFormFieldParameterNames = new TreeSet<String>();
        ddmFormFieldParameterName = this.extractPrefix(ddmFormFieldParameterName);
        ddmFormFieldParameterName = this.extractSuffix(ddmFormFieldParameterName);
        ddmFormFieldParameterNames.add(ddmFormFieldParameterName);
        int pos = ddmFormFieldParameterName.indexOf("#");
        while (pos != -1) {
            ddmFormFieldParameterNames.add(ddmFormFieldParameterName.substring(0, pos));
            pos = ddmFormFieldParameterName.indexOf("#", pos + 1);
        }
        return ddmFormFieldParameterNames;
    }

    protected String getDDMFormFieldParameterPrefix(DDMFormField ddmFormField, String parentDDMFormFieldParameterName) {
        if (Validator.isNull((String)parentDDMFormFieldParameterName)) {
            return ddmFormField.getName();
        }
        return parentDDMFormFieldParameterName.concat("#").concat(ddmFormField.getName());
    }

    protected String getDDMFormFieldParameterValue(HttpServletRequest httpServletRequest, String fieldType, String ddmFormFieldParameterName, String defaultDDMFormFieldParameterValue, Locale locale) {
        StringBundler sb = new StringBundler(4);
        sb.append("ddm$$");
        sb.append(ddmFormFieldParameterName);
        sb.append("$$");
        sb.append(LocaleUtil.toLanguageId((Locale)locale));
        DDMFormFieldValueRequestParameterRetriever ddmFormFieldValueRequestParameterRetriever = this.getDDMFormFieldValueRequestParameterRetriever(fieldType);
        return ddmFormFieldValueRequestParameterRetriever.get(httpServletRequest, sb.toString(), GetterUtil.getString((String)defaultDDMFormFieldParameterValue));
    }

    protected int getDDMFormFieldValueIndex(String ddmFormFieldParameterName) {
        String[] lastDDMFormFieldParameterNameParts = this.getLastDDMFormFieldParameterNameParts(ddmFormFieldParameterName);
        return this.getFieldIndex(lastDDMFormFieldParameterNameParts);
    }

    protected DDMFormFieldValueRequestParameterRetriever getDDMFormFieldValueRequestParameterRetriever(String fieldType) {
        if (!this._serviceTrackerMap.containsKey((Object)fieldType)) {
            return this._defaultDDMFormFieldValueRequestParameterRetriever;
        }
        return (DDMFormFieldValueRequestParameterRetriever)this._serviceTrackerMap.getService((Object)fieldType);
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        Map<String, DDMFormFieldValue> ddmFormFieldValuesMap = this.createDDMFormFieldValuesMap(httpServletRequest, ddmForm, ddmFormValues);
        return this.getDDMFormFieldValues(ddmFormFieldValuesMap, ddmForm.getDDMFormFields());
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(Map<String, DDMFormFieldValue> ddmFormFieldValuesMap, List<DDMFormField> ddmFormFields) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        int i = 0;
        for (DDMFormField ddmFormField : ddmFormFields) {
            Set<String> entryKeys = this.getEntryKeys(ddmFormFieldValuesMap, "", ddmFormField.getName());
            for (String entryKey : entryKeys) {
                DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValuesMap.get(entryKey);
                int index = i + this.getDDMFormFieldValueIndex(entryKey);
                this.setNestedDDMFormFieldValues(ddmFormFieldValuesMap, ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue, entryKey);
                this.setDDMFormFieldValueAtIndex(ddmFormFieldValues, ddmFormFieldValue, index);
            }
            i = ddmFormFieldValues.size();
        }
        return ddmFormFieldValues;
    }

    protected Locale getDefaultLocale(HttpServletRequest httpServletRequest, Locale defaultLocale, Set<Locale> availableLocales) {
        Locale httpServletRequestLocale = LocaleUtil.fromLanguageId((String)LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest));
        if (availableLocales.contains(httpServletRequestLocale)) {
            return httpServletRequestLocale;
        }
        return defaultLocale;
    }

    protected String getEntryKeyPrefix(String parentEntryKey, String fieldNameFilter) {
        if (Validator.isNull((String)parentEntryKey)) {
            return "";
        }
        return parentEntryKey.concat("#").concat(fieldNameFilter);
    }

    protected Set<String> getEntryKeys(Map<String, DDMFormFieldValue> ddmFormFieldValuesMap, String parentEntryKey, String fieldNameFilter) {
        HashSet<String> entryKeys = new HashSet<String>();
        String entryKeyPrefix = this.getEntryKeyPrefix(parentEntryKey, fieldNameFilter);
        for (Map.Entry<String, DDMFormFieldValue> entry : ddmFormFieldValuesMap.entrySet()) {
            String key = entry.getKey();
            DDMFormFieldValue ddmFormFieldValue = entry.getValue();
            if (!key.startsWith(entryKeyPrefix) || !Objects.equals(ddmFormFieldValue.getName(), fieldNameFilter)) continue;
            entryKeys.add(key);
        }
        return entryKeys;
    }

    protected int getFieldIndex(String[] ddmFormFieldParameterNameParts) {
        return GetterUtil.getInteger((String)ddmFormFieldParameterNameParts[2]);
    }

    protected String getFieldInstanceId(String[] ddmFormFieldParameterNameParts) {
        return ddmFormFieldParameterNameParts[1];
    }

    protected String getFieldName(String[] ddmFormFieldParameterNameParts) {
        return ddmFormFieldParameterNameParts[0];
    }

    protected String getLastDDMFormFieldParameterName(String ddmFormFieldParameterName) {
        String lastDDMFormFieldParameterName = StringUtil.extractLast((String)ddmFormFieldParameterName, (String)"#");
        if (lastDDMFormFieldParameterName == null) {
            return ddmFormFieldParameterName;
        }
        return lastDDMFormFieldParameterName;
    }

    protected String[] getLastDDMFormFieldParameterNameParts(String ddmFormFieldParameterName) {
        String lastDDMFormFieldParameterName = this.getLastDDMFormFieldParameterName(ddmFormFieldParameterName);
        return this.getDDMFormFieldParameterNameParts(lastDDMFormFieldParameterName);
    }

    protected boolean isDDMFormFieldParameter(String parameterName) {
        return parameterName.startsWith("ddm$$");
    }

    protected void poupulateDefaultDDMFormFieldParameterNames(List<DDMFormField> ddmFormFields, String parentDefaultDDMFormFieldParameterName, Set<String> defaultDDMFormFieldParameterNames) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            String defaultDDMFormFieldParameterName = this.createDefaultDDMFormFieldParameterName(ddmFormField, parentDefaultDDMFormFieldParameterName);
            defaultDDMFormFieldParameterNames.add(defaultDDMFormFieldParameterName);
            this.poupulateDefaultDDMFormFieldParameterNames(ddmFormField.getNestedDDMFormFields(), defaultDDMFormFieldParameterName, defaultDDMFormFieldParameterNames);
        }
    }

    protected void setDDMFormFieldValueAtIndex(List<DDMFormFieldValue> ddmFormFieldValues, DDMFormFieldValue ddmFormFieldValue, int index) {
        if (ddmFormFieldValues.size() < index + 1) {
            for (int i = ddmFormFieldValues.size(); i <= index; ++i) {
                ddmFormFieldValues.add(new DDMFormFieldValue());
            }
        }
        ddmFormFieldValues.set(index, ddmFormFieldValue);
    }

    protected void setDDMFormFieldValueLocalizedValue(HttpServletRequest httpServletRequest, String fieldType, String ddmFormFieldParameterName, LocalizedValue predefinedValue, DDMFormFieldValue ddmFormFieldValue, Set<Locale> availableLocales, Locale defaultLocale) {
        LocalizedValue value = new LocalizedValue(defaultLocale);
        for (Locale availableLocale : availableLocales) {
            String ddmFormFieldParameterValue = this.getDDMFormFieldParameterValue(httpServletRequest, fieldType, ddmFormFieldParameterName, predefinedValue.getString(availableLocale), availableLocale);
            value.addString(availableLocale, ddmFormFieldParameterValue);
        }
        ddmFormFieldValue.setValue((Value)value);
    }

    protected void setDDMFormFieldValues(HttpServletRequest httpServletRequest, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(httpServletRequest, ddmFormValues.getDDMForm(), ddmFormValues);
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    protected void setDDMFormFieldValueUnlocalizedValue(HttpServletRequest httpServletRequest, String fieldType, String ddmFormFieldParameterName, LocalizedValue predefinedValue, DDMFormFieldValue ddmFormFieldValue, Set<Locale> availableLocales, Locale defaultLocale) {
        String ddmFormFieldParameterValue = this.getDDMFormFieldParameterValue(httpServletRequest, fieldType, ddmFormFieldParameterName, predefinedValue.getString(defaultLocale), defaultLocale);
        UnlocalizedValue value = new UnlocalizedValue(ddmFormFieldParameterValue);
        ddmFormFieldValue.setValue((Value)value);
    }

    protected void setDDMFormValuesAvailableLocales(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        Object[] availableLocalesString = ParamUtil.getStringValues((HttpServletRequest)httpServletRequest, (String)"availableLocales");
        if (ArrayUtil.isEmpty((Object[])availableLocalesString)) {
            ddmFormValues.addAvailableLocale(this.getDefaultLocale(httpServletRequest, ddmForm.getDefaultLocale(), ddmForm.getAvailableLocales()));
        } else {
            for (Object availableLocaleString : availableLocalesString) {
                ddmFormValues.addAvailableLocale(LocaleUtil.fromLanguageId((String)availableLocaleString));
            }
        }
    }

    protected void setDDMFormValuesDefaultLocale(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        ddmFormValues.setDefaultLocale(this.getDefaultLocale(httpServletRequest, ddmForm.getDefaultLocale(), ddmForm.getAvailableLocales()));
    }

    protected void setNestedDDMFormFieldValues(Map<String, DDMFormFieldValue> ddmFormFieldValuesMap, List<DDMFormField> nestedDDMFormFields, DDMFormFieldValue parentDDMFormFieldValue, String parentEntryKey) {
        int i = 0;
        for (DDMFormField nestedDDMFormField : nestedDDMFormFields) {
            Set<String> entryKeys = this.getEntryKeys(ddmFormFieldValuesMap, parentEntryKey, nestedDDMFormField.getName());
            for (String entryKey : entryKeys) {
                DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValuesMap.get(entryKey);
                int index = i + this.getDDMFormFieldValueIndex(entryKey);
                this.setNestedDDMFormFieldValues(ddmFormFieldValuesMap, nestedDDMFormField.getNestedDDMFormFields(), ddmFormFieldValue, entryKey);
                this.setDDMFormFieldValueAtIndex(parentDDMFormFieldValue.getNestedDDMFormFieldValues(), ddmFormFieldValue, index);
            }
            List parentNestedDDMFormFieldValues = parentDDMFormFieldValue.getNestedDDMFormFieldValues();
            i = parentNestedDDMFormFieldValues.size();
        }
    }
}

