Liferay.Loader.define('dynamic-data-mapping-form-report-web$lodash-es@4.17.15/_reorder', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import copyArray from './_copyArray.js';
  import isIndex from './_isIndex.js';

  /* Built-in method references for those with the same name as other `lodash` methods. */
  var nativeMin = Math.min;

  /**
   * Reorder `array` according to the specified indexes where the element at
   * the first index is assigned as the first element, the element at
   * the second index is assigned as the second element, and so on.
   *
   * @private
   * @param {Array} array The array to reorder.
   * @param {Array} indexes The arranged array indexes.
   * @returns {Array} Returns `array`.
   */
  function reorder(array, indexes) {
    var arrLength = array.length,
        length = nativeMin(indexes.length, arrLength),
        oldArray = copyArray(array);

    while (length--) {
      var index = indexes[length];
      array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
    }
    return array;
  }

  export default reorder;
});
//# sourceMappingURL=_reorder.js.map