"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-report-web$dom-helpers@3.4.0/style/getComputedStyle", ['module', 'exports', 'require', '@dynamic-data-mapping-form-report-web$babel/runtime/helpers/interopRequireDefault', '../util/camelizeStyle'], function (module, exports, require) {
  var define = undefined;
  var _interopRequireDefault = require("@dynamic-data-mapping-form-report-web$babel/runtime/helpers/interopRequireDefault");

  exports.__esModule = true;
  exports.default = _getComputedStyle;

  var _camelizeStyle = _interopRequireDefault(require("../util/camelizeStyle"));

  var rposition = /^(top|right|bottom|left)$/;
  var rnumnonpx = /^([+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|))(?!px)[a-z%]+$/i;

  function _getComputedStyle(node) {
    if (!node) throw new TypeError('No Element passed to `getComputedStyle()`');
    var doc = node.ownerDocument;
    return 'defaultView' in doc ? doc.defaultView.opener ? node.ownerDocument.defaultView.getComputedStyle(node, null) : window.getComputedStyle(node, null) : {
      //ie 8 "magic" from: https://github.com/jquery/jquery/blob/1.11-stable/src/css/curCSS.js#L72
      getPropertyValue: function getPropertyValue(prop) {
        var style = node.style;
        prop = (0, _camelizeStyle.default)(prop);
        if (prop == 'float') prop = 'styleFloat';
        var current = node.currentStyle[prop] || null;
        if (current == null && style && style[prop]) current = style[prop];

        if (rnumnonpx.test(current) && !rposition.test(prop)) {
          // Remember the original values
          var left = style.left;
          var runStyle = node.runtimeStyle;
          var rsLeft = runStyle && runStyle.left; // Put in the new values to get a computed value out

          if (rsLeft) runStyle.left = node.currentStyle.left;
          style.left = prop === 'fontSize' ? '1em' : current;
          current = style.pixelLeft + 'px'; // Revert the changed values

          style.left = left;
          if (rsLeft) runStyle.left = rsLeft;
        }

        return current;
      }
    };
  }

  module.exports = exports["default"];
});
//# sourceMappingURL=getComputedStyle.js.map