Liferay.Loader.define('dynamic-data-mapping-form-report-web$d3-time@1.0.10/dist/d3-time', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  // https://d3js.org/d3-time/ v1.0.10 Copyright 2018 Mike Bostock
  (function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) : typeof define === 'function' && define.amd ? define(['exports'], factory) : factory(global.d3 = global.d3 || {});
  })(this, function (exports) {
    'use strict';

    var t0 = new Date(),
        t1 = new Date();

    function newInterval(floori, offseti, count, field) {

      function interval(date) {
        return floori(date = new Date(+date)), date;
      }

      interval.floor = interval;

      interval.ceil = function (date) {
        return floori(date = new Date(date - 1)), offseti(date, 1), floori(date), date;
      };

      interval.round = function (date) {
        var d0 = interval(date),
            d1 = interval.ceil(date);
        return date - d0 < d1 - date ? d0 : d1;
      };

      interval.offset = function (date, step) {
        return offseti(date = new Date(+date), step == null ? 1 : Math.floor(step)), date;
      };

      interval.range = function (start, stop, step) {
        var range = [],
            previous;
        start = interval.ceil(start);
        step = step == null ? 1 : Math.floor(step);
        if (!(start < stop) || !(step > 0)) return range; // also handles Invalid Date
        do range.push(previous = new Date(+start)), offseti(start, step), floori(start); while (previous < start && start < stop);
        return range;
      };

      interval.filter = function (test) {
        return newInterval(function (date) {
          if (date >= date) while (floori(date), !test(date)) date.setTime(date - 1);
        }, function (date, step) {
          if (date >= date) {
            if (step < 0) while (++step <= 0) {
              while (offseti(date, -1), !test(date)) {} // eslint-disable-line no-empty
            } else while (--step >= 0) {
              while (offseti(date, +1), !test(date)) {} // eslint-disable-line no-empty
            }
          }
        });
      };

      if (count) {
        interval.count = function (start, end) {
          t0.setTime(+start), t1.setTime(+end);
          floori(t0), floori(t1);
          return Math.floor(count(t0, t1));
        };

        interval.every = function (step) {
          step = Math.floor(step);
          return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval : interval.filter(field ? function (d) {
            return field(d) % step === 0;
          } : function (d) {
            return interval.count(0, d) % step === 0;
          });
        };
      }

      return interval;
    }

    var millisecond = newInterval(function () {
      // noop
    }, function (date, step) {
      date.setTime(+date + step);
    }, function (start, end) {
      return end - start;
    });

    // An optimized implementation for this simple case.
    millisecond.every = function (k) {
      k = Math.floor(k);
      if (!isFinite(k) || !(k > 0)) return null;
      if (!(k > 1)) return millisecond;
      return newInterval(function (date) {
        date.setTime(Math.floor(date / k) * k);
      }, function (date, step) {
        date.setTime(+date + step * k);
      }, function (start, end) {
        return (end - start) / k;
      });
    };
    var milliseconds = millisecond.range;

    var durationSecond = 1e3;
    var durationMinute = 6e4;
    var durationHour = 36e5;
    var durationDay = 864e5;
    var durationWeek = 6048e5;

    var second = newInterval(function (date) {
      date.setTime(Math.floor(date / durationSecond) * durationSecond);
    }, function (date, step) {
      date.setTime(+date + step * durationSecond);
    }, function (start, end) {
      return (end - start) / durationSecond;
    }, function (date) {
      return date.getUTCSeconds();
    });
    var seconds = second.range;

    var minute = newInterval(function (date) {
      date.setTime(Math.floor(date / durationMinute) * durationMinute);
    }, function (date, step) {
      date.setTime(+date + step * durationMinute);
    }, function (start, end) {
      return (end - start) / durationMinute;
    }, function (date) {
      return date.getMinutes();
    });
    var minutes = minute.range;

    var hour = newInterval(function (date) {
      var offset = date.getTimezoneOffset() * durationMinute % durationHour;
      if (offset < 0) offset += durationHour;
      date.setTime(Math.floor((+date - offset) / durationHour) * durationHour + offset);
    }, function (date, step) {
      date.setTime(+date + step * durationHour);
    }, function (start, end) {
      return (end - start) / durationHour;
    }, function (date) {
      return date.getHours();
    });
    var hours = hour.range;

    var day = newInterval(function (date) {
      date.setHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setDate(date.getDate() + step);
    }, function (start, end) {
      return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationDay;
    }, function (date) {
      return date.getDate() - 1;
    });
    var days = day.range;

    function weekday(i) {
      return newInterval(function (date) {
        date.setDate(date.getDate() - (date.getDay() + 7 - i) % 7);
        date.setHours(0, 0, 0, 0);
      }, function (date, step) {
        date.setDate(date.getDate() + step * 7);
      }, function (start, end) {
        return (end - start - (end.getTimezoneOffset() - start.getTimezoneOffset()) * durationMinute) / durationWeek;
      });
    }

    var sunday = weekday(0);
    var monday = weekday(1);
    var tuesday = weekday(2);
    var wednesday = weekday(3);
    var thursday = weekday(4);
    var friday = weekday(5);
    var saturday = weekday(6);

    var sundays = sunday.range;
    var mondays = monday.range;
    var tuesdays = tuesday.range;
    var wednesdays = wednesday.range;
    var thursdays = thursday.range;
    var fridays = friday.range;
    var saturdays = saturday.range;

    var month = newInterval(function (date) {
      date.setDate(1);
      date.setHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setMonth(date.getMonth() + step);
    }, function (start, end) {
      return end.getMonth() - start.getMonth() + (end.getFullYear() - start.getFullYear()) * 12;
    }, function (date) {
      return date.getMonth();
    });
    var months = month.range;

    var year = newInterval(function (date) {
      date.setMonth(0, 1);
      date.setHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setFullYear(date.getFullYear() + step);
    }, function (start, end) {
      return end.getFullYear() - start.getFullYear();
    }, function (date) {
      return date.getFullYear();
    });

    // An optimized implementation for this simple case.
    year.every = function (k) {
      return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function (date) {
        date.setFullYear(Math.floor(date.getFullYear() / k) * k);
        date.setMonth(0, 1);
        date.setHours(0, 0, 0, 0);
      }, function (date, step) {
        date.setFullYear(date.getFullYear() + step * k);
      });
    };
    var years = year.range;

    var utcMinute = newInterval(function (date) {
      date.setUTCSeconds(0, 0);
    }, function (date, step) {
      date.setTime(+date + step * durationMinute);
    }, function (start, end) {
      return (end - start) / durationMinute;
    }, function (date) {
      return date.getUTCMinutes();
    });
    var utcMinutes = utcMinute.range;

    var utcHour = newInterval(function (date) {
      date.setUTCMinutes(0, 0, 0);
    }, function (date, step) {
      date.setTime(+date + step * durationHour);
    }, function (start, end) {
      return (end - start) / durationHour;
    }, function (date) {
      return date.getUTCHours();
    });
    var utcHours = utcHour.range;

    var utcDay = newInterval(function (date) {
      date.setUTCHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setUTCDate(date.getUTCDate() + step);
    }, function (start, end) {
      return (end - start) / durationDay;
    }, function (date) {
      return date.getUTCDate() - 1;
    });
    var utcDays = utcDay.range;

    function utcWeekday(i) {
      return newInterval(function (date) {
        date.setUTCDate(date.getUTCDate() - (date.getUTCDay() + 7 - i) % 7);
        date.setUTCHours(0, 0, 0, 0);
      }, function (date, step) {
        date.setUTCDate(date.getUTCDate() + step * 7);
      }, function (start, end) {
        return (end - start) / durationWeek;
      });
    }

    var utcSunday = utcWeekday(0);
    var utcMonday = utcWeekday(1);
    var utcTuesday = utcWeekday(2);
    var utcWednesday = utcWeekday(3);
    var utcThursday = utcWeekday(4);
    var utcFriday = utcWeekday(5);
    var utcSaturday = utcWeekday(6);

    var utcSundays = utcSunday.range;
    var utcMondays = utcMonday.range;
    var utcTuesdays = utcTuesday.range;
    var utcWednesdays = utcWednesday.range;
    var utcThursdays = utcThursday.range;
    var utcFridays = utcFriday.range;
    var utcSaturdays = utcSaturday.range;

    var utcMonth = newInterval(function (date) {
      date.setUTCDate(1);
      date.setUTCHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setUTCMonth(date.getUTCMonth() + step);
    }, function (start, end) {
      return end.getUTCMonth() - start.getUTCMonth() + (end.getUTCFullYear() - start.getUTCFullYear()) * 12;
    }, function (date) {
      return date.getUTCMonth();
    });
    var utcMonths = utcMonth.range;

    var utcYear = newInterval(function (date) {
      date.setUTCMonth(0, 1);
      date.setUTCHours(0, 0, 0, 0);
    }, function (date, step) {
      date.setUTCFullYear(date.getUTCFullYear() + step);
    }, function (start, end) {
      return end.getUTCFullYear() - start.getUTCFullYear();
    }, function (date) {
      return date.getUTCFullYear();
    });

    // An optimized implementation for this simple case.
    utcYear.every = function (k) {
      return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function (date) {
        date.setUTCFullYear(Math.floor(date.getUTCFullYear() / k) * k);
        date.setUTCMonth(0, 1);
        date.setUTCHours(0, 0, 0, 0);
      }, function (date, step) {
        date.setUTCFullYear(date.getUTCFullYear() + step * k);
      });
    };
    var utcYears = utcYear.range;

    exports.timeInterval = newInterval;
    exports.timeMillisecond = millisecond;
    exports.timeMilliseconds = milliseconds;
    exports.utcMillisecond = millisecond;
    exports.utcMilliseconds = milliseconds;
    exports.timeSecond = second;
    exports.timeSeconds = seconds;
    exports.utcSecond = second;
    exports.utcSeconds = seconds;
    exports.timeMinute = minute;
    exports.timeMinutes = minutes;
    exports.timeHour = hour;
    exports.timeHours = hours;
    exports.timeDay = day;
    exports.timeDays = days;
    exports.timeWeek = sunday;
    exports.timeWeeks = sundays;
    exports.timeSunday = sunday;
    exports.timeSundays = sundays;
    exports.timeMonday = monday;
    exports.timeMondays = mondays;
    exports.timeTuesday = tuesday;
    exports.timeTuesdays = tuesdays;
    exports.timeWednesday = wednesday;
    exports.timeWednesdays = wednesdays;
    exports.timeThursday = thursday;
    exports.timeThursdays = thursdays;
    exports.timeFriday = friday;
    exports.timeFridays = fridays;
    exports.timeSaturday = saturday;
    exports.timeSaturdays = saturdays;
    exports.timeMonth = month;
    exports.timeMonths = months;
    exports.timeYear = year;
    exports.timeYears = years;
    exports.utcMinute = utcMinute;
    exports.utcMinutes = utcMinutes;
    exports.utcHour = utcHour;
    exports.utcHours = utcHours;
    exports.utcDay = utcDay;
    exports.utcDays = utcDays;
    exports.utcWeek = utcSunday;
    exports.utcWeeks = utcSundays;
    exports.utcSunday = utcSunday;
    exports.utcSundays = utcSundays;
    exports.utcMonday = utcMonday;
    exports.utcMondays = utcMondays;
    exports.utcTuesday = utcTuesday;
    exports.utcTuesdays = utcTuesdays;
    exports.utcWednesday = utcWednesday;
    exports.utcWednesdays = utcWednesdays;
    exports.utcThursday = utcThursday;
    exports.utcThursdays = utcThursdays;
    exports.utcFriday = utcFriday;
    exports.utcFridays = utcFridays;
    exports.utcSaturday = utcSaturday;
    exports.utcSaturdays = utcSaturdays;
    exports.utcMonth = utcMonth;
    exports.utcMonths = utcMonths;
    exports.utcYear = utcYear;
    exports.utcYears = utcYears;

    Object.defineProperty(exports, '__esModule', { value: true });
  });
});
//# sourceMappingURL=d3-time.js.map