'use strict';
// 20.3.4.36 / 15.9.5.43 Date.prototype.toISOString()

Liferay.Loader.define('dynamic-data-mapping-form-report-web$core-js@2.6.11/modules/_date-to-iso-string', ['module', 'exports', 'require', './_fails'], function (module, exports, require) {
  var define = undefined;
  var fails = require('./_fails');
  var getTime = Date.prototype.getTime;
  var $toISOString = Date.prototype.toISOString;

  var lz = function (num) {
    return num > 9 ? num : '0' + num;
  };

  // PhantomJS / old WebKit has a broken implementations
  module.exports = fails(function () {
    return $toISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';
  }) || !fails(function () {
    $toISOString.call(new Date(NaN));
  }) ? function toISOString() {
    if (!isFinite(getTime.call(this))) throw RangeError('Invalid time value');
    var d = this;
    var y = d.getUTCFullYear();
    var m = d.getUTCMilliseconds();
    var s = y < 0 ? '-' : y > 9999 ? '+' : '';
    return s + ('00000' + Math.abs(y)).slice(s ? -6 : -4) + '-' + lz(d.getUTCMonth() + 1) + '-' + lz(d.getUTCDate()) + 'T' + lz(d.getUTCHours()) + ':' + lz(d.getUTCMinutes()) + ':' + lz(d.getUTCSeconds()) + '.' + (m > 99 ? m : '0' + lz(m)) + 'Z';
  } : $toISOString;
});
//# sourceMappingURL=_date-to-iso-string.js.map