Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.4/js/App.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', './components/card/Card.es', './components/chart/bar/BarChart.es', './components/chart/pie/PieChart.es', './components/empty-state/EmptyState.es', './utils/data.es', './utils/fieldTypes.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _Card = _interopRequireDefault(require("./components/card/Card.es"));

  var _BarChart = _interopRequireDefault(require("./components/chart/bar/BarChart.es"));

  var _PieChart = _interopRequireDefault(require("./components/chart/pie/PieChart.es"));

  var _EmptyState = _interopRequireDefault(require("./components/empty-state/EmptyState.es"));

  var _data = _interopRequireWildcard(require("./utils/data.es"));

  var _fieldTypes = _interopRequireDefault(require("./utils/fieldTypes.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var chartFactory = function chartFactory(type, values, totalEntries) {
    switch (type) {
      case 'checkbox_multiple':
        return _react["default"].createElement(_BarChart["default"], {
          data: (0, _data["default"])(values),
          totalEntries: totalEntries
        });

      case 'radio':
        return _react["default"].createElement(_PieChart["default"], {
          data: (0, _data["default"])(values),
          totalEntries: totalEntries
        });

      default:
        return null;
    }
  };

  var _default = function _default(_ref) {
    var data = _ref.data,
        fields = _ref.fields;
    var hasCards = false;
    var cards = fields.map(function (_ref2, index) {
      var name = _ref2.name,
          type = _ref2.type;

      var _ref3 = data[name] || {},
          _ref3$values = _ref3.values,
          values = _ref3$values === void 0 ? {} : _ref3$values;

      var totalEntries = (0, _data.sumTotalEntries)(values);
      var chart = chartFactory(type, values, totalEntries);

      if (chart === null) {
        return null;
      } else {
        hasCards = true;
      }

      var field = _objectSpread({
        name: name,
        type: type
      }, _fieldTypes["default"][type]);

      return _react["default"].createElement(_Card["default"], {
        field: field,
        key: index,
        totalEntries: totalEntries
      }, chart);
    });

    if (!hasCards) {
      return _react["default"].createElement(_EmptyState["default"], null);
    }

    return cards;
  };

  exports["default"] = _default;
  //# sourceMappingURL=App.es.js.map
});
//# sourceMappingURL=App.es.js.map