Liferay.Loader.define('dynamic-data-mapping-form-report-web$lodash-es@4.17.15/_createRound', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import root from './_root.js';
    import toInteger from './toInteger.js';
    import toNumber from './toNumber.js';
    import toString from './toString.js';

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeIsFinite = root.isFinite,
        nativeMin = Math.min;

    /**
     * Creates a function like `_.round`.
     *
     * @private
     * @param {string} methodName The name of the `Math` method to use when rounding.
     * @returns {Function} Returns the new round function.
     */
    function createRound(methodName) {
      var func = Math[methodName];
      return function (number, precision) {
        number = toNumber(number);
        precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
        if (precision && nativeIsFinite(number)) {
          // Shift with exponential notation to avoid floating-point issues.
          // See [MDN](https://mdn.io/round#Examples) for more details.
          var pair = (toString(number) + 'e').split('e'),
              value = func(pair[0] + 'e' + (+pair[1] + precision));

          pair = (toString(value) + 'e').split('e');
          return +(pair[0] + 'e' + (+pair[1] - precision));
        }
        return func(number);
      };
    }

    export default createRound;
  }
});
//# sourceMappingURL=_createRound.js.map