Liferay.Loader.define("dynamic-data-mapping-form-report-web$d3-scale@2.2.2/src/log", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { ticks } from "d3-array";
    import { format } from "d3-format";
    import nice from "./nice";
    import { copy, transformer } from "./continuous";
    import { initRange } from "./init";

    function transformLog(x) {
      return Math.log(x);
    }

    function transformExp(x) {
      return Math.exp(x);
    }

    function transformLogn(x) {
      return -Math.log(-x);
    }

    function transformExpn(x) {
      return -Math.exp(-x);
    }

    function pow10(x) {
      return isFinite(x) ? +("1e" + x) : x < 0 ? 0 : x;
    }

    function powp(base) {
      return base === 10 ? pow10 : base === Math.E ? Math.exp : function (x) {
        return Math.pow(base, x);
      };
    }

    function logp(base) {
      return base === Math.E ? Math.log : base === 10 && Math.log10 || base === 2 && Math.log2 || (base = Math.log(base), function (x) {
        return Math.log(x) / base;
      });
    }

    function reflect(f) {
      return function (x) {
        return -f(-x);
      };
    }

    export function loggish(transform) {
      var scale = transform(transformLog, transformExp),
          domain = scale.domain,
          base = 10,
          logs,
          pows;

      function rescale() {
        logs = logp(base), pows = powp(base);
        if (domain()[0] < 0) {
          logs = reflect(logs), pows = reflect(pows);
          transform(transformLogn, transformExpn);
        } else {
          transform(transformLog, transformExp);
        }
        return scale;
      }

      scale.base = function (_) {
        return arguments.length ? (base = +_, rescale()) : base;
      };

      scale.domain = function (_) {
        return arguments.length ? (domain(_), rescale()) : domain();
      };

      scale.ticks = function (count) {
        var d = domain(),
            u = d[0],
            v = d[d.length - 1],
            r;

        if (r = v < u) i = u, u = v, v = i;

        var i = logs(u),
            j = logs(v),
            p,
            k,
            t,
            n = count == null ? 10 : +count,
            z = [];

        if (!(base % 1) && j - i < n) {
          i = Math.round(i) - 1, j = Math.round(j) + 1;
          if (u > 0) for (; i < j; ++i) {
            for (k = 1, p = pows(i); k < base; ++k) {
              t = p * k;
              if (t < u) continue;
              if (t > v) break;
              z.push(t);
            }
          } else for (; i < j; ++i) {
            for (k = base - 1, p = pows(i); k >= 1; --k) {
              t = p * k;
              if (t < u) continue;
              if (t > v) break;
              z.push(t);
            }
          }
        } else {
          z = ticks(i, j, Math.min(j - i, n)).map(pows);
        }

        return r ? z.reverse() : z;
      };

      scale.tickFormat = function (count, specifier) {
        if (specifier == null) specifier = base === 10 ? ".0e" : ",";
        if (typeof specifier !== "function") specifier = format(specifier);
        if (count === Infinity) return specifier;
        if (count == null) count = 10;
        var k = Math.max(1, base * count / scale.ticks().length); // TODO fast estimate?
        return function (d) {
          var i = d / pows(Math.round(logs(d)));
          if (i * base < base - 0.5) i *= base;
          return i <= k ? specifier(d) : "";
        };
      };

      scale.nice = function () {
        return domain(nice(domain(), {
          floor: function (x) {
            return pows(Math.floor(logs(x)));
          },
          ceil: function (x) {
            return pows(Math.ceil(logs(x)));
          }
        }));
      };

      return scale;
    }

    export default function log() {
      var scale = loggish(transformer()).domain([1, 10]);

      scale.copy = function () {
        return copy(scale, log()).base(scale.base());
      };

      initRange.apply(scale, arguments);

      return scale;
    }
  }
});
//# sourceMappingURL=log.js.map