'use strict';

Liferay.Loader.define('dynamic-data-mapping-form-report-web$core-js@2.6.11/modules/es6.regexp.search', ['module', 'exports', 'require', './_an-object', './_same-value', './_regexp-exec-abstract', './_fix-re-wks'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var anObject = require('./_an-object');
    var sameValue = require('./_same-value');
    var regExpExec = require('./_regexp-exec-abstract');

    // @@search logic
    require('./_fix-re-wks')('search', 1, function (defined, SEARCH, $search, maybeCallNative) {
      return [
      // `String.prototype.search` method
      // https://tc39.github.io/ecma262/#sec-string.prototype.search
      function search(regexp) {
        var O = defined(this);
        var fn = regexp == undefined ? undefined : regexp[SEARCH];
        return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[SEARCH](String(O));
      },
      // `RegExp.prototype[@@search]` method
      // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@search
      function (regexp) {
        var res = maybeCallNative($search, regexp, this);
        if (res.done) return res.value;
        var rx = anObject(regexp);
        var S = String(this);
        var previousLastIndex = rx.lastIndex;
        if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
        var result = regExpExec(rx, S);
        if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
        return result === null ? -1 : result.index;
      }];
    });
  }
});
//# sourceMappingURL=es6.regexp.search.js.map