Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.19/js/utils/numeric.es", ['module', 'exports', 'require', './ellipsize.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.formatNumber = formatNumber;

    var _ellipsize = _interopRequireDefault(require("./ellipsize.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    var _MAX_DELIMITED_NUMBER_LENGTH = 10;
    var _THOUSANDS_DELIMITER_REGEX = /\B(?=(\d{3})+(?!\d))/g;

    function getDelimiter(key, defaultValue) {
      var delimiter = Liferay.Language.get(key);

      if (delimiter == key) {
        return defaultValue;
      }

      return delimiter;
    }

    function formatNumber(number, delimit) {
      var formattedNumber = number.toString();
      var formattedNumberParts = formattedNumber.split('.');
      var formattedDecimal = formattedNumberParts[1];
      var formattedInteger = formattedNumberParts[0].replace(_THOUSANDS_DELIMITER_REGEX, getDelimiter('thousands-delimiter', ','));
      formattedNumber = formattedInteger + (formattedDecimal && formattedDecimal != '0' ? getDelimiter('decimal-delimiter', '.') + formattedDecimal : '');

      if (delimit && formattedNumber.length > _MAX_DELIMITED_NUMBER_LENGTH) {
        formattedNumber = (0, _ellipsize["default"])(formattedNumber, _MAX_DELIMITED_NUMBER_LENGTH);
      }

      return formattedNumber;
    }
    //# sourceMappingURL=numeric.es.js.map
  }
});
//# sourceMappingURL=numeric.es.js.map