Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.19/js/components/chart/bar/MultiBarChart.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../../../utils/colors.es', '../../../utils/data.es', '../../../utils/ellipsize.es', '../TooltipContent.es', './CustomizedAxisTick.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _recharts = require("frontend-js-recharts$recharts");

    var _colors = _interopRequireWildcard(require("../../../utils/colors.es"));

    var _data = require("../../../utils/data.es");

    var _ellipsize = _interopRequireDefault(require("../../../utils/ellipsize.es"));

    var _TooltipContent = _interopRequireDefault(require("../TooltipContent.es"));

    var _CustomizedAxisTick = _interopRequireDefault(require("./CustomizedAxisTick.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var blueDark = _colors.NAMED_COLORS.blueDark,
        gray = _colors.NAMED_COLORS.gray;
    var MAX_LABEL_SIZE = 44;

    var _default = function _default(_ref) {
      var data = _ref.data,
          field = _ref.field,
          height = _ref.height,
          structure = _ref.structure,
          width = _ref.width;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          activeIndex = _useState2[0],
          setActiveIndex = _useState2[1];

      var getRowLabel = function getRowLabel(row) {
        return field.rows[row] ? field.rows[row].value : undefined;
      };

      var processedStructure = function processStructure(_ref2) {
        var columns = _ref2.columns,
            rows = _ref2.rows;
        return {
          columns: columns.filter(function (column) {
            return (0, _data.getColumnLabel)(column, field);
          }).sort(function (column1, column2) {
            return field.columns[column1].index - field.columns[column2].index;
          }),
          rows: rows.filter(function (row) {
            return getRowLabel(row);
          }).sort(function (row1, row2) {
            return field.rows[row1].index - field.rows[row2].index;
          })
        };
      }(structure);
      var columns = processedStructure.columns;

      var handleOnMouseOut = function handleOnMouseOut() {
        setActiveIndex(null);
      };

      var handleOnMouseOver = function handleOnMouseOver(activeIndex) {
        setActiveIndex(activeIndex);
      };

      data = processedStructure ? function processData(_ref3) {
        var columns = _ref3.columns,
            rows = _ref3.rows;
        var processedData = [];
        rows.map(function (row) {
          var newData = {
            label: getRowLabel(row),
            name: row
          };
          columns.map(function (column) {
            newData[column] = data[row][column] ? data[row][column] : 0;
          });
          processedData.push(newData);
        });
        return processedData;
      }(processedStructure) : data;

      return _react["default"].createElement(_recharts.ResponsiveContainer, {
        height: height || '99%',
        width: width || '99%'
      }, _react["default"].createElement(_recharts.BarChart, {
        data: data,
        layout: 'horizontal',
        margin: {
          bottom: 20,
          left: 20,
          right: 20,
          top: 20
        }
      }, _react["default"].createElement(_recharts.XAxis, {
        axisLine: {
          stroke: blueDark
        },
        dataKey: "label",
        interval: 0,
        tick: _react["default"].createElement(_CustomizedAxisTick["default"], {
          ticksNumber: structure.rows.length
        }),
        tickLine: false
      }), _react["default"].createElement(_recharts.YAxis, {
        axisLine: {
          stroke: gray
        },
        tickLine: false,
        type: "number"
      }), _react["default"].createElement(_recharts.Tooltip, {
        content: _react["default"].createElement(_TooltipContent["default"], {
          field: field,
          roundBullet: false
        }),
        cursor: {
          fill: 'transparent'
        }
      }), columns.map(function (row, index) {
        return _react["default"].createElement(_recharts.Bar, {
          dataKey: row,
          fill: (0, _colors["default"])(index),
          key: "bar-".concat(index),
          onMouseOut: handleOnMouseOut,
          onMouseOver: function onMouseOver(_, index) {
            return handleOnMouseOver(index);
          }
        }, data.map(function (_, index) {
          return _react["default"].createElement(_recharts.Cell, {
            fillOpacity: activeIndex != null && activeIndex != index ? '.5' : 1,
            key: "cell-".concat(index)
          });
        }));
      }), _react["default"].createElement(_recharts.Legend, {
        content: function renderLegend(props) {
          var payload = props.payload;
          return _react["default"].createElement("ul", {
            className: "bar-legend"
          }, payload.map(function (entry, index) {
            var label = (0, _data.getColumnLabel)(entry.value, field);
            return _react["default"].createElement("li", {
              key: "item-".concat(index)
            }, _react["default"].createElement("svg", {
              height: "12",
              width: "12"
            }, _react["default"].createElement("rect", {
              fill: entry.color,
              height: "12",
              width: "12"
            })), _react["default"].createElement("span", null, label && label.length > MAX_LABEL_SIZE ? (0, _ellipsize["default"])(label, MAX_LABEL_SIZE) : label));
          }));
        },
        iconType: "square",
        verticalAlign: "top"
      })));
    };

    exports["default"] = _default;
    //# sourceMappingURL=MultiBarChart.es.js.map
  }
});
//# sourceMappingURL=MultiBarChart.es.js.map