Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.20/js/store/actions/handleFieldRepeated.es", ['module', 'exports', 'require', '../../util/repeatable.es', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.updateNestedFieldNames = exports.createRepeatedField = void 0;

  var _repeatable = require("../../util/repeatable.es");

  var _visitors = require("../../util/visitors.es");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var createRepeatedField = function createRepeatedField(sourceField, repeatedIndex) {
    var instanceId = (0, _repeatable.generateInstanceId)();
    return _objectSpread({}, sourceField, {
      instanceId: instanceId,
      localizedValue: {},
      name: (0, _repeatable.generateName)(sourceField.name, {
        instanceId: instanceId,
        repeatedIndex: repeatedIndex
      }),
      nestedFields: (sourceField.nestedFields || []).map(function (nestedField) {
        return _objectSpread({}, nestedField, {
          localizedValue: {},
          value: undefined
        });
      }),
      value: undefined
    });
  };

  exports.createRepeatedField = createRepeatedField;

  var updateNestedFieldNames = function updateNestedFieldNames(parentFieldName, nestedFields) {
    return (nestedFields || []).map(function (nestedField) {
      var newNestedFieldName = (0, _repeatable.generateNestedFieldName)(nestedField.name, parentFieldName);
      return _objectSpread({}, nestedField, {
        name: newNestedFieldName,
        nestedFields: updateNestedFieldNames(newNestedFieldName, nestedField.nestedFields)
      }, (0, _repeatable.parseNestedFieldName)(newNestedFieldName));
    });
  };

  exports.updateNestedFieldNames = updateNestedFieldNames;

  var _default = function _default(pages, name) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapColumns(function (column) {
      var fields = column.fields;
      var sourceFieldIndex = fields.reduce(function () {
        var sourceFieldIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : -1;
        var field = arguments.length > 1 ? arguments[1] : undefined;
        var index = arguments.length > 2 ? arguments[2] : undefined;

        if (field.name === name) {
          sourceFieldIndex = index;
        }

        return sourceFieldIndex;
      }, -1);

      if (sourceFieldIndex > -1) {
        var newFieldIndex = sourceFieldIndex + 1;
        var newField = createRepeatedField(fields[sourceFieldIndex], newFieldIndex);
        var currentRepeatedIndex = 0;
        return _objectSpread({}, column, {
          fields: [].concat(_toConsumableArray(fields.slice(0, newFieldIndex)), [newField], _toConsumableArray(fields.slice(newFieldIndex))).map(function (currentField) {
            if (currentField.fieldName === newField.fieldName) {
              var _name = (0, _repeatable.generateName)(currentField.name, {
                repeatedIndex: currentRepeatedIndex++
              });

              return _objectSpread({}, currentField, {
                name: _name,
                nestedFields: updateNestedFieldNames(_name, currentField.nestedFields)
              });
            }

            return currentField;
          })
        });
      }

      return column;
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=handleFieldRepeated.es.js.map
});
//# sourceMappingURL=handleFieldRepeated.es.js.map