Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.20/js/store/actions/handleFieldEdited.es", ['module', 'exports', 'require', '../../util/evaluation.es', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _evaluation = require("../../util/evaluation.es");

  var _visitors = require("../../util/visitors.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var REVALIDATE_UPDATES = [];

  var getEditedPages = function getEditedPages(_ref) {
    var editingLanguageId = _ref.editingLanguageId,
        name = _ref.name,
        pages = _ref.pages,
        value = _ref.value;
    var pageVisitor = new _visitors.PagesVisitor(pages);
    return pageVisitor.mapFields(function (field) {
      if (field.name === name) {
        return _objectSpread({}, field, {
          localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, editingLanguageId, value)),
          value: value
        });
      }

      return field;
    }, false, true);
  };

  var _default = function _default(evaluatorContext, properties, updateState) {
    var fieldInstance = properties.fieldInstance,
        value = properties.value;
    var evaluable = fieldInstance.evaluable,
        fieldName = fieldInstance.fieldName;
    var editingLanguageId = evaluatorContext.editingLanguageId,
        pages = evaluatorContext.pages;
    var editedPages = getEditedPages({
      editingLanguageId: editingLanguageId,
      name: fieldInstance.name,
      pages: pages,
      value: value
    });
    updateState(editedPages);
    var promise = Promise.resolve(editedPages);

    if (evaluable) {
      promise = (0, _evaluation.evaluate)(fieldName, _objectSpread({}, evaluatorContext, {
        pages: editedPages
      })).then(function (evaluatedPages) {
        if (REVALIDATE_UPDATES.length > 0) {
          // All non-evaluable operations that were performed after the request
          // was sent are used here to revalidate the new data.
          REVALIDATE_UPDATES.forEach(function (item) {
            evaluatedPages = getEditedPages(_objectSpread({}, item, {
              pages: evaluatedPages
            }));
          }); // Redefine the list of updates to avoid leaking memory and avoid
          // more expensive operations in the next interactions

          REVALIDATE_UPDATES = [];
        }

        return evaluatedPages;
      });
    } else {
      REVALIDATE_UPDATES.push({
        editingLanguageId: editingLanguageId,
        name: fieldInstance.name,
        value: value
      });
    }

    return promise;
  };

  exports["default"] = _default;
  //# sourceMappingURL=handleFieldEdited.es.js.map
});
//# sourceMappingURL=handleFieldEdited.es.js.map