Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.20/js/components/PageRenderer/PageRenderer.es", ['module', 'exports', 'require', '../FormRenderer/FormSupport.es', './MultiPagesRenderer.soy', './PaginatedPageRenderer.soy', './SimplePageRenderer.soy', './TabbedPageRenderer.soy', './WizardPageRenderer.soy', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-dropdown', './PageRenderer.soy', 'frontend-taglib-clay$clay-modal', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../SuccessPage/SuccessPagePaginationItem.soy', '../SuccessPage/SuccessPageRenderer.soy', '../SuccessPage/SuccessPageWizardItem.soy', '../../util/i18n.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var FormSupport = _interopRequireWildcard(require("../FormRenderer/FormSupport.es"));

  require("./MultiPagesRenderer.soy");

  require("./PaginatedPageRenderer.soy");

  require("./SimplePageRenderer.soy");

  require("./TabbedPageRenderer.soy");

  require("./WizardPageRenderer.soy");

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-dropdown");

  var _PageRenderer = _interopRequireDefault(require("./PageRenderer.soy"));

  require("frontend-taglib-clay$clay-modal");

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("../SuccessPage/SuccessPagePaginationItem.soy");

  require("../SuccessPage/SuccessPageRenderer.soy");

  require("../SuccessPage/SuccessPageWizardItem.soy");

  var _i18n = require("../../util/i18n.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var PageRenderer =
  /*#__PURE__*/
  function (_Component) {
    _inherits(PageRenderer, _Component);

    function PageRenderer() {
      _classCallCheck(this, PageRenderer);

      return _possibleConstructorReturn(this, _getPrototypeOf(PageRenderer).apply(this, arguments));
    }

    _createClass(PageRenderer, [{
      key: "getPage",
      value: function getPage(page) {
        var editingLanguageId = this.editingLanguageId;

        if (_metal["default"].isObject(page.description)) {
          page = _objectSpread({}, page, {
            description: page.description[editingLanguageId]
          });
        }

        if (_metal["default"].isObject(page.title)) {
          page = _objectSpread({}, page, {
            title: page.title[editingLanguageId]
          });
        }

        return page;
      }
    }, {
      key: "isEmptyPage",
      value: function isEmptyPage(_ref) {
        var rows = _ref.rows;
        var empty = false;

        if (!rows || !rows.length) {
          empty = true;
        } else {
          empty = !rows.some(function (_ref2) {
            var columns = _ref2.columns;
            var hasFields = true;

            if (!columns) {
              hasFields = false;
            } else {
              hasFields = columns.some(function (column) {
                return column.fields.length;
              });
            }

            return hasFields;
          });
        }

        return empty;
      }
    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(states) {
        if (states.view === 'fieldSets') {
          this._updateSuccessPage({
            body: '',
            enabled: false,
            title: ''
          });
        }

        return _objectSpread({}, states, {
          empty: this.isEmptyPage(states.page),
          page: this.getPage(states.page),
          pageSettingsItems: this._pageSettingsItems(states.pages),
          pageSuccessSettingsItems: this._pageSuccessSettingsItems(states.pages)
        });
      }
    }, {
      key: "_addPage",
      value: function _addPage(pageIndex) {
        var dispatch = this.context.dispatch;
        dispatch('pageAdded', {
          pageIndex: pageIndex
        });
      }
    }, {
      key: "_addSuccessPage",
      value: function _addSuccessPage() {
        var dispatch = this.context.dispatch;
        var pages = this.pages;

        this._updateSuccessPage({
          body: Liferay.Language.get('your-information-was-successfully-received-thank-you-for-filling-out-the-form'),
          enabled: true,
          title: Liferay.Language.get('thank-you')
        });

        dispatch('activePageUpdated', pages.length);
      }
    }, {
      key: "_deletePage",
      value: function _deletePage() {
        var dispatch = this.context.dispatch;
        dispatch('pageDeleted', this.pageIndex);
      }
    }, {
      key: "_deleteSuccessPage",
      value: function _deleteSuccessPage() {
        var dispatch = this.context.dispatch;
        var pages = this.pages;

        this._updateSuccessPage({
          enabled: false
        });

        dispatch('activePageUpdated', pages.length - 1);
      }
    }, {
      key: "_resetPage",
      value: function _resetPage(pageIndex) {
        var dispatch = this.context.dispatch;
        dispatch('pageReset', {
          pageIndex: pageIndex
        });
      }
    }, {
      key: "_handleAddPageClicked",
      value: function _handleAddPageClicked() {
        var pageIndex = this.pageIndex;

        this._addPage(pageIndex);
      }
    }, {
      key: "_handleAddSuccessPageClicked",
      value: function _handleAddSuccessPageClicked() {
        var pageIndex = this.pageIndex;

        this._addSuccessPage(pageIndex);
      }
    }, {
      key: "_handleDropdownItemClicked",
      value: function _handleDropdownItemClicked(_ref3) {
        var data = _ref3.data;
        var pageIndex = this.pageIndex,
            successPageSettings = this.successPageSettings;
        var settingsItem = data.item.settingsItem;
        this.setState({
          dropdownExpanded: false
        });

        if (settingsItem === 'reset-page') {
          this._resetPage(pageIndex);
        } else if (settingsItem === 'remove-page') {
          if (successPageSettings.enabled && pageIndex == this.pages.length - 1) {
            this._deleteSuccessPage();
          } else {
            this._deletePage();
          }
        }
      }
    }, {
      key: "_handleFieldBlurred",
      value: function _handleFieldBlurred(event) {
        this.emit('fieldBlurred', event);
      }
    }, {
      key: "_handleFieldClicked",
      value: function _handleFieldClicked(event) {
        var delegateTarget = event.delegateTarget;
        var fieldName = delegateTarget.dataset.fieldName;
        event.stopPropagation();
        this.emit('fieldClicked', _objectSpread({}, FormSupport.getIndexes(_metalDom["default"].closest(delegateTarget, '.col-ddm')), {
          fieldName: fieldName,
          originalEvent: event
        }));
      }
    }, {
      key: "_handleFieldEdited",
      value: function _handleFieldEdited(event) {
        this.emit('fieldEdited', event);
      }
    }, {
      key: "_handleFieldFocused",
      value: function _handleFieldFocused(event) {
        this.emit('fieldFocused', event);
      }
    }, {
      key: "_pageSettingsItems",
      value: function _pageSettingsItems(pages) {
        var successPageSettings = this.successPageSettings;
        var pageSettingsItems = [{
          label: Liferay.Language.get('reset-page'),
          settingsItem: 'reset-page'
        }];

        if (successPageSettings.enabled && pages.length > 2 || pages.length > 1 && !successPageSettings.enabled) {
          pageSettingsItems.push({
            label: Liferay.Language.get('remove-page'),
            settingsItem: 'remove-page'
          });
        }

        return pageSettingsItems;
      }
    }, {
      key: "_pageSuccessSettingsItems",
      value: function _pageSuccessSettingsItems() {
        var pageSuccessSettingsItems = [{
          label: Liferay.Language.get('remove-success-page'),
          settingsItem: 'remove-page'
        }];
        return pageSuccessSettingsItems;
      }
    }, {
      key: "_updateSuccessPage",
      value: function _updateSuccessPage(_ref4) {
        var _ref4$body = _ref4.body,
            body = _ref4$body === void 0 ? '' : _ref4$body,
            enabled = _ref4.enabled,
            _ref4$title = _ref4.title,
            title = _ref4$title === void 0 ? '' : _ref4$title;
        var dispatch = this.context.dispatch;
        var editingLanguageId = this.editingLanguageId;
        var successPageSettings = {
          body: {},
          enabled: enabled,
          title: {}
        };
        (0, _i18n.setValue)(successPageSettings, editingLanguageId, 'body', body);
        (0, _i18n.setValue)(successPageSettings, editingLanguageId, 'title', title);
        dispatch('successPageChanged', successPageSettings);
      }
    }]);

    return PageRenderer;
  }(_metalComponent["default"]);

  PageRenderer.STATE = {
    /**
     * @instance
     * @memberof FormPage
     * @type {?number}
     */
    activePage: _metalState.Config.number().value(0),

    /**
     * @instance
     * @memberof FormPage
     * @type {?number}
     */
    dropdownExpanded: _metalState.Config.bool().value(false),

    /**
     * @instance
     * @memberof FormPage
     * @type {?boolean}
     */
    editable: _metalState.Config.bool().value(false),

    /**
     * @default []
     * @instance
     * @memberof FormRenderer
     * @type {?array<object>}
     */
    page: _metalState.Config.object(),

    /**
     * @default 1
     * @instance
     * @memberof FormPage
     * @type {?number}
     */
    pageIndex: _metalState.Config.number().value(0),

    /**
     * @default 1
     * @instance
     * @memberof FormPage
     * @type {?number}
     */
    pageSettingsItems: _metalState.Config.array(),

    /**
     * @default 1
     * @instance
     * @memberof FormPage
     * @type {?number}
     */
    pageSuccessSettingsItems: _metalState.Config.array(),

    /**
     * @default undefined
     * @instance
     * @memberof FormRenderer
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),
    strings: _metalState.Config.object().value({
      'success-page': Liferay.Language.get('success-page')
    }),
    successPageSettings: _metalState.Config.shapeOf({
      body: _metalState.Config.object(),
      enabled: _metalState.Config.bool(),
      title: _metalState.Config.object()
    }).value({})
  };

  _metalSoy["default"].register(PageRenderer, _PageRenderer["default"]);

  var _default = PageRenderer;
  exports["default"] = _default;
  //# sourceMappingURL=PageRenderer.es.js.map
});
//# sourceMappingURL=PageRenderer.es.js.map