/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.taglib.DDMFormFieldTypesDynamicInclude;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.taglib.DynamicIncludeUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.renderer.ComponentDescriptor;
import com.liferay.portal.template.soy.renderer.SoyComponentRenderer;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormRenderer.class})
public class DDMFormRendererImpl
implements DDMFormRenderer {
    private static final String _MODULE_NAME = "dynamic-data-mapping-form-renderer/js/containers/Form/Form.es";
    private static final String _TEMPLATE_NAMESPACE = "FormRenderer.render";
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private SoyComponentRenderer _soyComponentRenderer;

    public String render(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmFormRenderingException) {
            throw ddmFormRenderingException;
        }
        catch (Exception exception) {
            throw new DDMFormRenderingException((Throwable)exception);
        }
    }

    public String render(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmFormRenderingException) {
            throw ddmFormRenderingException;
        }
        catch (Exception exception) {
            throw new DDMFormRenderingException((Throwable)exception);
        }
    }

    protected String doRender(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws Exception {
        HashSet<String> dependencies = new HashSet<String>();
        List ddmFormFieldTypes = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypes();
        for (DDMFormFieldType ddmFormFieldType : ddmFormFieldTypes) {
            String moduleName = ddmFormFieldType.getModuleName();
            if (!Validator.isNotNull((String)moduleName)) continue;
            if (ddmFormFieldType.isCustomDDMFormFieldType()) {
                dependencies.add(moduleName);
                continue;
            }
            dependencies.add(this._npmResolver.resolveModuleName(moduleName));
        }
        ComponentDescriptor componentDescriptor = new ComponentDescriptor(_TEMPLATE_NAMESPACE, this._npmResolver.resolveModuleName(_MODULE_NAME), ddmFormRenderingContext.getContainerId(), dependencies);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        this._soyComponentRenderer.renderSoyComponent(ddmFormRenderingContext.getHttpServletRequest(), (Writer)writer, componentDescriptor, this.getContext(ddmForm, ddmFormLayout, ddmFormRenderingContext));
        DynamicIncludeUtil.include((HttpServletRequest)ddmFormRenderingContext.getHttpServletRequest(), (HttpServletResponse)ddmFormRenderingContext.getHttpServletResponse(), (String)DDMFormFieldTypesDynamicInclude.class.getName(), (boolean)true);
        DynamicIncludeUtil.include((HttpServletRequest)ddmFormRenderingContext.getHttpServletRequest(), (HttpServletResponse)ddmFormRenderingContext.getHttpServletResponse(), (String)(DDMFormRenderer.class.getName() + "#formRendered"), (boolean)true);
        return writer.toString();
    }

    protected Map<String, Object> getContext(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        Map ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        ddmFormTemplateContext.put("editable", false);
        ddmFormTemplateContext.remove("fieldTypes");
        HttpServletRequest httpServletRequest = ddmFormRenderingContext.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String pathThemeImages = themeDisplay.getPathThemeImages();
        String spriteMap = pathThemeImages.concat("/clay/icons.svg");
        ddmFormTemplateContext.put("spritemap", spriteMap);
        return ddmFormTemplateContext;
    }
}

