Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.69/js/store/withStore.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-builder/js/util/strings.es', 'frontend-js-web', 'frontend-js-metal-web$metal-dom', '../util/evaluation.es', '../util/visitors.es', './actions/handleActivePageUpdated.es', './actions/handleFieldBlurred.es', './actions/handleFieldEdited.es', './actions/handleFieldFocused.es', './actions/handleFieldRemoved.es', './actions/handleFieldRepeated.es', './actions/handleFormSubmitted.es', './actions/handlePaginationItemClicked.es', './actions/handlePaginationNextClicked.es', './actions/handlePaginationPreviousClicked.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _strings = require("dynamic-data-mapping-form-builder/js/util/strings.es");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _evaluation = require("../util/evaluation.es");

  var _visitors = require("../util/visitors.es");

  var _handleActivePageUpdated2 = _interopRequireDefault(require("./actions/handleActivePageUpdated.es"));

  var _handleFieldBlurred2 = _interopRequireDefault(require("./actions/handleFieldBlurred.es"));

  var _handleFieldEdited2 = _interopRequireDefault(require("./actions/handleFieldEdited.es"));

  var _handleFieldFocused2 = _interopRequireDefault(require("./actions/handleFieldFocused.es"));

  var _handleFieldRemoved2 = _interopRequireDefault(require("./actions/handleFieldRemoved.es"));

  var _handleFieldRepeated2 = _interopRequireDefault(require("./actions/handleFieldRepeated.es"));

  var _handleFormSubmitted2 = _interopRequireDefault(require("./actions/handleFormSubmitted.es"));

  var _handlePaginationItemClicked2 = _interopRequireDefault(require("./actions/handlePaginationItemClicked.es"));

  var _handlePaginationNextClicked2 = _interopRequireDefault(require("./actions/handlePaginationNextClicked.es"));

  var _handlePaginationPreviousClicked2 = _interopRequireDefault(require("./actions/handlePaginationPreviousClicked.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var REVALIDATE_UPDATES = [];
  var UPDATE_DELAY_MS = 50;
  var debounceFn = (0, _frontendJsWeb.debounce)(function (fn) {
    return fn();
  }, UPDATE_DELAY_MS);
  var lastEditedPages = [];

  var _handleFieldEdited = function _handleFieldEdited(properties) {
    var _this = this;

    var fieldInstance = properties.fieldInstance;

    if (fieldInstance.type === 'text' && this.viewMode) {
      _handleFieldEditedContext(this, properties);
    } else {
      debounceFn(function () {
        _handleFieldEditedContext(_this, properties);
      });
    }
  };

  var _handleFieldEditedContext = function _handleFieldEditedContext(currentInstance, properties) {
    var fieldInstance = properties.fieldInstance;
    var evaluable = fieldInstance.evaluable;
    var evaluatorContext = currentInstance.getEvaluatorContext();
    var editedPages = (0, _handleFieldEdited2["default"])(evaluatorContext, properties);
    lastEditedPages = editedPages;
    currentInstance.setState({
      pages: editedPages
    });

    if (evaluable) {
      (0, _evaluation.evaluate)(fieldInstance.fieldName, _objectSpread({}, evaluatorContext, {
        pages: editedPages
      })).then(function (evaluatedPages) {
        if (REVALIDATE_UPDATES.length > 0) {
          REVALIDATE_UPDATES.forEach(function (item) {
            var evaluatorContext = item.evaluatorContext,
                properties = item.properties;
            evaluatedPages = (0, _handleFieldEdited2["default"])(_objectSpread({}, evaluatorContext, {
              pages: evaluatedPages
            }), properties);
          });
          REVALIDATE_UPDATES = [];
        }

        if (fieldInstance.isDisposed()) {
          return;
        }

        var defaultLanguageId = evaluatorContext.defaultLanguageId,
            editingLanguageId = evaluatorContext.editingLanguageId;
        var mergedPages = (0, _evaluation.mergePages)(defaultLanguageId, editingLanguageId, fieldInstance.fieldName, evaluatedPages, lastEditedPages);
        currentInstance.setState({
          pages: mergedPages
        }, function () {
          if (evaluable) {
            currentInstance.emit('evaluated', mergedPages);
          }
        });
      })["catch"](function (error) {
        return currentInstance.emit('evaluationError', error);
      });
    } else {
      REVALIDATE_UPDATES.push({
        evaluatorContext: evaluatorContext,
        properties: properties
      });
    }
  };

  var _handleFieldBlurred = function _handleFieldBlurred(properties) {
    var _this2 = this;

    var fieldInstance = properties.fieldInstance;
    var pages = this.pages;
    var dateNow = new Date();
    (0, _handleFieldBlurred2["default"])(pages, properties).then(function (blurredFieldPages) {
      if (fieldInstance.isDisposed()) {
        return;
      }

      _this2.setState({
        pages: blurredFieldPages
      });
    });
    Liferay.fire('ddmFieldBlur', {
      fieldName: fieldInstance.fieldName,
      focusDuration: dateNow - (this.fieldFocusDate || dateNow),
      formId: this.getFormId(),
      page: this.activePage
    });
  };

  var _handleFieldFocused = function _handleFieldFocused(properties) {
    var _this3 = this;

    var fieldInstance = properties.fieldInstance;
    var pages = this.pages;
    this.fieldFocusDate = new Date();
    (0, _handleFieldFocused2["default"])(pages, properties).then(function (focusedFieldPages) {
      _this3.setState({
        pages: focusedFieldPages
      });
    });
    Liferay.fire('ddmFieldFocus', {
      fieldName: fieldInstance.fieldName,
      formId: this.getFormId(),
      page: this.activePage
    });
  };

  var _default = function _default(Component) {
    return (/*#__PURE__*/function (_Component) {
        _inherits(withStore, _Component);

        function withStore() {
          _classCallCheck(this, withStore);

          return _possibleConstructorReturn(this, _getPrototypeOf(withStore).apply(this, arguments));
        }

        _createClass(withStore, [{
          key: "attached",
          value: function attached() {
            _get(_getPrototypeOf(withStore.prototype), "attached", this).call(this);

            this.on('activePageUpdated', this._handleActivePageUpdated.bind(this));
            this.on('fieldBlurred', _handleFieldBlurred.bind(this));
            this.on('fieldEdited', _handleFieldEdited.bind(this));
            this.on('fieldFocused', _handleFieldFocused.bind(this));
            this.on('fieldRemoved', this._handleFieldRemoved.bind(this));
            this.on('fieldRepeated', this._handleFieldRepeated.bind(this));
            this.on('paginationItemClicked', this._handlePaginationItemClicked.bind(this));
            this.on('paginationNextClicked', this._handlePaginationNextClicked.bind(this));
            this.on('paginationPreviousClicked', this._handlePaginationPreviousClicked.bind(this));
            this.on('pageValidationFailed', this._handlePageValidationFailed.bind(this));
            var form = this.getFormNode();

            if (form) {
              _metalDom["default"].on(form, 'submit', this._handleFormSubmitted.bind(this));
            }

            Liferay.on('submitForm', this._handleLiferayFormSubmitted, this);
            Liferay.fire('ddmFormPageShow', {
              formId: this.getFormId(),
              page: this.activePage,
              title: this.pages[this.activePage].title
            });
          }
        }, {
          key: "dispatch",
          value: function dispatch(event, payload) {
            this.emit(event, payload);
          }
        }, {
          key: "evaluate",
          value: function evaluate() {
            return (0, _evaluation.evaluate)(null, this.getEvaluatorContext());
          }
        }, {
          key: "getChildContext",
          value: function getChildContext() {
            return {
              dispatch: this.dispatch.bind(this),
              store: this
            };
          }
        }, {
          key: "getEvaluatorContext",
          value: function getEvaluatorContext() {
            var defaultLanguageId = this.defaultLanguageId,
                editingLanguageId = this.editingLanguageId,
                pages = this.pages,
                portletNamespace = this.portletNamespace,
                rules = this.rules;
            return {
              defaultLanguageId: defaultLanguageId,
              editingLanguageId: editingLanguageId,
              pages: pages,
              portletNamespace: portletNamespace,
              rules: rules
            };
          }
        }, {
          key: "getFormId",
          value: function getFormId() {
            var form = this.getFormNode();
            return form && form.dataset.ddmforminstanceid;
          }
        }, {
          key: "getFormNode",
          value: function getFormNode() {
            return _metalDom["default"].closest(this.element, 'form');
          }
        }, {
          key: "toJSON",
          value: function toJSON() {
            var description = this.description,
                name = this.name,
                paginationMode = this.paginationMode,
                successPageSettings = this.successPageSettings;
            return _objectSpread({}, this.getEvaluatorContext(), {
              description: description,
              name: name,
              paginationMode: paginationMode,
              successPageSettings: successPageSettings
            });
          }
        }, {
          key: "_handleActivePageUpdated",
          value: function _handleActivePageUpdated(event) {
            this.setState((0, _handleActivePageUpdated2["default"])(event), function () {
              var currentPageTop = document.querySelector('.ddm-form-builder-app');
              currentPageTop.scrollIntoView();
            });
          }
        }, {
          key: "_handleFieldRemoved",
          value: function _handleFieldRemoved(name) {
            this.setState({
              pages: (0, _handleFieldRemoved2["default"])(this.pages, name)
            });
          }
        }, {
          key: "_handleFieldRepeated",
          value: function _handleFieldRepeated(name) {
            this.setState({
              pages: (0, _handleFieldRepeated2["default"])(this.pages, name)
            });
          }
        }, {
          key: "_handleFormSubmitted",
          value: function _handleFormSubmitted(event) {
            var _this4 = this;

            event.preventDefault();
            (0, _handleFormSubmitted2["default"])(this.getEvaluatorContext()).then(function (validForm) {
              if (validForm) {
                event.target.querySelectorAll('input[type=checkbox]').forEach(function (node) {
                  if (!node.hasAttribute('value')) {
                    if (node.checked) {
                      node.value = 'true';
                    } else {
                      var cloneNode = node.cloneNode();
                      cloneNode.type = 'hidden';
                      cloneNode.value = 'false';
                      node.after(cloneNode);
                    }
                  }
                });
                Liferay.Util.submitForm(event.target);
                Liferay.fire('ddmFormSubmit', {
                  formId: _this4.getFormId()
                });
              } else {
                _this4.dispatch('pageValidationFailed', _this4.activePage);
              }
            });
          }
        }, {
          key: "_handleLiferayFormSubmitted",
          value: function _handleLiferayFormSubmitted(event) {
            if (event.form && event.form.getDOM() === this.getFormNode()) {
              event.preventDefault();
            }
          }
        }, {
          key: "_handlePageValidationFailed",
          value: function _handlePageValidationFailed(pageIndex) {
            var pages = this.pages;
            var visitor = new _visitors.PagesVisitor(pages);
            var firstInvalidFieldLabel = null;
            var firstInvalidFieldInput = null;
            var updatedPages = visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, currentPageIndex) {
              var displayErrors = currentPageIndex === pageIndex;

              if (displayErrors && field.errorMessage != undefined && field.errorMessage != '' && !field.valid && firstInvalidFieldLabel == null) {
                firstInvalidFieldLabel = field.label;
                firstInvalidFieldInput = document.querySelector("[name='".concat(field.name, "']"));
              }

              return _objectSpread({}, field, {
                displayErrors: displayErrors
              });
            });
            this.setState({
              forceAriaUpdate: Date.now(),
              invalidFormMessage: (0, _strings.sub)(Liferay.Language.get('this-form-is-invalid-check-field-x'), [firstInvalidFieldLabel]),
              pages: updatedPages
            });

            if (firstInvalidFieldInput) {
              firstInvalidFieldInput.focus();
            }
          }
        }, {
          key: "_handlePaginationItemClicked",
          value: function _handlePaginationItemClicked(_ref) {
            var pageIndex = _ref.pageIndex;
            (0, _handlePaginationItemClicked2["default"])({
              pageIndex: pageIndex
            }, this.dispatch.bind(this));
          }
        }, {
          key: "_handlePaginationNextClicked",
          value: function _handlePaginationNextClicked() {
            var activePage = this.activePage;
            (0, _handlePaginationNextClicked2["default"])(_objectSpread({
              activePage: activePage,
              formId: this.getFormId()
            }, this.getEvaluatorContext()), this.dispatch.bind(this));
          }
        }, {
          key: "_handlePaginationPreviousClicked",
          value: function _handlePaginationPreviousClicked() {
            var activePage = this.activePage;
            (0, _handlePaginationPreviousClicked2["default"])(_objectSpread({
              activePage: activePage,
              formId: this.getFormId()
            }, this.getEvaluatorContext()), this.dispatch.bind(this));
          }
        }]);

        return withStore;
      }(Component)
    );
  };

  exports["default"] = _default;
  //# sourceMappingURL=withStore.es.js.map
});
//# sourceMappingURL=withStore.es.js.map